/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.context;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class Theme {
    private static final String USER_THEME = "UserTheme";
    private static final String GLOBAL_THEMES = "GlobalThemes";
    public static final String CUSTOM_THEME = "CustomTheme";

    public static String getSelectedName(String channel, ProviderContext pc) throws ProviderContextException {
        return pc.getStringProperty(channel, USER_THEME);
    }

    public static Collection getGlobal(String channel, ProviderContext pc) throws ProviderContextException {
        return pc.getCollectionProperty(channel, GLOBAL_THEMES).keySet();
    }

    public static Map getMap(String channel, ProviderContext pc, String theme) throws ProviderContextException {
        Map themeMap = null;
        Map themesMap = pc.getCollectionProperty(channel, GLOBAL_THEMES);
        themeMap = theme.equals(CUSTOM_THEME) ? pc.getCollectionProperty(channel, theme) : (Map)themesMap.get(theme);
        if (themeMap == null) {
            pc.debugError("Theme.getMap(): Selected Theme no longer exists.Returning the first available");
            Iterator i = themesMap.keySet().iterator();
            if (i.hasNext()) {
                String key = (String)i.next();
                themeMap = (Map)themesMap.get(key);
                Theme.setSelectedName(channel, pc, key);
                return themeMap;
            }
        }
        return themeMap;
    }

    public static String getAttribute(String channel, ProviderContext pc, String theme, String name) throws ProviderContextException {
        return (String)Theme.getMap(channel, pc, theme).get(name);
    }

    public static String getAttribute(String channel, ProviderContext pc, String name) throws ProviderContextException {
        return (String)Theme.getMap(channel, pc, Theme.getSelectedName(channel, pc)).get(name);
    }

    public static void setCustomAttribute(String channel, ProviderContext pc, String name, String value) {
        try {
            Map customThemeMap = pc.getCollectionProperty(channel, CUSTOM_THEME);
            customThemeMap.put(name, value);
            pc.setCollectionProperty(channel, CUSTOM_THEME, customThemeMap);
            pc.allContentChanged();
        }
        catch (ProviderContextException pce) {
            pc.debugError("Theme.setCustomAttribute(): Could not set theme attribute " + pce);
        }
    }

    public static void setSelectedName(String channel, ProviderContext pc, String name) throws ProviderContextException {
        pc.setStringProperty(channel, USER_THEME, name);
        pc.allContentChanged();
    }
}

