/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.jsp.tab;

import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.JSPContainerProviderAdapter;
import com.sun.portal.providers.containers.jsp.tab.ModifiableTab;
import com.sun.portal.providers.containers.jsp.tab.TabContainer;
import com.sun.portal.providers.containers.jsp.tab.UnmodifiableTab;
import com.sun.portal.providers.containers.jsp.tab.util.TabData;
import com.sun.portal.providers.containers.jsp.tab.util.TabException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPTabContainerProvider
extends JSPContainerProviderAdapter
implements TabContainer {
    private TabData tabdata = null;
    private ResourceBundle bundle = null;
    private Map tabPropsMap = null;
    private String channel = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.channel = this.getName();
        this.bundle = this.getResourceBundle();
        this.tabdata = new TabData(this.getContainerProviderContext(), this.channel, this.bundle);
        this.tabPropsMap = this.getMapProperty("TabProperties");
    }

    public List getSelectedChannels() throws ProviderException {
        return super.getSelectedChannels();
    }

    public List getAvailableChannels() throws ProviderException {
        return super.getAvailableChannels();
    }

    public void setSelectedChannels(List sel) throws ProviderException {
        super.setSelectedChannels(sel);
    }

    public void setAvailableChannels(List avail) throws ProviderException {
        super.setAvailableChannels(avail);
    }

    public int getMaxTabs() throws ProviderException {
        try {
            return this.tabdata.getMaxTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMaxTabs():couldn't get maxTabs", te);
        }
    }

    public List getSelectedTabs() throws ProviderException {
        List tabs = new ArrayList();
        try {
            tabs = this.tabdata.getSelectedTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTabs():couldn't get selectedtabs", te);
        }
        return tabs;
    }

    public List getAvailableTabs() throws ProviderException {
        List tabs = new ArrayList();
        try {
            tabs = this.tabdata.getAvailableTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getAvailableTabs():couldn't get available tabs", te);
        }
        return tabs;
    }

    public UnmodifiableTab getStartTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getStartTab();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getStartTab():couldn't get start tab", te);
        }
        return t;
    }

    public String getStartTabName() throws ProviderException {
        try {
            return this.tabdata.getStartTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getStartTabName():couldn't get start tab name ", te);
        }
    }

    public UnmodifiableTab getMakeTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getMakeTab();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMakeTab():couldn't get make tab", te);
        }
        return t;
    }

    public String getMakeTabName() throws ProviderException {
        try {
            return this.tabdata.getMakeTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMakeTabName():couldn't get make tab name ", te);
        }
    }

    public String getMakeTabProviderName() throws ProviderException {
        try {
            return this.tabdata.getMakeTabProviderName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMakeTabProvider Name():couldn't get make tab provider name ", te);
        }
    }

    public String getSelectedTabName() throws ProviderException {
        String name = null;
        try {
            name = this.tabdata.getSelectedTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTabName():couldn't get the selected tab name", te);
        }
        return name;
    }

    public UnmodifiableTab getSelectedTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getSelectedTab();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTab():couldn't get selected tab", te);
        }
        return t;
    }

    public UnmodifiableTab getTab(String name) throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getTab(name);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getTab():couldn't get the tab:name=" + name, te);
        }
        return t;
    }

    public void setTab(ModifiableTab t) throws ProviderException {
        this.setTab(t, false);
    }

    public void setTab(ModifiableTab t, boolean selected) throws ProviderException {
        try {
            this.tabdata.setTab(t, selected);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.setTab():couldn't set the tab", te);
        }
    }

    public void setStartTabName() throws ProviderException {
        this.setStartTabName(this.getSelectedTabName());
    }

    public void setStartTabName(UnmodifiableTab t) throws ProviderException {
        this.setStartTabName(t.getName());
    }

    public void setStartTabName(String name) throws ProviderException {
        try {
            this.tabdata.setStartTabName(name);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.setStartTabName():attempt to set start to non-existent tab", te);
        }
    }

    public void setSelectedTab(ModifiableTab t) throws ProviderException {
        this.setSelectedTabName(t.getName());
    }

    public void setSelectedTabName(String tabName) throws ProviderException {
        try {
            this.tabdata.setSelectedTabName(tabName);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.setSelectedTabName():attempt to set selected to non-existent tab", te);
        }
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String selected = this.getProviderContext().decodeURLParameter(req.getParameter(this.getName() + ".setSelected"));
        if (selected != null && selected.length() > 0) {
            this.setSelectedTabName(selected);
        }
        return super.getContent(req, res);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        try {
            this.tabdata.removeRenameTab(req);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.processEdit():couldn't remove/rename tab", te);
        }
        String makeparam = req.getParameter(this.getName() + ".make");
        if (makeparam != null && makeparam.equals("make")) {
            try {
                boolean make;
                Map results = this.tabdata.makeNewTab(req);
                if (results != null && (make = ((Boolean)results.get("make")).booleanValue())) {
                    ModifiableTab tab = (ModifiableTab)results.get("tab");
                    URL url = this.getContentURL(tab, req);
                    return url;
                }
            }
            catch (InvalidEditFormDataException e) {
                if (this.getProviderContext().isDebugWarningEnabled()) {
                    this.getProviderContext().debugWarning("JSPTabContainerProvider.processEdit()", e);
                }
                String error = this.getProviderContext().encodeURLParameter(e.getMessage());
                StringBuffer args = new StringBuffer(64);
                args.append("?action=edit&provider=").append(this.getName()).append("&error=").append(error).append("&page=make");
                try {
                    URL url = new URL(this.getProviderContext().getDesktopURL(req) + args.toString());
                    return url;
                }
                catch (MalformedURLException me) {
                    this.getProviderContext().debugError("JSPTabContainerProvider.processEdit()", me);
                    return null;
                }
            }
        }
        return null;
    }

    public URL getTabURL(UnmodifiableTab tab, HttpServletRequest req) throws ProviderException {
        URL url = null;
        try {
            url = this.tabdata.getTabURL(tab, req);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.processEdit():couldn't get the desktop URL", te);
        }
        return url;
    }

    public void removeTab(String name) throws ProviderException {
        try {
            this.tabdata.removeTab(name);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.removeTab():couldn't remove tab from the selected tab", te);
        }
    }

    public void addTab(String name, String title) throws ProviderException {
        try {
            this.tabdata.addTab(name, title);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.addTab():couldn't add tab to the selected tab", te);
        }
    }

    public URL getContentURL(ModifiableTab tab, HttpServletRequest req) throws ProviderException {
        URL url = null;
        String contentChannel = this.getStringProperty("contentChannel");
        try {
            StringBuffer urlbuffer = new StringBuffer(this.getContainerProviderContext().getDesktopURL(req));
            urlbuffer.append("?action=edit&provider=");
            urlbuffer.append(contentChannel);
            urlbuffer.append("&container=");
            urlbuffer.append(tab.getName());
            urlbuffer.append("&selected=");
            urlbuffer.append(this.getProviderContext().encodeURLParameter(tab.getDisplayname()));
            url = new URL(urlbuffer.toString());
        }
        catch (MalformedURLException me) {
            throw new ProviderException("TabContainerProvider.getContentURL():couldn't create the url", me);
        }
        return url;
    }
}

