/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.BasicAuthentication;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSSLSocketFactory;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.JSSProxyRunnable;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServerCertApprovalCallback;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.StringTokenizer;

public class HTTPSRetriever
extends HTTPRetriever {
    private static final String DEFAULT_SSL_PORT = "443";
    public static String currentReqHost;
    private static String rpSubdomain;
    private static String rpDomain;
    public static int jssProxyPort;
    private static boolean doBasicAuthentication;

    public byte[] getServerCertificate() {
        return null;
    }

    public Response getResponse2(Request req, String destinationHost, Integer logId, byte[] param) {
        Response result;
        CachedSocket s;
        block32: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = HTTPRetriever.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                int to;
                int i = 0;
                while (i < 2) {
                    ServerCertApprovalCallback serverCertApprovalCB;
                    result = new HTTPResponse();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPSRetriever retrieving " + req);
                    }
                    if (req.getUseProxy()) {
                        serverCertApprovalCB = new ServerCertApprovalCallback(req.getHost());
                        s = CachedSSLSocketFactory.createSocket("localhost", jssProxyPort, "ssl", logId, serverCertApprovalCB);
                        Integer localport = new Integer(s.getLocalPort());
                        JSSProxyRunnable.connectHashMap.put(localport, req);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPSRetriever: Connecting to " + req.getProxyHost());
                        }
                    } else {
                        serverCertApprovalCB = null;
                        serverCertApprovalCB = ServerCertApprovalCallback.getInstance();
                        s = CachedSSLSocketFactory.createSocket(req.getHost(), Integer.parseInt(req.getPort()), "ssl", logId, serverCertApprovalCB);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPSRetriever: Connecting to: " + req.getHost());
                        }
                    }
                    if (s == null) {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                        }
                        return null;
                    }
                    this.ForceSSLHandshake(req, s);
                    try {
                        this.sendRequest2(req, s, param);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    catch (Exception e) {
                        ServerCertApprovalCallback serverCertApprovalCB2;
                        if (req.getUseProxy()) {
                            serverCertApprovalCB2 = new ServerCertApprovalCallback(req.getHost());
                            s = CachedSSLSocketFactory.createSocket("localhost", jssProxyPort, "ssl", logId, serverCertApprovalCB2);
                            Integer localport = new Integer(s.getLocalPort());
                            JSSProxyRunnable.connectHashMap.put(localport, req);
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("HTTPSRetriever: Connecting to " + req.getProxyHost());
                            }
                        } else {
                            serverCertApprovalCB2 = null;
                            serverCertApprovalCB2 = ServerCertApprovalCallback.getInstance();
                            s = CachedSSLSocketFactory.createSocket(req.getHost(), Integer.parseInt(req.getPort()), "ssl", logId, serverCertApprovalCB2);
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("HTTPSRetriever: Connecting to: " + req.getHost());
                            }
                        }
                        this.sendRequest2(req, s, param);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    if (!doBasicAuthentication || i != 0) break;
                    if (result.getStatusCode().compareTo("401") == 0) {
                        if (password == null || !BasicAuthentication.getPassword(req, destinationHost)) {
                            break;
                        }
                    } else {
                        if (password == null) break;
                        BasicAuthentication.storePassword(req, destinationHost);
                        break;
                    }
                    ++i;
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                String ka = result.getResponseHeader("keep-alive");
                if (ka != null && (to = Integer.parseInt(ka.substring(ka.indexOf("timeout=") + 8, ka.indexOf(44)))) > 0) {
                    s.setTimeout(to);
                }
                if (result.getResponseHeader("Connection: close") != null) {
                    in.setClosed();
                } else {
                    in.setKeepAlive();
                }
                in.setLength(length);
                ((HTTPResponse)result).setContentStream(in);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", ex);
                }
                result = null;
                if (s == null) break block32;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    public Response getResponse(Request req, String destinationHost, Integer logId) {
        Response result;
        CachedSocket s;
        block29: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = HTTPRetriever.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                int to;
                int i = 0;
                while (i < 2) {
                    ServerCertApprovalCallback serverCertApprovalCB;
                    result = new HTTPResponse();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPSRetriever: AttemptRetrieve " + req);
                    }
                    if (req.getUseProxy()) {
                        serverCertApprovalCB = new ServerCertApprovalCallback(req.getHost());
                        s = CachedSSLSocketFactory.createSocket("localhost", jssProxyPort, "ssl", logId, serverCertApprovalCB);
                        Integer localport = new Integer(s.getLocalPort());
                        JSSProxyRunnable.connectHashMap.put(localport, req);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPSRetriever: Connecting to " + req.getProxyHost());
                        }
                    } else {
                        serverCertApprovalCB = null;
                        serverCertApprovalCB = ServerCertApprovalCallback.getInstance();
                        s = CachedSSLSocketFactory.createSocket(req.getHost(), Integer.parseInt(req.getPort()), "ssl", logId, serverCertApprovalCB);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPSRetriever: Connecting to: " + req.getHost());
                        }
                    }
                    if (s == null) {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("HTTPSRetriever: Null socket returned. Probably couldn't resolve host.");
                        }
                        return null;
                    }
                    this.ForceSSLHandshake(req, s);
                    try {
                        this.sendRequest(req, s);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    catch (Exception e) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("Exception while sending request/retrieving response", e);
                        }
                        return null;
                    }
                    if (!doBasicAuthentication || i != 0) break;
                    if (result.getStatusCode().compareTo("401") == 0) {
                        if (password == null || !BasicAuthentication.getPassword(req, destinationHost)) {
                            break;
                        }
                    } else {
                        if (password == null) break;
                        BasicAuthentication.storePassword(req, destinationHost);
                        break;
                    }
                    ++i;
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                String ka = result.getResponseHeader("keep-alive");
                if (ka != null && (to = Integer.parseInt(ka.substring(ka.indexOf("timeout=") + 8, ka.indexOf(44)))) > 0) {
                    s.setTimeout(to);
                }
                if (result.getResponseHeader("Connection: close") != null) {
                    in.setClosed();
                } else {
                    in.setKeepAlive();
                }
                in.setLength(length);
                ((HTTPResponse)result).setContentStream(in);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPSRetriever: ErrorRetrieve " + req, ex);
                }
                result = null;
                if (s == null) break block29;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    public void ForceSSLHandshake(Request req, CachedSocket s) throws IOException {
        String string = DEFAULT_SSL_PORT;
        synchronized (string) {
            StringTokenizer st;
            int tokenCount;
            String h = req.getHost();
            currentReqHost = h != null ? ((tokenCount = (st = new StringTokenizer(h, ".")).countTokens()) == 1 ? h + "." + rpSubdomain + rpDomain : (tokenCount == 2 ? h + rpDomain : h)) : null;
            try {
                s.getOutputStream().write(new byte[0]);
            }
            catch (IOException ex) {
                currentReqHost = null;
                throw ex;
            }
            currentReqHost = null;
        }
    }

    static {
        jssProxyPort = -1;
        doBasicAuthentication = false;
        String _host = SystemProperties.get("gateway.host", null);
        String rphost = "https://" + _host + "/";
        if (rphost != null) {
            int len = rphost.length();
            int index1 = rphost.indexOf(46);
            if (index1 != -1 && index1 + 1 < len) {
                int index2 = rphost.indexOf(46, index1 + 1);
                if (index2 == -1) {
                    rpSubdomain = rphost.substring(index1 + 1);
                } else {
                    rpSubdomain = rphost.substring(index1 + 1, index2);
                    rpDomain = rphost.substring(index2);
                }
            }
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0, 50);
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
        }
        catch (IOException e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("HTTPSRetriever: Unable to create server socket", e);
            }
            ss = null;
        }
        if (ss != null) {
            jssProxyPort = ss.getLocalPort();
            JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
            Thread t = new Thread(jssProxy);
            t.start();
        }
        doBasicAuthentication = GatewayProfile.getBoolean("DoBasicAuthentication", false) && ServiceIdentifier.isGateway();
    }
}

