/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.AuthContext;
import com.sun.portal.util.GWDebug;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class ApplicationLogin {
    private static Properties authPasswords = null;
    public static final String authPasswordFile = "/etc/opt/SUNWps/.auth_password.";

    private static void readPasswordList() {
        block7: {
            if (authPasswords != null) {
                return;
            }
            try {
                authPasswords = new Properties();
                authPasswords.load(new FileInputStream(authPasswordFile + System.getProperty("conf.suffix")));
            }
            catch (FileNotFoundException fnEx) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Unable to open password file : /etc/opt/SUNWps/.auth_password.", fnEx);
                }
            }
            catch (IOException ioEx) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Unable to read password file : /etc/opt/SUNWps/.auth_password.", ioEx);
                }
            }
            catch (Exception ex) {
                if (!GWDebug.debug.errorEnabled()) break block7;
                GWDebug.debug.error("Unable to read password file : /etc/opt/SUNWps/.auth_password.", ex);
            }
        }
    }

    public static String login(String appName) {
        ApplicationLogin.readPasswordList();
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(SystemProperties.get((String)"com.iplanet.am.defaultOrg"));
            AuthContext.IndexType index = AuthContext.IndexType.SERVICE;
            authContext.login(index, "srapGatewayAccessService".toLowerCase());
            Callback[] callback = null;
            while (authContext.hasMoreRequirements()) {
                callback = authContext.getRequirements();
                if (callback == null) continue;
                ApplicationLogin.processCallBack(callback);
                authContext.submitRequirements(callback);
            }
        }
        catch (LoginException ex) {
            ex.printStackTrace();
            return null;
        }
        try {
            if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                return authContext.getSSOToken().getTokenID().toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static void processCallBack(Callback[] callback) {
        int count = 0;
        while (count < callback.length) {
            if (callback[count] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback[count];
                nc.setName(authPasswords.getProperty("uid"));
            } else if (callback[count] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback[count];
                String password = authPasswords.getProperty("ldap_Password");
                char[] chars = new char[password.length()];
                password.getChars(0, chars.length, chars, 0);
                pc.setPassword(chars);
            }
            ++count;
        }
    }
}

