/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.yahoo;

import com.sun.portal.rproxy.configservlet.GatewayRequest;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.AttributeExtractor;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.configservlet.client.SrapClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class YahooProfile {
    private static final String ATTRIBUTE_PREFIX = "sunPortalYahoo";
    private static final String SERVICE_NAME = "SunPortalYahooService";
    private static final String GET_REQUEST = "GET_GLOBALS";
    private static Map result;
    private static boolean isYahooServiceInstalled;
    private static YahooProfile yahooProfile;

    private YahooProfile() {
        try {
            YahooProfile.init("this-should-be-sid");
        }
        catch (Exception e) {
            isYahooServiceInstalled = false;
        }
    }

    public static YahooProfile getInstance() {
        return yahooProfile;
    }

    public static void init(String sessionId) throws SendRequestException, GetResponseException {
        Request request = new Request(sessionId, SERVICE_NAME, GET_REQUEST);
        Response response = SrapClient.bootupExecute(request);
        result = (Map)response.getReturnedObject();
        if (!result.isEmpty()) {
            isYahooServiceInstalled = true;
        }
    }

    public static void init(String sessionId, String instanceName) throws SendRequestException, GetResponseException {
        GatewayRequest request = new GatewayRequest(sessionId, SERVICE_NAME, "retrieveInstance", instanceName);
        Response response = null;
        response = SrapClient.bootupExecute(request);
        result = (Map)response.getReturnedObject();
        if (!result.isEmpty()) {
            isYahooServiceInstalled = true;
        }
    }

    public static String getString(String name, String defaultValue) {
        if (!isYahooServiceInstalled) {
            return defaultValue;
        }
        return AttributeExtractor.getString(result, ATTRIBUTE_PREFIX + name, defaultValue);
    }

    public static int getInt(String name, int defaultValue) {
        if (!isYahooServiceInstalled) {
            return defaultValue;
        }
        return AttributeExtractor.getInt(result, ATTRIBUTE_PREFIX + name, defaultValue);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        if (!isYahooServiceInstalled) {
            return defaultValue;
        }
        return AttributeExtractor.getBoolean(result, ATTRIBUTE_PREFIX + name, defaultValue);
    }

    public static List getStringList(String name) {
        if (!isYahooServiceInstalled) {
            return new ArrayList();
        }
        return AttributeExtractor.getStringList(result, ATTRIBUTE_PREFIX + name);
    }

    public static boolean isYahooServiceInstalled() {
        return isYahooServiceInstalled;
    }

    static {
        isYahooServiceInstalled = false;
        yahooProfile = new YahooProfile();
    }
}

