/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util;

import com.sun.portal.rewriter.Data;
import com.sun.portal.rewriter.URISpec;
import com.sun.portal.rewriter.util.ListMap;
import com.sun.portal.rewriter.util.RegExp;
import com.sun.portal.rproxy.connectionhandler.DomainWebProxyConfig;
import com.sun.portal.rproxy.rewriter.util.SRAPRewriterProfile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SRAPConfigManager {
    public static String afindRuleSet2Apply(URISpec aURISpec) {
        Map ruleSetMap = SRAPRewriterProfile.getRuleSetMap();
        Iterator iterator = ruleSetMap.keySet().iterator();
        while (iterator.hasNext()) {
            String rule = iterator.next().toString();
            if (RegExp.indexOf((Data)new Data(rule), (String)aURISpec.getBaseURI().getInputString()) == -1) continue;
            return ruleSetMap.get(rule).toString();
        }
        return "default_gateway_ruleset";
    }

    public static String findRuleSet2Apply(URISpec aURISpec) {
        Map ruleSetMap = SRAPRewriterProfile.getRuleSetMap();
        String hostName = aURISpec.getBaseURI().getHost().toLowerCase();
        while (true) {
            Object ruleSetID;
            if ((ruleSetID = ruleSetMap.get(hostName)) != null) {
                return ruleSetID.toString();
            }
            int dotIndex = hostName.indexOf(46);
            if (dotIndex == -1) break;
            hostName = hostName.substring(dotIndex + 1);
        }
        Object starRuleSet = ruleSetMap.get("*");
        if (starRuleSet != null) {
            return starRuleSet.toString();
        }
        return "default_gateway_ruleset";
    }

    private static final String findDomainRuleSet(String aHostName) {
        Object domainRuleSet = SRAPRewriterProfile.getRuleSetMap().get(aHostName);
        if (domainRuleSet != null) {
            return domainRuleSet.toString();
        }
        int dotIndex = aHostName.indexOf(46);
        if (dotIndex != -1) {
            return SRAPConfigManager.findDomainRuleSet(aHostName.substring(dotIndex + 1));
        }
        return "default_gateway_ruleset";
    }

    public static String findMappedURI2MIME(String lURI) {
        ListMap lListMap = SRAPRewriterProfile.getURI2ParserMAP();
        List lKeys = lListMap.keyList();
        int i = 0;
        while (i < lKeys.size()) {
            String key = (String)lKeys.get(i);
            if (-1 != RegExp.indexOf((Data)new Data(key), (String)lURI)) {
                return lListMap.get((Object)key).toString();
            }
            ++i;
        }
        return null;
    }

    public static String getMappedMIME(String aMIME) {
        Object mappedMIME = SRAPRewriterProfile.getMIMEMap().get(aMIME);
        if (mappedMIME == null) {
            return null;
        }
        return mappedMIME.toString();
    }

    public static boolean isIntranet(String aLowerCaseHost) {
        return DomainWebProxyConfig.containHost(aLowerCaseHost);
    }

    public static boolean aisIntranet(String aLowerCaseHost) {
        List domainList = SRAPRewriterProfile.getIntranetInfo();
        if (SRAPRewriterProfile.isTranslateAll() || aLowerCaseHost.indexOf(46) == -1) {
            return true;
        }
        int size = domainList.size();
        int i = 0;
        while (i < size) {
            String domainObject = domainList.get(i).toString();
            if (aLowerCaseHost.endsWith(domainObject)) {
                int lengthdiff = aLowerCaseHost.length() - domainObject.length();
                if (lengthdiff == 0) {
                    return true;
                }
                if (lengthdiff > 0 && aLowerCaseHost.charAt(lengthdiff - 1) == '.') {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

