/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.GatewayRequest;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.AttributeExtractor;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.configservlet.client.SrapClient;
import com.sun.portal.util.GWDebug;
import java.util.List;
import java.util.Map;

public class GatewayProfile {
    private static final String ATTRIBUTE_PREFIX = "sunPortalGateway";
    private static final String SERVICE_NAME = "srapGatewayService";
    private static final String GET_REQUEST = "GET_GLOBALS";
    private static Map result;

    private GatewayProfile() {
    }

    public static void init(String sessionId) throws SendRequestException, GetResponseException {
        Request request = new Request(sessionId, SERVICE_NAME, GET_REQUEST);
        Response response = SrapClient.execute(request);
        result = (Map)response.getReturnedObject();
    }

    public static void init(String sessionId, String instanceName) throws SendRequestException, GetResponseException {
        GatewayRequest request = new GatewayRequest(sessionId, SERVICE_NAME, "retrieveInstance", instanceName);
        Response response = null;
        response = SrapClient.bootupExecute(request);
        result = (Map)response.getReturnedObject();
        if (result.isEmpty()) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Gateway Aborting : Unable to retrieve the gateway profile : " + instanceName);
            }
            System.exit(-1);
        }
    }

    public static String getString(String name, String defaultValue) {
        return AttributeExtractor.getString(result, ATTRIBUTE_PREFIX + name, defaultValue);
    }

    public static int getInt(String name, int defaultValue) {
        return AttributeExtractor.getInt(result, ATTRIBUTE_PREFIX + name, defaultValue);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        return AttributeExtractor.getBoolean(result, ATTRIBUTE_PREFIX + name, defaultValue);
    }

    public static List getStringList(String name) {
        return AttributeExtractor.getStringList(result, ATTRIBUTE_PREFIX + name);
    }
}

