/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.jsp.JspFactoryImpl;
import com.sun.portal.providers.jsp.JspServletEnvironment;
import com.sun.portal.providers.jsp.JspServletWrapper;
import com.sun.portal.providers.jsp.JspSession;
import com.sun.portal.providers.jsp.Request;
import com.sun.portal.providers.jsp.Response;
import com.sun.portal.providers.jsp.jasper3.jasper.JspFactory;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPProvider
extends ProfileProviderAdapter {
    private static HashMap cachedJsps = new HashMap();
    private static JspFactory theJspFactory = new JspFactoryImpl();
    JspSession jspsession = new JspSession();
    JspServletEnvironment jspEnv = null;
    JspServletWrapper contentWrapper = null;
    JspServletWrapper editWrapper = null;
    JspServletWrapper processWrapper = null;
    private boolean isPresentable;

    public void init(String n, HttpServletRequest httpreq) throws ProviderException {
        super.init(n, httpreq);
        String clientType = null;
        String clientPath = null;
        clientType = this.getProviderContext().getClientType();
        if (clientType != null) {
            clientPath = this.getProviderContext().getClientProperty("filePath");
        }
        DesktopContext dc = DesktopContextThreadLocalizer.get();
        String jspScratchDir = dc.getJSPScratchDir();
        String jspCompilerWARClassPath = (String)this.getProviderContext().getServletConfig().getServletContext().getAttribute("com.iplanet.server.http.servlet.classpath");
        if (jspCompilerWARClassPath == null) {
            jspCompilerWARClassPath = dc.getJSPCompilerWARClassPath();
        }
        if (jspCompilerWARClassPath == null) {
            throw new ProviderException("JSPProvider.init(): couldn't get WAR class path");
        }
        String jspCompilerClassPath = jspCompilerWARClassPath + File.pathSeparatorChar + System.getProperties().getProperty("java.class.path");
        String desktopType = dc.getDesktopType();
        String userLocale = dc.getLocaleString();
        this.jspEnv = new JspServletEnvironment(this.getName(), jspScratchDir, desktopType, userLocale, clientPath, jspCompilerClassPath);
        String jsp = this.getStringProperty("contentPage");
        if (jsp.length() != 0) {
            String fullJspPath;
            int index = jsp.indexOf(63);
            String uri = jsp;
            if (index != -1) {
                uri = jsp.substring(0, index);
            }
            this.isPresentable = (fullJspPath = this.jspEnv.getRealPath(uri)) != null ? true : super.isPresentable();
        } else {
            this.isPresentable = super.isPresentable();
        }
    }

    public boolean isPresentable() {
        return this.isPresentable;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String jsp = this.getStringProperty("contentPage");
        boolean showExceptions = this.getBooleanProperty("showExceptions");
        if (jsp.length() == 0 || jsp == null) {
            return super.getContent(req, res);
        }
        try {
            Response jres;
            if (this.contentWrapper == null || this.contentWrapper.expired() || !this.contentWrapper.getURI().equals(jsp)) {
                this.contentWrapper = this.getJspWrapper(jsp);
            }
            if ((jres = this.processJspFile(this.contentWrapper, req, res)).getStatus() == 200) {
                return jres.getBody();
            }
            throw new ProviderException(this.getName() + ": contentPage JSP=" + jsp + ", status code=" + jres.getStatus());
        }
        catch (ProviderException pe) {
            return this.handleException(pe);
        }
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String jsp = this.getStringProperty("editPage");
        if (jsp.length() == 0 || jsp == null) {
            return super.getEdit(req, res);
        }
        try {
            Response jres;
            if (this.editWrapper == null || this.editWrapper.expired() || !this.editWrapper.getURI().equals(jsp)) {
                this.editWrapper = this.getJspWrapper(jsp);
            }
            if ((jres = this.processJspFile(this.editWrapper, req, res)).getStatus() == 200) {
                return jres.getBody();
            }
            throw new ProviderException(this.getName() + ": editPage JSP=" + jsp + ", status code=" + jres.getStatus());
        }
        catch (ProviderException pe) {
            return this.handleException(pe);
        }
    }

    private StringBuffer handleException(ProviderException pe) throws ProviderException {
        if (this.getBooleanProperty("showExceptions")) {
            ProviderException e = pe;
            StringWriter swriter = new StringWriter(256);
            PrintWriter buf = new PrintWriter((Writer)swriter, true);
            buf.println("<div align=left><b>");
            buf.println(e.getMessage());
            buf.println("</b><p><pre>");
            ((Throwable)e).printStackTrace(buf);
            buf.println("</pre></div>");
            buf.flush();
            return swriter.getBuffer();
        }
        throw pe;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Response jres;
        String jsp = this.getStringProperty("processPage");
        if (jsp.length() == 0 || jsp == null) {
            return super.processEdit(req, res);
        }
        if (this.processWrapper == null || this.processWrapper.expired() || !this.processWrapper.getURI().equals(jsp)) {
            this.processWrapper = this.getJspWrapper(jsp);
        }
        if ((jres = this.processJspFile(this.processWrapper, req, res)).getStatus() == 302) {
            try {
                return jres.getLocation();
            }
            catch (MalformedURLException mue) {
                throw new ProviderException(this.getName() + ": invalid URL from processPage JSP", mue);
            }
        }
        if (jres.getStatus() == 200) {
            return null;
        }
        throw new ProviderException(this.getName() + ": processPage JSP=" + jsp + ", status code: " + jres.getStatus());
    }

    private JspServletWrapper getJspWrapper(String jsp) throws ProviderException {
        int index = jsp.indexOf(63);
        String uri = jsp;
        if (index != -1) {
            uri = jsp.substring(0, index);
        }
        try {
            String fullJspPath = this.jspEnv.getRealPath(uri);
            String mostSpecificJspPath = this.getProviderContext().getTemplateMostSpecificPath(this.getName(), uri).toString();
            if (fullJspPath == null) {
                throw new ProviderException("JSP file not found: " + uri);
            }
            JspServletWrapper wrapper = (JspServletWrapper)cachedJsps.get(mostSpecificJspPath);
            if (wrapper == null) {
                int scanInterval = 0;
                if (DesktopAppContextThreadLocalizer.exists()) {
                    DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
                    scanInterval = dac.getTemplateScanInterval();
                }
                HashMap hashMap = cachedJsps;
                synchronized (hashMap) {
                    wrapper = (JspServletWrapper)cachedJsps.get(mostSpecificJspPath);
                    if (wrapper == null) {
                        wrapper = new JspServletWrapper(jsp, uri, fullJspPath, mostSpecificJspPath, this.jspEnv, scanInterval, new ProviderClassLoader(this.getClass().getClassLoader()));
                        cachedJsps.put(mostSpecificJspPath, wrapper);
                    }
                }
            } else {
                wrapper.setFullJspFile(fullJspPath);
            }
            return wrapper;
        }
        catch (Throwable t) {
            throw new ProviderException("JSPProvider.getJspWrapper(): jsp=" + jsp + ", ", t);
        }
    }

    private Response processJspFile(JspServletWrapper jsp, HttpServletRequest hsreq, HttpServletResponse hsres) throws ProviderException {
        Hashtable<String, String[]> parameters = new Hashtable<String, String[]>();
        Enumeration pe = hsreq.getParameterNames();
        while (pe.hasMoreElements()) {
            String pname = (String)pe.nextElement();
            parameters.put(pname, hsreq.getParameterValues(pname));
        }
        return this.processJspFile(jsp, hsreq, hsres, parameters, hsreq.getCookies());
    }

    private Response processJspFile(JspServletWrapper wrapper, HttpServletRequest origReq, HttpServletResponse origRes, Hashtable params, Cookie[] ca) throws ProviderException {
        String jsp = wrapper.getURI();
        Request req = new Request(origReq, this.jspsession, params, ca, jsp);
        Response res = new Response(req, origRes, this.getProviderContext());
        req.setAttribute("com.sun.portal.providers.jsp.JSPProvider", this);
        JspFactory deffact = JspFactory.getPsFactory();
        if (deffact != theJspFactory) {
            JspFactory.setPsFactory((JspFactory)theJspFactory);
        }
        try {
            wrapper.service(req, res);
        }
        catch (RuntimeException e) {
            throw new ProviderException("JSPProvider.getName(): ", e);
        }
        catch (ServletException e) {
            Throwable t = e.getRootCause();
            if (t == null) {
                t = e;
            }
            if (t instanceof ProviderException) {
                ProviderException pe = (ProviderException)t;
                throw pe;
            }
            throw new ProviderException("JSPProvider.processJSPFile(): jsp=" + jsp + ", ", t);
        }
        catch (Throwable t) {
            throw new ProviderException("JSPProvider.processJSPFile(): jsp=" + jsp + ", ", t);
        }
        return res;
    }

    protected StringBuffer includeJspPage(String jsp, Hashtable parameters, HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        if (jsp.length() == 0 || jsp == null) {
            return new StringBuffer();
        }
        try {
            Response jres = this.processJspFile(this.getJspWrapper(jsp), req, res, parameters, req.getCookies());
            if (jres.getStatus() == 200) {
                return jres.getBody();
            }
            throw new ProviderException(this.getName() + ": include JSP=" + jsp + ", status code=" + jres.getStatus());
        }
        catch (ProviderException pe) {
            return this.handleException(pe);
        }
    }
}

