/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.template;

import com.sun.portal.desktop.util.IURLEncoder;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.template.TemplateContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateEditProvider
extends TemplateContainerProvider {
    public boolean isEditable() {
        return true;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        Provider p = null;
        String targetprovider = req.getParameter("targetprovider");
        String editArgs = req.getParameter("editArgs");
        if (targetprovider == null) {
            throw new ProviderException("TemplateEditProvider.processEdit(): Unable to obtain the target provider");
        }
        p = cpc.getProvider(req, this.getName(), targetprovider);
        if (p != null && !p.isEditable()) {
            throw new ProviderException("TemplateEditProvider.processEdit():attempt to process non-editable channel=" + targetprovider);
        }
        URL next = null;
        try {
            next = p.processEdit(req, res);
        }
        catch (InvalidEditFormDataException e) {
            String error = IURLEncoder.encode(e.getMessage());
            StringBuffer args = new StringBuffer(64);
            int errIndex = editArgs.indexOf("&error=");
            if (errIndex > -1) {
                args.append(pc.getDesktopURL(req)).append(editArgs.substring(0, errIndex)).append("&error=").append(error);
            } else {
                args.append(pc.getDesktopURL(req)).append(editArgs).append("&error=").append(error);
            }
            try {
                next = new URL(args.toString());
            }
            catch (MalformedURLException m) {
                throw new ProviderException("TemplateEditProvider.processEdit()", m);
            }
        }
        return next;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        Provider cp = null;
        String provider = req.getParameter("provider");
        String targetprovider = req.getParameter("targetprovider");
        String containerName = req.getParameter("containerName");
        if (targetprovider == null) {
            throw new ProviderException("TemplateEditProvider:processEdit(): Unable to obtain the target provider");
        }
        cp = cpc.getProvider(req, this.getName(), targetprovider);
        if (cp != null && !cp.isEditable()) {
            throw new ProviderException("TemplateEditProvider:processEdit(): attempt to process non-editable channel=" + targetprovider);
        }
        StringBuffer editForm = null;
        editForm = cp.getEdit(req, res);
        if (editForm == null) {
            throw new ProviderException("TemplateEditProvider:processEdit():edit form was null for target provider=" + targetprovider);
        }
        if (cp.getEditType() == 4) {
            return editForm;
        }
        Hashtable tags = this.getStandardTags(req);
        tags.put("help_link", this.getHelpLink("editPage", req));
        tags.put("title", cp.getTitle());
        StringBuffer args = new StringBuffer(64);
        args.append("?").append(req.getQueryString());
        tags.put("provider", provider);
        tags.put("targetprovider", targetprovider);
        tags.put("editArgs", args.toString());
        tags.put("contentOptions", editForm.toString());
        if (containerName != null) {
            tags.put("frontContainerName", containerName);
        }
        StringBuffer ob = this.getTemplate("editTemplate.template", tags);
        return ob;
    }
}

