/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.template;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProviderAdapter;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.context.Theme;
import com.sun.portal.providers.util.ProviderProperties;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class TemplateContainerProvider
extends ContainerProviderAdapter
implements ProviderProperties {
    HttpServletRequest _req = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this._req = req;
    }

    public Hashtable getStandardTags(HttpServletRequest req) throws ProviderException {
        Hashtable<String, CharSequence> tags = new Hashtable<String, CharSequence>();
        ProviderContext pc = this.getProviderContext();
        String property = null;
        property = "fontFace1";
        tags.put("fontFace1", this.getStringProperty("fontFace1"));
        property = "productName";
        tags.put("productName", this.getStringProperty("productName"));
        tags.put("parentContainerName", pc.getDefaultChannelName());
        tags.put("menubar", this.getTemplate("menubar.template"));
        tags.put("contentLayout", this.getTemplate("contentLayout.template"));
        tags.put("toolbarRollover", this.getTemplate("toolbarRollovers.js"));
        tags.put("noCache", this.getTemplate("noCache.template"));
        tags.put("desktop_url", pc.getDesktopURL(req));
        tags.put("bulletColor", this.getTemplate("bulletColor.js"));
        tags.put("banner", this.getTemplate("banner.template"));
        String err = pc.decodeURLParameter(req.getParameter("error"));
        if (err != null) {
            tags.put("errMessage", err);
            tags.put("inlineError", this.getTemplate("inlineError.template"));
        } else {
            tags.put("errMessage", "");
            tags.put("inlineError", "");
        }
        try {
            tags.put("bgColor", Theme.getAttribute(this.getName(), pc, "bgColor"));
            tags.put("titleBarColor", Theme.getAttribute(this.getName(), pc, "titleBarColor"));
            tags.put("borderColor", Theme.getAttribute(this.getName(), pc, "borderColor"));
            tags.put("fontColor", Theme.getAttribute(this.getName(), pc, "fontColor"));
            tags.put("borderWidth", Theme.getAttribute(this.getName(), pc, "borderWidth"));
            tags.put("fontFace", Theme.getAttribute(this.getName(), pc, "fontFace"));
            if (Theme.getSelectedName(this.getName(), pc).equals("CustomTheme")) {
                tags.put("theme_channel", this.getStringProperty("customThemeChannel"));
            } else {
                tags.put("theme_channel", this.getStringProperty("presetThemeChannel"));
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("TemplateContainerProvider.getStardardTags(): failed to obtain theme related attribute ", pce);
        }
        return tags;
    }

    protected String getHelpLink(String key, HttpServletRequest req) throws ProviderException {
        try {
            URL helpLink = this.getHelp(req, key);
            if (helpLink != null) {
                return helpLink.toString();
            }
            return "";
        }
        catch (Throwable t) {
            throw new ProviderException("DesktopProvider.getHelpLink(): could not get help URL for " + key, t);
        }
    }
}

