/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.bookmark;

import com.sun.portal.desktop.util.Encoder;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.desktop.util.Target;
import com.sun.portal.providers.AsciiFormInputExpectedException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.util.ProviderProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BookmarkProvider
extends ProfileProviderAdapter
implements ProviderProperties {
    private ResourceBundle bundle = null;
    private String editContainer = null;
    private String container = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    private List setTargets(List targets) throws ProviderException {
        this.setListProperty("targets", targets);
        return targets;
    }

    private List getTargets() throws ProviderException {
        return this.getListProperty("targets", true);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer content = new StringBuffer();
        StringBuffer ob = new StringBuffer();
        List targets = this.getTargets();
        int x = 0;
        while (x < targets.size()) {
            String targ = (String)targets.get(x);
            Target target = new Target(targ);
            content.append("<TR><TD>\n");
            content.append("<FONT FACE=\"[tag:fontFace1]\" SIZE=\"-1\">\n");
            StringBuffer windowName = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(target.getName(), " (),=+#[]@<>$%./!");
            while (tokens.hasMoreTokens()) {
                windowName.append(tokens.nextToken());
                if (!tokens.hasMoreElements()) continue;
                windowName.append("_");
            }
            content.append("<A HREF=\"").append(target.getValue()).append("\" target=\"").append((Object)windowName).append("\" onClick=\"javascript:" + Encoder.encodeFormName(this.getName()) + "_findWindow('").append(target.getValue()).append("'); return false;\">").append(target.getName()).append("</A>\n").append("</font></TD></TR>\n");
            ++x;
        }
        content.append("<BR>");
        String windowPref = this.getStringProperty("windowPref");
        tagTable.put("windowOption", windowPref);
        tagTable.put("bookmarks", content.toString());
        tagTable.put("channelName", Encoder.encodeFormName(this.getName()));
        tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
        ob = this.getTemplate("display.template", tagTable);
        return ob;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        StringBuffer resourceList = new StringBuffer("");
        StringBuffer windowOptions = new StringBuffer("");
        this.editContainer = req.getParameter("provider");
        this.container = req.getParameter("containerName");
        List targets = this.getTargets();
        int i = 0;
        while (i < targets.size()) {
            String targ = (String)targets.get(i);
            Target target = new Target(targ);
            resourceList.append("<TR><TD><CENTER><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"remove").append(i).append("\"></CENTER></TD>");
            resourceList.append("<TD><FONT FACE=\"[tag:fontFace1]\" SIZE=-1><INPUT TYPE=\"TEXT\" VALUE=\"").append(Encoder.encodeHtml(target.getName())).append("\" SIZE=\"40\" NAME=\"name").append(i).append("\"></FONT></TD>");
            resourceList.append("<TD><FONT FACE=\"[tag:fontFace1]\" SIZE=-1><INPUT TYPE=\"TEXT\" RPROXY-NOPARSE VALUE=\"").append(Encoder.encodeHtml(target.getValue())).append("\" SIZE=\"40\" NAME=\"url").append(i).append("\"></FONT></TD></TR>");
            ++i;
        }
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        String all_new_checked = new String("");
        String one_new_checked = new String("");
        String same_checked = new String("");
        String wp = this.getStringProperty("windowPref");
        if (wp.equals("all_new")) {
            all_new_checked = "CHECKED";
        }
        if (wp.equals("one_new")) {
            one_new_checked = "CHECKED";
        }
        if (wp.equals("same")) {
            same_checked = "CHECKED";
        }
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        windowOptions.append("<INPUT TYPE=\"RADIO\" NAME=\"windowPref\" VALUE=\"all_new\" ").append(all_new_checked).append(">").append(this.bundle.getString("ownWindow")).append("<BR><INPUT TYPE=\"RADIO\" NAME=\"windowPref\" VALUE=\"one_new\" ").append(one_new_checked).append(">").append(this.bundle.getString("singleWindow")).append("<BR><INPUT TYPE=\"RADIO\" NAME=\"windowPref\" VALUE=\"same\" ").append(same_checked).append(">").append(this.bundle.getString("mainWindow")).append("<BR>");
        String resourceCountString = Integer.toString(targets.size());
        String err = req.getParameter("error");
        if (err != null) {
            tagTable.put("errMessage", err);
            tagTable.put("inlineError", this.getTemplate("inlineError.template"));
        } else {
            tagTable.put("errMessage", "");
            tagTable.put("inlineError", "");
        }
        String resourceName = req.getParameter("resourceName");
        if (resourceName != null) {
            tagTable.put("resourceName", resourceName);
        } else {
            tagTable.put("resourceName", "");
        }
        String resourceURL = req.getParameter("resourceURL");
        if (resourceURL != null) {
            tagTable.put("resourceURL", resourceURL);
        } else {
            tagTable.put("resourceURL", "");
        }
        tagTable.put("resourceCount", resourceCountString);
        tagTable.put("resourceList", resourceList.toString());
        tagTable.put("windowOptions", windowOptions.toString());
        tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        this.getProviderContext().contentChanged(this.getName());
        String error = null;
        Vector<String> targets = new Vector<String>();
        StringBuffer nextURLString = new StringBuffer();
        if (this.editContainer != null && this.container != null) {
            nextURLString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(URLEncoder.encode(this.editContainer)).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(this.container));
        } else {
            nextURLString = null;
        }
        String rc = req.getParameter("resourceCount");
        int resourceCount = Integer.parseInt(rc);
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        URL next = null;
        int i = 0;
        while (i < resourceCount) {
            Integer removeFlag;
            String checkBoxValue = req.getParameter("remove" + i);
            Integer n = removeFlag = checkBoxValue == null ? Integers.get(0) : Integer.valueOf(checkBoxValue);
            if (removeFlag != 1) {
                String nameString = "name" + i;
                String urlString = "url" + i;
                String name = req.getParameter(nameString);
                String url = req.getParameter(urlString);
                boolean errorFlag = false;
                if ((name == null || name.trim().equals("")) && (url == null || url.trim().equals(""))) {
                    if (nextURLString != null) {
                        nextURLString.append("&error=").append(URLEncoder.encode(this.bundle.getString("removeError")));
                        errorFlag = true;
                    }
                } else if (name == null || name.trim().equals("")) {
                    if (nextURLString != null) {
                        nextURLString.append("&error=").append(URLEncoder.encode(this.bundle.getString("emptyName") + " : " + url));
                        errorFlag = true;
                    }
                } else if ((url == null || url.trim().equals("")) && nextURLString != null) {
                    nextURLString.append("&error=").append(URLEncoder.encode(this.bundle.getString("emptyURL") + " : " + name));
                    errorFlag = true;
                }
                if (errorFlag) {
                    try {
                        if (nextURLString != null) {
                            next = new URL(nextURLString.toString());
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new ProviderException("BookmarkProvider.processEdit()", e);
                    }
                    return next;
                }
                if (!I18n.isAscii(url)) {
                    String err = this.bundle.getString("nonAsciiURL");
                    throw new AsciiFormInputExpectedException(err);
                }
                Target target = new Target(name, url);
                if (target.getValue().indexOf("://") == -1 && !target.getValue().startsWith("/")) {
                    target.setValue("http://" + target.getValue());
                }
                targets.add(target.toString());
            }
            ++i;
        }
        String newName = req.getParameter("resourceName");
        String newURL = req.getParameter("resourceURL");
        String addMore = req.getParameter("add_more");
        if (newName != null && newURL != null && !newName.trim().equals("") && !newURL.trim().equals("")) {
            if (!I18n.isAscii(newURL)) {
                String err = this.bundle.getString("nonAsciiURL");
                throw new AsciiFormInputExpectedException(err);
            }
            Target target = new Target(newName, newURL);
            if (target.getValue().indexOf("://") == -1 && !target.getValue().startsWith("/")) {
                target.setValue("http://" + target.getValue());
            }
            targets.add(target.toString());
        } else if ((newName == null || newName.trim().equals("")) && (newURL == null || newURL.trim().equals(""))) {
            if (addMore != null && !addMore.trim().equals("")) {
                error = this.bundle.getString("emptyNameURL");
            }
        } else {
            error = newName == null || newName.trim().equals("") ? this.bundle.getString("emptyName") : this.bundle.getString("emptyURL");
        }
        if (error != null && nextURLString != null && newName != null && newURL != null) {
            nextURLString.append("&resourceName=").append(URLEncoder.encode(newName)).append("&resourceURL=").append(URLEncoder.encode(newURL)).append("&error=").append(URLEncoder.encode(error));
        }
        if (error == null && (addMore == null || addMore.trim().equals(""))) {
            next = null;
        } else {
            try {
                if (nextURLString != null) {
                    next = new URL(nextURLString.toString());
                }
            }
            catch (MalformedURLException e) {
                throw new ProviderException("BookmarkProvider.processEdit()", e);
            }
        }
        this.setTargets(targets);
        String windowPref = req.getParameter("windowPref");
        if (windowPref != null && !windowPref.equals(this.getStringProperty("windowPref"))) {
            this.setStringProperty("windowPref", windowPref);
        }
        return next;
    }
}

