/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import com.sun.portal.desktop.util.IURLDecoder;
import com.sun.portal.desktop.util.IURLEncoder;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class I18n {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String ASCII_CHARSET = "ISO-8859-1";

    public static String print(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c >= 32 && c < 127) {
                buf.append(s.charAt(i));
            } else {
                buf.append("\\u");
                String n = "";
                int j = 0;
                while (j < 4) {
                    n = "" + Character.forDigit(c & 0xF, 16) + n;
                    c >>= 4;
                    ++j;
                }
                buf.append(n);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String decodeCharset(String s, String charset) {
        if (s == null) {
            return null;
        }
        try {
            byte[] buf = s.getBytes(ASCII_CHARSET);
            return new String(buf, 0, buf.length, charset);
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public static String encodeCharset(String s, String charset) {
        if (s == null) {
            return null;
        }
        try {
            byte[] buf = s.getBytes(charset);
            return new String(buf, 0, buf.length, ASCII_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public static boolean isAscii(String s) {
        if (s == null) {
            return true;
        }
        try {
            if (!s.equals(new String(s.getBytes(ASCII_CHARSET), ASCII_CHARSET))) {
                return false;
            }
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        return true;
    }

    private static String format(MessageFormat mf, Object o) {
        String msg = mf.format(new Object[]{o}, new StringBuffer(), (FieldPosition)null).toString();
        return msg;
    }

    public static String format(String pattern, Long j, Locale l) {
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(l);
        mf.applyPattern(pattern);
        String msg = I18n.format(mf, j);
        return msg;
    }

    public static String format(String pattern, Integer i, Locale l) {
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(l);
        mf.applyPattern(pattern);
        String msg = I18n.format(mf, i);
        return msg;
    }

    public static String format(String pattern, Date d, TimeZone tz, Locale l) {
        DateFormat df2;
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(l);
        mf.applyPattern(pattern);
        ((DateFormat)mf.getFormats()[0]).setTimeZone(tz);
        DateFormat df1 = (DateFormat)mf.getFormats()[0];
        if (df1 != null) {
            df1.setTimeZone(tz);
        }
        if ((df2 = (DateFormat)mf.getFormats()[1]) != null) {
            df2.setTimeZone(tz);
        }
        return I18n.format(mf, d);
    }

    public static String IURLEncode(String enc) {
        try {
            return IURLEncoder.encode(IURLEncoder.encode(new String(enc.getBytes(DEFAULT_CHARSET), ASCII_CHARSET)));
        }
        catch (Exception e) {
            return enc;
        }
    }

    public static String IURLDecode(String enc) {
        try {
            String dc = new String(IURLDecoder.decode(enc));
            return new String(dc.getBytes(ASCII_CHARSET), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            return enc;
        }
    }
}

