/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import com.sun.portal.desktop.util.Integers;
import java.net.URLDecoder;

public class Encoder {
    public static final char[] cookieEscapeChars = new char[]{';', ',', ' ', '[', ']', '{', '}', '=', '\"', '/', '\\', '?', '@', ':', '\n', '\r'};

    public static boolean isCookieEscChar(char ch) {
        boolean result = false;
        int i = 0;
        while (i < cookieEscapeChars.length) {
            if (ch == cookieEscapeChars[i]) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String cookieEncode(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (Encoder.isCookieEscChar(ch)) {
                char j = ch;
                buf.append("%").append(Integers.getHex(j));
            } else {
                buf.append(String.valueOf(ch));
            }
            ++i;
        }
        return buf.toString();
    }

    public static String cookieDecode(String value) {
        return URLDecoder.decode(value);
    }

    public static String encodeXml(String text) {
        StringBuffer escaped = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    escaped.append("&lt;");
                    break;
                }
                case '>': {
                    escaped.append("&gt;");
                    break;
                }
                case '&': {
                    escaped.append("&amp;");
                    break;
                }
                case '\'': {
                    escaped.append("&apos;");
                    break;
                }
                case '\"': {
                    escaped.append("&quot;");
                    break;
                }
                default: {
                    escaped.append(c);
                    break;
                }
            }
            ++i;
        }
        return escaped.toString();
    }

    public static String encodeHtml(String text) {
        StringBuffer escaped = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    escaped.append("&lt;");
                    break;
                }
                case '>': {
                    escaped.append("&gt;");
                    break;
                }
                case '&': {
                    escaped.append("&amp;");
                    break;
                }
                case '\"': {
                    escaped.append("&quot;");
                    break;
                }
                default: {
                    escaped.append(c);
                    break;
                }
            }
            ++i;
        }
        return escaped.toString();
    }

    public static String encodeFormName(String text) {
        StringBuffer escaped = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    escaped.append("_");
                    break;
                }
                default: {
                    escaped.append(c);
                    break;
                }
            }
            ++i;
        }
        return escaped.toString();
    }
}

