/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.template;

import com.sun.portal.desktop.template.ParsedTagArray;

public class TagSwapperHelper {
    private static final String TAG = "tag:";
    private static final int TAG_LENGTH = "tag:".length();
    private static final String URL = "url:";
    private static final int URL_LENGTH = "url:".length();
    private static final String SURL = "surl:";
    private static final int SURL_LENGTH = "surl:".length();

    private static boolean tagEquals(StringBuffer b, String tag, int start, int length) {
        int i = 0;
        while (i < length) {
            if (tag.charAt(i) != b.charAt(start + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void parseTemplate(StringBuffer in, ParsedTagArray result) {
        if (in != null) {
            int len = in.length();
            if (len == 0) {
                return;
            }
            int tokenType = 0;
            StringBuffer token = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                char ch = in.charAt(i);
                switch (ch) {
                    case '[': {
                        if (i + TAG_LENGTH < len && TagSwapperHelper.tagEquals(in, TAG, i + 1, TAG_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            }
                            tokenType = 1;
                            token = new StringBuffer(len);
                            i += TAG_LENGTH;
                            break;
                        }
                        if (i + URL_LENGTH < len && TagSwapperHelper.tagEquals(in, URL, i + 1, URL_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            }
                            tokenType = 2;
                            token = new StringBuffer(len);
                            i += URL_LENGTH;
                            break;
                        }
                        if (i + SURL_LENGTH < len && TagSwapperHelper.tagEquals(in, SURL, i + 1, SURL_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            }
                            tokenType = 3;
                            token = new StringBuffer(len);
                            i += SURL_LENGTH;
                            break;
                        }
                        token.append(ch);
                        break;
                    }
                    case ']': {
                        if (tokenType == 1) {
                            if (token.length() > 0 && tokenType == 1) {
                                result.appendParsedElement(1, token.toString());
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            break;
                        }
                        if (tokenType == 2) {
                            if (token.length() > 0 && tokenType == 2) {
                                result.appendParsedElement(2, token.toString());
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            break;
                        }
                        if (tokenType == 3) {
                            if (token.length() > 0 && tokenType == 3) {
                                result.appendParsedElement(3, token.toString());
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            break;
                        }
                        token.append(ch);
                        break;
                    }
                    default: {
                        token.append(ch);
                    }
                }
                ++i;
            }
            if (token.length() > 0) {
                result.appendParsedElement(0, token.toString());
            }
        }
    }
}

