/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.perf;

import com.sun.portal.desktop.perf.DesktopPerfStatsMBean;
import com.sun.portal.desktop.perf.TimerFilter;
import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DesktopPerfStats
implements DesktopPerfStatsMBean,
NotificationListener {
    private long curPTime = 0L;
    private long cumPTime = 0L;
    private long lowPTime = 0L;
    private long hiwPTime = 0L;
    private Date timeStamp = null;
    private int nbRefs = 0;
    private int nbLogs = 0;
    private int refresh = 0;
    private boolean active = false;
    private MBeanServer myServer = null;
    private ObjectName myObjectName = null;
    private ObjectName myTimer = null;
    static /* synthetic */ Class class$com$sun$portal$desktop$perf$DesktopPerfStats;

    public DesktopPerfStats(ObjectName oName, MBeanServer server, boolean flag) throws MalformedObjectNameException, InstanceNotFoundException {
        this.active = flag;
        this.myObjectName = oName;
        this.myServer = server;
        this.nbRefs = 1;
        this.timeStamp = new Date();
        this.myTimer = new ObjectName("Services:type=timer,name=javax.management.timer.Timer");
    }

    public void setActive(boolean status) {
        this.active = status;
    }

    public boolean getActive() {
        return this.active;
    }

    public long getCurPTime() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            long l = this.curPTime;
            return l;
        }
    }

    public void setCurPTime(long ptime) {
        if (!this.active) {
            return;
        }
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            ++this.nbLogs;
            this.curPTime = ptime;
            this.cumPTime += ptime;
            if (ptime > this.hiwPTime) {
                this.hiwPTime = ptime;
            }
            if (this.lowPTime == 0L) {
                this.lowPTime = ptime;
            } else if (ptime < this.lowPTime) {
                this.lowPTime = ptime;
            }
        }
    }

    public int getRefresh() {
        return this.refresh;
    }

    public void setRefresh(int period) throws IllegalArgumentException, MalformedObjectNameException, MBeanException, ReflectionException, InstanceNotFoundException {
        this.refresh = period;
        if (this.refresh != 0) {
            Date curDate = new Date(System.currentTimeMillis() + 60000L * (long)this.refresh);
            Object[] params = new Object[]{"refresh.notification", "wakeup", null, curDate};
            String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date"};
            Integer nId = (Integer)this.myServer.invoke(this.myTimer, "addNotification", params, signatures);
            TimerFilter filter = new TimerFilter(nId);
            this.myServer.addNotificationListener(this.myTimer, this.myObjectName, (NotificationFilter)filter, null);
        }
    }

    public long getAvgPTime() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            if (this.cumPTime != 0L) {
                long l = this.cumPTime / (long)this.nbLogs;
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    public long getCumPTime() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            long l = this.cumPTime;
            return l;
        }
    }

    public long getHiwPTime() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            long l = this.hiwPTime;
            return l;
        }
    }

    public long getLowPTime() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            long l = this.lowPTime;
            return l;
        }
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public int getNbRefs() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            int n = this.nbRefs;
            return n;
        }
    }

    public long getNbLogs() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            long l = this.nbLogs;
            return l;
        }
    }

    public void incNbRefs() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            ++this.nbRefs;
        }
    }

    public void reset() {
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            this.timeStamp = new Date();
            this.curPTime = 0L;
            this.cumPTime = 0L;
            this.lowPTime = 0L;
            this.hiwPTime = 0L;
            this.nbLogs = 0;
        }
    }

    public void logReport() throws MalformedObjectNameException, InstanceNotFoundException, ReflectionException, MBeanException {
        String report;
        Class clazz = class$com$sun$portal$desktop$perf$DesktopPerfStats == null ? (class$com$sun$portal$desktop$perf$DesktopPerfStats = DesktopPerfStats.class$("com.sun.portal.desktop.perf.DesktopPerfStats")) : class$com$sun$portal$desktop$perf$DesktopPerfStats;
        synchronized (clazz) {
            long elapse = (System.currentTimeMillis() - this.timeStamp.getTime()) / 1000L;
            float throughput = (float)this.nbLogs / (float)elapse;
            report = "MBean Name: " + this.myObjectName.toString() + " since " + this.timeStamp + "\ncurrent\taverage\tmaximum\tminimum\toccurances\tthroughput(sec)" + "\n" + this.curPTime + "\t" + (this.nbLogs != 0 ? this.cumPTime / (long)this.nbLogs : 0L) + "\t" + this.hiwPTime + "\t" + this.lowPTime + "\t" + this.nbLogs + "\t\t" + throughput + "\n";
        }
        this.logMessage(report);
    }

    private void logMessage(String message) {
        Object[] param = new Object[]{message};
        String[] signature = new String[]{"java.lang.String"};
        try {
            this.myServer.invoke(this.getLogMessageMBean(), "logMessage", param, signature);
        }
        catch (JMException e) {
            // empty catch block
        }
    }

    private ObjectName getLogMessageMBean() throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        String name = "S1Desktop6.0_Performance_Audit_System:type=switch,name=" + this.myObjectName.getDomain();
        return new ObjectName(name);
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            this.logReport();
            if (this.refresh != 0) {
                Date curDate = new Date(System.currentTimeMillis() + 60000L * (long)this.getRefresh());
                Object[] params = new Object[]{"refresh.notification", "wakeup", null, curDate};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date"};
                Integer nId = (Integer)this.myServer.invoke(this.myTimer, "addNotification", params, signatures);
                TimerFilter filter = new TimerFilter(nId);
                this.myServer.addNotificationListener(this.myTimer, this.myObjectName, (NotificationFilter)filter, null);
                this.reset();
            }
        }
        catch (JMException e) {
            this.refresh = 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

