/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.cli.CLIPException;
import com.sun.portal.desktop.dp.cli.CLIPParser;
import com.sun.portal.desktop.dp.cli.DPAAdd;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAList;
import com.sun.portal.desktop.dp.cli.DPAModify;
import com.sun.portal.desktop.dp.cli.DPARemove;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

class DPACommand {
    protected static final String LIST = "list";
    protected static final String MODIFY = "modify";
    protected static final String ADD = "add";
    protected static final String REMOVE = "remove";
    protected static final String BATCH = "batch";
    protected static final int SUBCMD_LIST = 1;
    protected static final int SUBCMD_MODIFY = 2;
    protected static final int SUBCMD_ADD = 3;
    protected static final int SUBCMD_REMOVE = 4;
    protected static final int SUBCMD_BATCH = 5;
    protected static final String UID = "runasdn";
    protected static final String PASSWORD = "password";
    protected static final String DN = "dn";
    protected static final String GLOBAL = "global";
    protected static final String NAME = "name";
    protected static final String PARENT = "parent";
    protected static final String TYPE = "type";
    protected static final String COMBINE = "combine";
    protected static final String VERBOSE = "verbose";
    protected static final String VERSION = "version";
    protected static final String LOCALE = "locale";
    protected static final String DRYRUN = "dryrun";
    protected static final String CONT = "continue";
    protected static final String FILE = "file";
    public static final String OPT_DEFAULT = "*";
    public static final String LOCALE_DEFAULT = Locale.getDefault().toString();
    protected int subcmd = -1;
    protected String uid = null;
    protected String password = null;
    protected String dn = null;
    protected boolean global = false;
    protected boolean verbose = false;
    protected boolean version = false;
    protected String name = null;
    protected String parent = null;
    protected String type = null;
    protected boolean combine = false;
    protected boolean dryrun = false;
    protected String filename = null;
    protected InputStream xmlByteStream = null;
    protected boolean cont = false;
    protected String batchFile = null;
    protected boolean batchMode = false;

    DPACommand(CLIPParser clipp, String[] args, boolean batchMode) throws DPAException {
        this.batchMode = batchMode;
        this.parse(clipp, args);
    }

    DPACommand(CLIPParser clipp, String cmdEntry, boolean batchMode) throws DPAException {
        String cmd = null;
        try {
            BufferedReader br = new BufferedReader(new StringReader(cmdEntry));
            cmd = br.readLine();
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{cmdEntry};
            throw new DPAException("errorParseBatch", ex, tokens);
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        StringBuffer tokenBuf = new StringBuffer();
        boolean isQuoted = false;
        int i = 0;
        while (i < cmd.length()) {
            if (cmd.charAt(i) == '\"') {
                isQuoted = !isQuoted;
            } else if (!isQuoted && cmd.charAt(i) == ' ') {
                if (tokenBuf.length() > 0) {
                    cmdList.add(tokenBuf.toString());
                }
                tokenBuf = new StringBuffer();
            } else {
                tokenBuf.append(cmd.charAt(i));
            }
            ++i;
        }
        if (tokenBuf.length() > 0) {
            cmdList.add(tokenBuf.toString());
        }
        if (isQuoted) {
            Object[] tokens = new Object[]{cmdEntry};
            throw new DPAException("errorUnmatchedQuote", tokens);
        }
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        this.batchMode = batchMode;
        this.parse(clipp, cmdArray);
    }

    private void parse(CLIPParser clipp, String[] argv) throws DPAException {
        String[] types;
        String[] parents;
        String[] names;
        if (argv.length > 0 && (argv[0].equals("--version") || argv[0].equals("-V"))) {
            System.err.println(this.getVersionInfo());
            System.exit(0);
        }
        if (clipp.needsHelp(argv)) {
            System.err.println(clipp.getHelp(argv));
            System.exit(0);
        }
        Map options = null;
        try {
            options = clipp.getOptions(argv);
        }
        catch (CLIPException ce) {
            throw new DPAException("errorCLIPParseError", ce);
        }
        if (((String[])options.get(VERSION))[0].equals("true")) {
            System.err.println(this.getVersionInfo());
            System.exit(0);
        }
        try {
            clipp.verifyArguments(argv);
        }
        catch (CLIPException ce) {
            throw new DPAException("errorCLIPParseError", ce);
        }
        this.verbose = ((String[])options.get(VERBOSE))[0].equals("true");
        String sc = null;
        try {
            sc = clipp.getSubCommand(argv);
        }
        catch (CLIPException ce) {
            Object[] tokens = new Object[]{sc};
            throw new DPAException("errorInvalidSubCmd", ce, tokens);
        }
        if (sc.equals(LIST)) {
            this.subcmd = 1;
        } else if (sc.equals(MODIFY)) {
            this.subcmd = 2;
        } else if (sc.equals(ADD)) {
            this.subcmd = 3;
        } else if (sc.equals(REMOVE)) {
            this.subcmd = 4;
        } else if (sc.equals(BATCH)) {
            this.subcmd = 5;
        }
        if (this.subcmd != 5) {
            this.uid = ((String[])options.get(UID))[0];
            this.password = ((String[])options.get(PASSWORD))[0];
            if (this.password.equals(OPT_DEFAULT)) {
                System.out.print(DPAUtil.getLocalizedString("msgPassword"));
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String line = null;
                try {
                    line = br.readLine();
                }
                catch (IOException ioe) {
                    throw new DPAException("errorPassword", ioe);
                }
                this.password = line;
            }
            this.dn = ((String[])options.get(DN))[0];
            this.global = ((String[])options.get(GLOBAL))[0].equals("true");
            if (this.dn.equals(OPT_DEFAULT)) {
                if (!this.global) {
                    throw new DPAException("errorNoDNGlobal");
                }
            } else if (this.global) {
                throw new DPAException("errorBothDNGlobal");
            }
        } else {
            this.cont = ((String[])options.get(CONT))[0].equals("true");
            this.batchFile = ((String[])options.get(FILE))[0];
        }
        if (!(this.subcmd != 1 && this.subcmd != 4 || (names = (String[])options.get(NAME)) == null || names.length <= 0 || names[0].equals(OPT_DEFAULT))) {
            this.name = names[0];
        }
        if (!(this.subcmd != 3 && this.subcmd != 4 && this.subcmd != 2 || (parents = (String[])options.get(PARENT)) == null || parents.length <= 0 || parents[0].equals(OPT_DEFAULT))) {
            this.parent = parents[0];
        }
        if (this.subcmd == 4 && (types = (String[])options.get(TYPE)) != null && types.length > 0 && !types[0].equals(OPT_DEFAULT)) {
            this.type = types[0];
        }
        if (this.subcmd == 2) {
            this.combine = ((String[])options.get(COMBINE))[0].equals("true");
        }
        if (this.subcmd != 5) {
            this.dryrun = ((String[])options.get(DRYRUN))[0].equals("true");
        }
        if (this.subcmd == 2 || this.subcmd == 3) {
            this.xmlByteStream = this.getXMLInput(argv, clipp);
            if (this.xmlByteStream == null) {
                throw new DPAException("errorEmptyXML");
            }
        }
    }

    protected boolean isBatch() {
        return this.subcmd == 5;
    }

    private InputStream getXMLInput(String[] argv, CLIPParser clipp) throws DPAException {
        InputStream stream = null;
        String[] files = null;
        try {
            files = clipp.getOperands(argv);
        }
        catch (CLIPException ce) {
            Object[] tokens = new Object[]{ce.toString()};
            throw new DPAException("errorOperand", tokens);
        }
        if (files != null && files.length > 0) {
            this.filename = files[0];
        }
        if (this.filename != null) {
            File f = new File(this.filename);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.filename);
                int nBytes = fis.available();
                byte[] byteArray = new byte[nBytes];
                fis.read(byteArray);
                fis.close();
                stream = new ByteArrayInputStream(byteArray);
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{this.filename};
                throw new DPAException("errorFileRead", ioe, tokens);
            }
        } else if (!this.batchMode) {
            stream = new BufferedInputStream(System.in);
            ((InputStream)stream).mark(Integer.MAX_VALUE);
        }
        return stream;
    }

    protected void runCommand() throws DPAException {
        DSAMEAdminDPContext dadc = this.doAuth();
        switch (this.subcmd) {
            case 1: {
                DPAList dpal = new DPAList();
                String res = dpal.process(dadc, this.dn, this.global, this.name, this.verbose);
                if (res != null) {
                    byte[] bytes = null;
                    try {
                        bytes = res.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException ue) {
                        bytes = res.getBytes();
                    }
                    System.out.write(bytes, 0, bytes.length);
                    break;
                }
                throw new DPAException("errorNotFound");
            }
            case 2: {
                DPAModify dpam = new DPAModify();
                try {
                    dpam.process(dadc, this.dn, this.global, this.parent, this.combine, this.xmlByteStream, this.verbose, this.dryrun);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        this.xmlByteStream.close();
                    }
                    catch (IOException ioe) {
                        throw new DPAException("errorStreamClose", ioe);
                    }
                    throw throwable;
                }
                try {
                    this.xmlByteStream.close();
                }
                catch (IOException ioe) {
                    throw new DPAException("errorStreamClose", ioe);
                }
                if (!this.dryrun) {
                    System.out.println(DPAUtil.getLocalizedString("msgSuccess"));
                    break;
                }
                System.out.println(DPAUtil.getLocalizedString("msgDryrunSuccess"));
                break;
            }
            case 3: {
                DPAAdd dpaa = new DPAAdd();
                try {
                    dpaa.process(dadc, this.dn, this.global, this.parent, this.xmlByteStream, this.verbose, this.dryrun);
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    try {
                        this.xmlByteStream.close();
                    }
                    catch (IOException ioe) {
                        throw new DPAException("errorStreamClose", ioe);
                    }
                    throw throwable;
                }
                try {
                    this.xmlByteStream.close();
                }
                catch (IOException ioe) {
                    throw new DPAException("errorStreamClose", ioe);
                }
                if (!this.dryrun) {
                    System.out.println(DPAUtil.getLocalizedString("msgSuccess"));
                    break;
                }
                System.out.println(DPAUtil.getLocalizedString("msgDryrunSuccess"));
                break;
            }
            case 4: {
                DPARemove dpar = new DPARemove();
                dpar.process(dadc, this.dn, this.global, this.parent, this.name, this.type, this.verbose, this.dryrun);
                if (!this.dryrun) {
                    System.out.println(DPAUtil.getLocalizedString("msgSuccess"));
                    break;
                }
                System.out.println(DPAUtil.getLocalizedString("msgDryrunSuccess"));
                break;
            }
            default: {
                Object[] tokens = new Object[]{new Integer(this.subcmd)};
                throw new DPAException("errorInvalidSubCmd", tokens);
            }
        }
    }

    private DSAMEAdminDPContext doAuth() throws DPAException {
        DSAMEAdminDPContext dadc = null;
        String propertiesFile = System.getProperty("desktop.propertiesFile");
        if (propertiesFile == null) {
            throw new DPAException("errorProperties");
        }
        try {
            dadc = new DSAMEAdminDPContext();
            dadc.init(this.uid, this.password, propertiesFile, "desktop.dpadmin.debug");
        }
        catch (ContextError ce) {
            throw new DPAException("errorAuthFailed", ce);
        }
        return dadc;
    }

    protected static CLIPParser getCLIPParser(boolean batchMode) throws CLIPException {
        CLIPParser.SubCommand[] subcmds = null;
        CLIPParser.Option[] optsList = new CLIPParser.Option[]{new CLIPParser.Option(UID, "u", 1, null, DPAUtil.getLocalizedString("optUID")), new CLIPParser.Option(PASSWORD, "w", 1, batchMode ? null : OPT_DEFAULT, DPAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(DN, "d", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optDN")), new CLIPParser.Option(GLOBAL, "g", 0, "false", DPAUtil.getLocalizedString("optGlobal")), new CLIPParser.Option(NAME, "n", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optName")), new CLIPParser.Option(VERBOSE, "b", 0, "false", DPAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", DPAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, DPAUtil.getLocalizedString("optLocale")), new CLIPParser.Option(DRYRUN, "r", 0, "false", DPAUtil.getLocalizedString("optDryrun"))};
        CLIPParser.SubCommand scList = new CLIPParser.SubCommand(LIST, optsList, 0, 0, DPAUtil.getLocalizedString("helpList"), "");
        CLIPParser.Option[] optsModify = new CLIPParser.Option[]{new CLIPParser.Option(UID, "u", 1, null, DPAUtil.getLocalizedString("optUID")), new CLIPParser.Option(PASSWORD, "w", 1, batchMode ? null : OPT_DEFAULT, DPAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(DN, "d", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optDN")), new CLIPParser.Option(GLOBAL, "g", 0, "false", DPAUtil.getLocalizedString("optGlobal")), new CLIPParser.Option(PARENT, "p", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optParent")), new CLIPParser.Option(COMBINE, "m", 0, "false", DPAUtil.getLocalizedString("optCombine")), new CLIPParser.Option(VERBOSE, "b", 0, "false", DPAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", DPAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, DPAUtil.getLocalizedString("optLocale")), new CLIPParser.Option(DRYRUN, "r", 0, "false", DPAUtil.getLocalizedString("optDryrun"))};
        CLIPParser.SubCommand scModify = new CLIPParser.SubCommand(MODIFY, optsModify, 0, 1, DPAUtil.getLocalizedString("helpModify"), DPAUtil.getLocalizedString("helpFile"));
        CLIPParser.Option[] optsAdd = new CLIPParser.Option[]{new CLIPParser.Option(UID, "u", 1, null, DPAUtil.getLocalizedString("optUID")), new CLIPParser.Option(PASSWORD, "w", 1, batchMode ? null : OPT_DEFAULT, DPAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(DN, "d", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optDN")), new CLIPParser.Option(GLOBAL, "g", 0, "false", DPAUtil.getLocalizedString("optGlobal")), new CLIPParser.Option(PARENT, "p", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optParent")), new CLIPParser.Option(VERBOSE, "b", 0, "false", DPAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", DPAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, DPAUtil.getLocalizedString("optLocale")), new CLIPParser.Option(DRYRUN, "r", 0, "false", DPAUtil.getLocalizedString("optDryrun"))};
        CLIPParser.SubCommand scAdd = new CLIPParser.SubCommand(ADD, optsAdd, 0, 1, DPAUtil.getLocalizedString("helpAdd"), DPAUtil.getLocalizedString("helpFile"));
        CLIPParser.Option[] optsRemove = new CLIPParser.Option[]{new CLIPParser.Option(UID, "u", 1, null, DPAUtil.getLocalizedString("optUID")), new CLIPParser.Option(PASSWORD, "w", 1, batchMode ? null : OPT_DEFAULT, DPAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(DN, "d", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optDN")), new CLIPParser.Option(GLOBAL, "g", 0, "false", DPAUtil.getLocalizedString("optGlobal")), new CLIPParser.Option(NAME, "n", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optDN")), new CLIPParser.Option(PARENT, "p", 1, OPT_DEFAULT, DPAUtil.getLocalizedString("optParent")), new CLIPParser.Option(TYPE, "t", 1, null, DPAUtil.getLocalizedString("optType")), new CLIPParser.Option(VERBOSE, "b", 0, "false", DPAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", DPAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, DPAUtil.getLocalizedString("optLocale")), new CLIPParser.Option(DRYRUN, "r", 0, "false", DPAUtil.getLocalizedString("optDryrun"))};
        CLIPParser.SubCommand scRemove = new CLIPParser.SubCommand(REMOVE, optsRemove, 0, 0, DPAUtil.getLocalizedString("helpRemove"), "");
        if (!batchMode) {
            CLIPParser.Option[] optsBatch = new CLIPParser.Option[]{new CLIPParser.Option(CONT, "c", 0, "false", DPAUtil.getLocalizedString("optCont")), new CLIPParser.Option(FILE, "f", 1, null, DPAUtil.getLocalizedString("optFile")), new CLIPParser.Option(VERBOSE, "b", 0, "false", DPAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", DPAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, DPAUtil.getLocalizedString("optLocale"))};
            CLIPParser.SubCommand scBatch = new CLIPParser.SubCommand(BATCH, optsBatch, 0, 0, DPAUtil.getLocalizedString("helpBatch"), "");
            CLIPParser.SubCommand[] sc = new CLIPParser.SubCommand[]{scList, scModify, scAdd, scRemove, scBatch};
            subcmds = sc;
        } else {
            CLIPParser.SubCommand[] sc;
            subcmds = sc = new CLIPParser.SubCommand[]{scList, scModify, scAdd, scRemove};
        }
        return new CLIPParser(subcmds, DPAUtil.getLocalizedString("helpCmd"));
    }

    private String getVersionInfo() {
        ResourceBundle prodRB = ResourceBundle.getBundle("PSversion");
        StringBuffer vinfo = new StringBuffer();
        vinfo.append("dpadmin").append(" (").append(prodRB.getString("productversion")).append(") ").append("1.1");
        vinfo.append("\n").append(prodRB.getString("copyright"));
        return vinfo.toString();
    }
}

