/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.ParExtractionContext;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ParFile
extends JarFile {
    private ParManifest m_PMan = ParManifest.makeManifest(this.getManifest());
    private static final int CLASSFILE = 1;
    private static final int PBFILE = 3;
    private static final int STATFILE = 4;

    private ParFile(String path) throws Exception {
        super(path);
    }

    public static ParFile makeParFile(String path) throws ParFileException {
        try {
            return new ParFile(path);
        }
        catch (Exception ex) {
            throw new ParFileException("Exception creating ParFile object.", ex);
        }
    }

    public ParManifest getParManifest() {
        return this.m_PMan;
    }

    public void describe(PrintStream out) throws ParFileException {
        this.m_PMan.describe(out, this);
    }

    public void performAutoExtraction(ParExtractionContext pex, String dpnode) throws ParFileException {
        Vector nl = this.m_PMan.getDPEntryList();
        int i = 0;
        while (i < nl.size()) {
            String name = (String)nl.elementAt(i);
            ExtractOp op = this.m_PMan.getDPEntryAutoExtract(name);
            if (op != null) {
                if (dpnode != null) {
                    op.setDPNode(dpnode);
                }
                op.setEntryName(name);
                this.performExtraction(pex, op);
            }
            ++i;
        }
    }

    public void performExtraction(ParExtractionContext pex, ExtractOp op) throws ParFileException {
        pex.initializeForOperation(op);
        try {
            this.extractionOperation(pex, op);
        }
        catch (ParFileException ex) {
            pex.terminateOperation(false);
            throw ex;
        }
        pex.terminateOperation(true);
    }

    private void extractionOperation(ParExtractionContext pex, ExtractOp op) throws ParFileException {
        ZipEntry ze = this.m_PMan.getDPZip(op.getEntryName());
        InputStream is = this.getCheckedIS(ze);
        pex.putParEntryXMLFile(is, op.getTypes());
        Vector files = this.m_PMan.getDPEntryIncludeList(op.getEntryName(), op.getTypes());
        int i = 0;
        while (i < files.size()) {
            String path = (String)files.elementAt(i);
            ze = this.getJarEntry(path);
            is = this.getCheckedIS(ze);
            switch (this.m_PMan.getPathRootType(path)) {
                case 1: {
                    String fn = this.m_PMan.getFullFromClassPath(path);
                    pex.putClassFile(fn, is);
                    break;
                }
                case 3: {
                    String prop = this.m_PMan.getPropertyFromPBFPath(path);
                    String relp = this.m_PMan.getPathFromPBFPath(path);
                    pex.putPropLocFile(prop, relp, is);
                    break;
                }
                case 4: {
                    String sp = this.m_PMan.getPathFromStaticPath(path);
                    pex.putStaticFile(sp, is);
                    break;
                }
                default: {
                    throw new ParFileException("Unrecognized root type in included file list.");
                }
            }
            ++i;
        }
    }

    private InputStream getCheckedIS(ZipEntry ze) throws ParFileException {
        try {
            InputStream is = this.getInputStream(ze);
            if (is == null) {
                throw new ParFileException("Cannot find stream for zip entry.");
            }
            return is;
        }
        catch (Exception ex) {
            throw new ParFileException("Exception opening zip entry.", ex);
        }
    }
}

