/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.BasicFileHelper;
import com.sun.portal.desktop.deployment.ClassFilePPF;
import com.sun.portal.desktop.deployment.ClassJarPPF;
import com.sun.portal.desktop.deployment.ClassLoaderPPF;
import com.sun.portal.desktop.deployment.ClassPPF;
import com.sun.portal.desktop.deployment.DPBasedContext;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.PropLocPPF;
import com.sun.portal.desktop.deployment.ProviderPackageContext;
import com.sun.portal.desktop.deployment.ProviderPackageFile;
import com.sun.portal.desktop.deployment.StaticPPF;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPProvider;
import java.io.File;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DPBasedPPCtx
extends DPBasedContext
implements ProviderPackageContext {
    private DPRoot m_DPRoot;

    public DPBasedPPCtx(DPRootSpecifier dpr) throws ParFileException {
        this.m_DPRoot = dpr.getRoot();
    }

    public void setObject(String objname, int types) throws ParFileException {
        this.setPropertyHolder(this.m_DPRoot, objname, types);
    }

    public String getContainerName(String channel) throws ParFileException {
        DPChannel ch = this.getChannel();
        if (ch == null) {
            return null;
        }
        try {
            DPNode pn = ch.getParentNode();
            if (pn instanceof DPContainerChannel) {
                return pn.getName();
            }
        }
        catch (Exception ex) {
            throw new ParFileException("Exception obtaining container name.", ex);
        }
        return null;
    }

    public Document getParEntry(String entryname, String desc) throws ParFileException {
        DPChannel ch = this.getChannel();
        DPProvider pr = this.getProvider();
        Element chelt = ch == null ? null : ((XMLDPChannel)ch).getElement();
        Element pelt = pr == null ? null : ((XMLDPProvider)pr).getElement();
        return Par.makeParEntry(entryname, desc, pelt, chelt);
    }

    public ProviderPackageFile getStaticFile(String path, int types) throws ParFileException {
        return new StaticPPF(this.getStaticDirectory(), path, types);
    }

    public ProviderPackageFile getPropLocFile(String rootproperty, String path, int types) throws ParFileException {
        String rdir = this.getPBFProperty(rootproperty, false);
        return new PropLocPPF(rootproperty, rdir, path, types);
    }

    public ProviderPackageFile getClassFile(String classname, int types) throws ParFileException {
        Vector v = this.getClassPath();
        int i = 0;
        while (i < v.size()) {
            String croot = (String)v.elementAt(i);
            ClassPPF cpp = null;
            cpp = this.isJar(croot) ? new ClassJarPPF(classname, croot, types) : new ClassFilePPF(classname, croot, types);
            if (cpp.classExists()) {
                return cpp;
            }
            ++i;
        }
        ClassLoaderPPF cpp = new ClassLoaderPPF(classname, types);
        if (((ClassPPF)cpp).classExists()) {
            return cpp;
        }
        throw new ParFileException("cannot find class - " + classname);
    }

    public void addBasicFiles(Vector v) throws ParFileException {
        String hlp = this.getPBFProperty("DeploymentFileHelper", true);
        if (hlp == null) {
            return;
        }
        BasicFileHelper bh = null;
        try {
            bh = (BasicFileHelper)Class.forName(hlp).newInstance();
        }
        catch (Exception ex) {
            throw new ParFileException("Cannot instantiate helper class - " + hlp);
        }
        bh.addBasicFiles(this, this.getTypes(), v);
    }

    public String getPropertyString(String prop) throws ParFileException {
        return this.getPBFProperty(prop, true);
    }

    public void addDirectory(String prop, String subdir, boolean recurse, String dfilter, int types, Vector v) throws ParFileException {
        String rdir;
        String string = rdir = prop != null ? this.getPBFProperty(prop, false) : this.getStaticDirectory();
        if (rdir.endsWith("/")) {
            int len = rdir.length();
            rdir = rdir.substring(0, len - 1);
        }
        Vector<String> dlist = new Vector<String>();
        if (recurse) {
            if (dfilter != null && subdir != null) {
                dlist.add(subdir);
            }
            this.addSubDirs(dlist, rdir, subdir, dfilter);
        } else if (subdir != null) {
            dlist.add(subdir);
        }
        int i = 0;
        while (i < dlist.size()) {
            String dir = (String)dlist.elementAt(i);
            File f = new File(rdir + "/" + dir);
            File[] children = f.listFiles();
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    File child = children[j];
                    if (!child.isDirectory()) {
                        String rp = dir + "/" + child.getName();
                        if (prop != null) {
                            v.add(this.getPropLocFile(prop, rp, types));
                        } else {
                            v.add(this.getStaticFile(rp, types));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addSubDirs(Vector dlist, String rdir, String subdir, String dfilter) {
        File d = new File(subdir == null ? rdir : rdir + "/" + subdir);
        File[] children = d.listFiles();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            if (child.isDirectory()) {
                String nmplus;
                String nm = child.getName();
                String string = nmplus = subdir == null ? nm : subdir + "/" + nm;
                if (dfilter == null || dfilter.equals(nm)) {
                    dlist.add(nmplus);
                    this.addSubDirs(dlist, rdir, nmplus, null);
                } else {
                    this.addSubDirs(dlist, rdir, nmplus, dfilter);
                }
            }
            ++i;
        }
    }
}

