/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ClassInfoCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProviderClassLoader
extends ClassLoader {
    private boolean isFromSystemClasspath = true;
    private Class providerClass = null;
    private String theClassName;
    private static ClassInfoCache cic = null;
    private static String baseSearchDir = null;

    public ProviderClassLoader(String theClassName, ClassLoader parentClassLoader, String providerBaseDir) throws ClassNotFoundException {
        super(parentClassLoader);
        this.theClassName = theClassName;
        if (cic == null) {
            cic = ClassInfoCache.getInstance(providerBaseDir);
            if (cic != null) {
                baseSearchDir = ClassInfoCache.getSearchBaseDir();
            } else {
                throw new ClassNotFoundException("ProviderClassLoader(): Not able to get an instance of ClassInfoCache when called with className=" + theClassName);
            }
        }
        this.providerClass = this.loadClass(theClassName);
    }

    public ProviderClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public Class getProviderClass() {
        return this.providerClass;
    }

    public boolean isProviderClassOutOfDate() {
        boolean outdated = false;
        File fileHandle = cic.getHandle(this.theClassName);
        if (fileHandle != null) {
            long lastModTime = cic.getModifiedTime(this.theClassName);
            if (fileHandle != null && fileHandle.exists()) {
                outdated = fileHandle.lastModified() > lastModTime;
            } else {
                outdated = true;
                cic.removeClassInfo(this.theClassName);
            }
        } else if (!this.isFromSystemClasspath) {
            outdated = true;
        }
        return outdated;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class<?> rclass = null;
        byte[] classBytes = null;
        if (className.equals(this.theClassName)) {
            this.isFromSystemClasspath = false;
        }
        try {
            classBytes = this.findLocalClass(className);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("ProviderClassLoader.findClass() : not found class Name = " + className, ioe);
        }
        if (classBytes != null) {
            rclass = this.defineClass(className, classBytes, 0, classBytes.length);
            if (rclass == null) {
                throw new ClassNotFoundException("ProviderClassLoader.findClass() : not found class Name = " + className);
            }
        } else {
            throw new ClassNotFoundException("ProviderClassLoader.findClass() : not found class Name = " + className);
        }
        return rclass;
    }

    public byte[] findLocalClass(String className) throws IOException {
        byte[] result = null;
        String cString = className.replace('.', File.separatorChar) + ".class";
        String fullFileLocation = baseSearchDir + File.separatorChar + cString;
        File classFile = new File(fullFileLocation);
        if (!classFile.exists()) {
            File jarFile = cic.getJarFileHandle(className);
            if (jarFile != null && jarFile.isFile()) {
                ZipFile zip = new ZipFile(jarFile);
                ZipEntry entryInJar = zip.getEntry(cString);
                InputStream istream = zip.getInputStream(entryInJar);
                result = this.getClassData(istream);
                cic.setClassInfo(className, true, jarFile);
                istream.close();
                zip.close();
            }
        } else {
            FileInputStream fi = new FileInputStream(classFile);
            result = this.getClassData(fi);
            cic.setClassInfo(className, false, classFile);
            fi.close();
        }
        return result;
    }

    private byte[] getClassData(InputStream cistream) throws IOException {
        if (cistream == null) {
            return null;
        }
        byte[] byteBuf = new byte[1024];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int len = 0;
        while ((len = cistream.read(byteBuf)) != -1) {
            byteOut.write(byteBuf, 0, len);
        }
        return byteOut.toByteArray();
    }

    public URL getResource(String name) {
        URL resURL = null;
        File fHandle = new File(baseSearchDir + File.separatorChar + name);
        if (fHandle.canRead()) {
            try {
                resURL = fHandle.toURL();
            }
            catch (MalformedURLException mfu) {}
        } else {
            resURL = super.getResource(name);
        }
        return resURL;
    }
}

