/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.PropertiesContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserEvent;
import com.sun.portal.desktop.context.UserListener;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.IURLDecoder;
import com.sun.portal.desktop.util.IURLEncoder;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public abstract class PSProviderContext
implements ProviderContext,
UserListener {
    protected static Map propertiesContexts = new HashMap();
    protected PropertiesContext propertiesContext = null;
    private static ServletConfig servletConfig = null;
    protected DesktopContext desktopContext = null;

    public synchronized void init(HttpServletRequest req) {
        this.desktopContext = DesktopContextThreadLocalizer.get();
        servletConfig = ServletConfigThreadLocalizer.get();
        if (servletConfig == null) {
            throw new ContextError("PSProviderContext.init(): servlet config was null");
        }
        this.addUserListener(this);
        this.initPropertiesContext();
    }

    public void refresh() {
        this.getPropertiesContext().refresh();
    }

    public abstract void contentChanged(String var1);

    public abstract void allContentChanged();

    protected String getPropertiesContextClassName() {
        return this.getDesktopContext().getPropertiesContextClassName();
    }

    protected PropertiesContext getPropertiesContext() {
        if (this.propertiesContext == null) {
            throw new ContextError("PSProviderContext.getPropertiesContext(): not initialized");
        }
        return this.propertiesContext;
    }

    protected void initPropertiesContext() {
        Map map = propertiesContexts;
        synchronized (map) {
            if (this.propertiesContext == null) {
                this.propertiesContext = (PropertiesContext)propertiesContexts.get(this.getUserID());
            }
            if (this.propertiesContext == null) {
                String propertiesContextClassName = this.getPropertiesContextClassName();
                if (propertiesContextClassName == null) {
                    throw new ContextError("DesktopContext.getPropertiesContext(): class name was null");
                }
                try {
                    this.propertiesContext = (PropertiesContext)Class.forName(propertiesContextClassName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", ncdfe);
                }
                catch (IllegalAccessException iae) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", iae);
                }
                catch (ClassCastException cce) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", cce);
                }
                catch (InstantiationException ie) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", ie);
                }
                catch (SecurityException se) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", se);
                }
                this.propertiesContext.init(RequestThreadLocalizer.getRequest());
                propertiesContexts.put(this.getUserID(), this.propertiesContext);
            }
        }
    }

    protected DesktopContext getDesktopContext() {
        return this.desktopContext;
    }

    public String getClassName(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getClassName(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getClassName(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getStringProperty(channel, key, false);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, String def) throws ProviderContextException {
        try {
            return this.getStringProperty(channel, key, def, false);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, boolean localized) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getStringProperty(channel, key, localized);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, String def, boolean localized) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getStringProperty(channel, key, def, localized);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public void setStringProperty(String channel, String key, String val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setStringProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setStringProperty(): ", ce);
        }
    }

    public Iterator getNames(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getNames(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getNames(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionPropperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, boolean localized) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key, localized);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, Map def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, Map def, boolean localized) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key, def, localized);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public void setCollectionProperty(String channel, String key, Map val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setCollectionProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setCollectionProperty(): ", ce);
        }
    }

    public void setCollectionProperty(String channel, String key, List val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setCollectionProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setCollectionProperty(): ", ce);
        }
    }

    public void setListProperty(String channel, String key, List val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setListProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setListProperty(): ", ce);
        }
    }

    public boolean getBooleanProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getBooleanProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getBooleanProperty(): ", ce);
        }
    }

    public boolean getBooleanProperty(String channel, String key, boolean def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getBooleanProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getBooleanProperty(): ", ce);
        }
    }

    public void setBooleanProperty(String channel, String key, boolean val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setBooleanProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setBooleanProperty(): ", ce);
        }
    }

    public int getIntegerProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getIntegerProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getIntegerProperty(): ", ce);
        }
    }

    public Object getProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getProperty(): ", ce);
        }
    }

    public Object getProperty(String channel, String key, Object def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getProperty(): ", ce);
        }
    }

    public void setProperty(String channel, String key, Object val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setProperty(): ", ce);
        }
    }

    public int getIntegerProperty(String channel, String key, int def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getIntegerProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getIntegerProperty(): ", ce);
        }
    }

    public void setIntegerProperty(String channel, String key, int val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setIntegerProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setIntegerProperty(): ", ce);
        }
    }

    public boolean existsStringProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsStringProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsStringProperty(): ", ce);
        }
    }

    public boolean existsStringProperty(String channel, String name, boolean localized) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsStringProperty(channel, name, localized);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsStringProperty(): ", ce);
        }
    }

    public boolean existsBooleanProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsBooleanProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsBooleanProperty(): ", ce);
        }
    }

    public boolean existsIntegerProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsIntegerProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsIntegerProperty(): ", ce);
        }
    }

    public boolean existsCollectionProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsCollectionProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsCollectionProperty(): ", ce);
        }
    }

    public boolean existsCollectionProperty(String channel, String name, boolean localized) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsCollectionProperty(channel, name, localized);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsCollectionProperty(): ", ce);
        }
    }

    public String getProviderName(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProviderName(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getProviderName(): ", ce);
        }
    }

    public String getDesktopURL(HttpServletRequest req) {
        return this.getDesktopContext().getDesktopURL(req);
    }

    public String getLocaleString() {
        return this.getDesktopContext().getLocaleString();
    }

    public synchronized Locale getLocale() {
        return this.getDesktopContext().getLocale();
    }

    public String getDesktopType() {
        return this.getDesktopContext().getDesktopType();
    }

    public String getLogoutURL() {
        return this.getDesktopContext().getLogoutURL();
    }

    public String getStringAttribute(String name) {
        return this.getDesktopContext().getStringAttribute(name);
    }

    public void setStringAttribute(String name, String val) {
        this.getDesktopContext().setStringAttribute(name, val);
    }

    public String encodeURL(String url) {
        return this.getDesktopContext().encodeURL(url);
    }

    public String getDefaultChannelName() {
        return this.getDesktopContext().getDefaultChannelName();
    }

    public StringBuffer getRequestServer(HttpServletRequest req) {
        return this.getDesktopContext().getRequestServer(req);
    }

    public String getContentType() {
        return this.getDesktopContext().getContentType();
    }

    public String getCharset() {
        return this.getDesktopContext().getCharset();
    }

    public String getClientType() {
        return this.getDesktopContext().getClientType();
    }

    public String getDefaultClientType() {
        return this.getDesktopContext().getDefaultClientType();
    }

    public String getClientPath() {
        return this.getDesktopContext().getClientPath();
    }

    public String getClientTypeProperty(String key) {
        return this.getDesktopContext().getClientTypeProperty(key);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return this.getDesktopContext().getClientTypeProperty(clientType, key);
    }

    public Object getSessionProperty(String name) {
        return this.getDesktopContext().getSessionProperty(name);
    }

    public void setSessionProperty(String name, Object val) {
        this.getDesktopContext().setSessionProperty(name, val);
    }

    public String getSessionID() {
        return this.getDesktopContext().getSessionID();
    }

    public String getUserID() {
        return this.getDesktopContext().getUserID();
    }

    public void addSessionListener(SessionListener sl) {
        this.getDesktopContext().addSessionListener(sl);
    }

    public void addUserListener(UserListener ul) {
        this.getDesktopContext().addUserListener(ul);
    }

    public String getClientProperty(String name) {
        return this.getDesktopContext().getClientProperty(name);
    }

    public void setClientProperty(String name, String value) {
        this.getDesktopContext().setClientProperty(name, value);
    }

    public boolean isDebugEnabled() {
        return this.getDesktopContext().isDebugEnabled();
    }

    public boolean isDebugErrorEnabled() {
        return this.getDesktopContext().isDebugErrorEnabled();
    }

    public boolean isDebugWarningEnabled() {
        return this.getDesktopContext().isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.getDesktopContext().isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        this.getDesktopContext().debugMessage(o);
    }

    public void debugWarning(Object o) {
        this.getDesktopContext().debugWarning(o);
    }

    public void debugError(Object o) {
        this.getDesktopContext().debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        this.getDesktopContext().debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        this.getDesktopContext().debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        this.getDesktopContext().debugError(o, t);
    }

    public StringBuffer getTemplate(String name, String file) throws ProviderContextException {
        try {
            return this.getDesktopContext().getTemplate(name, this.getProviderName(name), file).getTemplateSB();
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getTemplate(): ", ce);
        }
    }

    public StringBuffer getTemplate(String name, String file, Hashtable table) throws ProviderContextException {
        try {
            return this.getDesktopContext().getTemplate(name, this.getProviderName(name), file, table);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getTemplate(): ", ce);
        }
    }

    public File getTemplatePath(String name, String file) throws ProviderContextException {
        return this.getDesktopContext().getTemplatePath(name, this.getProviderName(name), file);
    }

    public File getTemplateMostSpecificPath(String name, String file) throws ProviderContextException {
        return this.getDesktopContext().getTemplateMostSpecificPath(name, this.getProviderName(name), file);
    }

    public String getStaticContentPath() {
        return this.getDesktopContext().getStaticContentPath();
    }

    public ServletConfig getServletConfig() {
        return servletConfig;
    }

    public void userLogout(UserEvent ue) {
        String uid = ue.getUserID();
        Map map = propertiesContexts;
        synchronized (map) {
            propertiesContexts.remove(uid);
        }
    }

    public String getConfigProperty(String key) {
        return this.getDesktopContext().getConfigProperty(key);
    }

    public String encodeURLParameter(String key) {
        String enc = null;
        if (key != null && key.length() != 0) {
            try {
                enc = IURLEncoder.encode(I18n.encodeCharset(key, "UTF-8"));
            }
            catch (Exception e) {
                if (this.isDebugErrorEnabled()) {
                    this.debugError("PSProviderContext().URLEncode:Exception encoding String", e);
                }
                enc = "";
            }
        }
        return enc;
    }

    public String decodeURLParameter(String key) {
        String dec = null;
        if (key != null && key.length() != 0) {
            try {
                dec = I18n.decodeCharset(IURLDecoder.decode(key), "UTF-8");
            }
            catch (Exception e) {
                if (this.isDebugErrorEnabled()) {
                    this.debugError("PSProviderContext().URLDecode:Exception decoding String", e);
                }
                dec = "";
            }
        }
        return dec;
    }
}

