/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.ServiceContext;
import com.sun.portal.desktop.context.SessionContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserEvent;
import com.sun.portal.desktop.context.UserListener;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PSDesktopContext
implements DesktopContext,
UserListener {
    protected static DesktopAppContext desktopAppContext = null;
    protected static final String ROOT = "_desktopRoot";
    protected SessionContext session = null;
    protected ServiceContext service = null;
    protected static DPContext dpContext = null;
    protected DPUserContext dpUserContext = null;
    protected ContainerProviderContext containerProviderContext = null;
    protected static Map dpRoots = new HashMap();
    protected static Map dpUserRoots = new HashMap();
    protected static Map dummyDPUserRoots = new HashMap();
    protected static Map dpCustomized = new HashMap();
    private boolean dpChanged = false;
    protected static Map dpDocumentsLastRead = new HashMap();
    protected static Map dpUserDocumentsLastRead = new HashMap();
    protected Locale locale = null;
    protected String charset = null;
    private long lastAccess = 0L;
    private static String desktopURL = null;
    protected Map clientProperties = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$sun$portal$desktop$context$PSDesktopContext;

    public void init(HttpServletRequest req) {
        DesktopContextThreadLocalizer.set(this);
        if (desktopAppContext == null) {
            desktopAppContext = DesktopAppContextThreadLocalizer.get();
        }
        if (desktopAppContext == null) {
            throw new ContextError("PSDesktopContext.init(): could not get desktop app context");
        }
        this.initServiceContext(req);
        this.initSessionContext(req);
        this.addUserListener(this);
        this.initDPContext();
        this.initDPUserContext(req);
        this.initContainerProviderContext();
        this.initLocale();
    }

    protected SessionContext getSessionContext() {
        if (this.session == null) {
            throw new ContextError("PSDesktopContext.getSessionContext(): not initialized");
        }
        return this.session;
    }

    private SessionContext initSessionContext(HttpServletRequest req) {
        if (this.session == null) {
            String sessionContextClassName = null;
            sessionContextClassName = desktopAppContext.isAuthless(req) ? this.getAuthlessSessionContextClassName() : this.getSessionContextClassName();
            try {
                this.session = (SessionContext)Class.forName(sessionContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getSessionContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getSessionContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getSessionContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getSessionContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getSessionContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getSessionContext()", se);
            }
            this.session.init(req);
        }
        return this.session;
    }

    private DPContext getDPContext() {
        if (dpContext == null) {
            throw new ContextError("PSDesktopContext.getDPContext(): not initialized");
        }
        return dpContext;
    }

    private DPContext initDPContext() {
        Class clazz = class$com$sun$portal$desktop$context$PSDesktopContext == null ? (class$com$sun$portal$desktop$context$PSDesktopContext = PSDesktopContext.class$("com.sun.portal.desktop.context.PSDesktopContext")) : class$com$sun$portal$desktop$context$PSDesktopContext;
        synchronized (clazz) {
            if (dpContext == null) {
                String dpContextClassName = this.getDPContextClassName();
                if (dpContextClassName == null) {
                    throw new ContextError("DesktopContext.getDPContext(): class name was null");
                }
                try {
                    dpContext = (DPContext)Class.forName(dpContextClassName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ContextError("DesktopContext.getDPContext()", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ContextError("DesktopContext.getDPContext()", ncdfe);
                }
                catch (IllegalAccessException iae) {
                    throw new ContextError("DesktopContext.getDPContext()", iae);
                }
                catch (ClassCastException cce) {
                    throw new ContextError("DesktopContext.getDPContext()", cce);
                }
                catch (InstantiationException ie) {
                    throw new ContextError("DesktopContext.getDPContext()", ie);
                }
                catch (SecurityException se) {
                    throw new ContextError("DesktopContext.getDPContext()", se);
                }
                dpContext.init(RequestThreadLocalizer.getRequest());
            }
        }
        return dpContext;
    }

    protected DPUserContext getDPUserContext() {
        if (this.dpUserContext == null) {
            throw new ContextError("PSDesktopContext.getDPUserContext(): not initialized");
        }
        return this.dpUserContext;
    }

    protected DPUserContext initDPUserContext(HttpServletRequest req) {
        if (this.dpUserContext == null) {
            String dpUserContextClassName = this.getDPUserContextClassName();
            if (dpUserContextClassName == null) {
                throw new ContextError("DesktopContext.getDPUserContext(): class name was null");
            }
            try {
                this.dpUserContext = (DPUserContext)Class.forName(dpUserContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getDPUserContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getDPUserContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getDPUserContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getDPUserContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getDPUserContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getDPUserContext()", se);
            }
            if (desktopAppContext.isAuthless(req)) {
                String uid = desktopAppContext.getSessionID(req);
                Map authorized = desktopAppContext.getAuthorizedAuthlessUIDs();
                if (!authorized.containsKey(uid)) {
                    throw new ContextError("DesktopContext.initDPUserContext(): no password for authless uid=" + uid);
                }
                String pw = (String)authorized.get(uid);
                this.dpUserContext.init(req, uid, pw);
            } else {
                this.dpUserContext.init(req);
            }
        }
        return this.dpUserContext;
    }

    protected ServiceContext getServiceContext() {
        if (this.service == null) {
            throw new ContextError("PSDesktopContext.getServiceContext(): not initialized");
        }
        return this.service;
    }

    private ServiceContext initServiceContext(HttpServletRequest req) {
        if (this.service == null) {
            String serviceContextClassName = this.getServiceContextClassName();
            if (serviceContextClassName == null) {
                throw new ContextError("DesktopContext.getServiceContext(): class name was null");
            }
            try {
                this.service = (ServiceContext)Class.forName(serviceContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getServiceContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getServiceContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getServiceContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getServiceContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getServiceContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getServiceContext()", se);
            }
            if (desktopAppContext.isAuthless(req)) {
                String uid = desktopAppContext.getSessionID(req);
                Map authorized = desktopAppContext.getAuthorizedAuthlessUIDs();
                if (!authorized.containsKey(uid)) {
                    throw new ContextError("DesktopContext.initServiceContext(): no password for authless uid=" + uid);
                }
                String pw = (String)authorized.get(uid);
                this.service.init(req, uid, pw);
            } else {
                this.service.init(req);
            }
        }
        return this.service;
    }

    public ContainerProviderContext getContainerProviderContext() {
        if (this.containerProviderContext == null) {
            throw new ContextError("PSDesktopContext.getContainerProviderContext(): not initialized");
        }
        return this.containerProviderContext;
    }

    public ContainerProviderContext initContainerProviderContext() {
        if (this.containerProviderContext == null) {
            String providerContextClassName = this.getContainerProviderContextClassName();
            if (providerContextClassName == null) {
                throw new ContextError("DesktopContext.getContainerProviderContext(): provider context class name was null");
            }
            try {
                this.containerProviderContext = (ContainerProviderContext)Class.forName(providerContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getProviderContext(): ", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getProviderContext(): ", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getProviderContext(): ", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getProviderContext(): ", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getProviderContext(): ", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getProviderContext(): ", se);
            }
            this.containerProviderContext.init(RequestThreadLocalizer.getRequest());
        }
        return this.containerProviderContext;
    }

    public void store() {
        DPRoot dpr = this.getDPRoot();
        if (dpr.isDirty()) {
            DPRoot dPRoot = dpr;
            synchronized (dPRoot) {
                if (dpr.isDirty()) {
                    if (!this.isDPRootCustomized()) {
                        throw new ContextError("PSDesktopContext.store(): attempt to store non-customized dpRoot=" + dpr.toString());
                    }
                    long start = System.currentTimeMillis();
                    dpr.setDirty(false);
                    DPUserContext dpuc = this.getDPUserContext();
                    String dpRootString = dpr.toString();
                    dpuc.storeDPUserDocument(dpRootString);
                    long now = System.currentTimeMillis();
                    if (this.isPerfWarningEnabled()) {
                        this.perfWarning("PSDesktopContext.store(): to store user document: " + (now - start));
                    }
                    PSDesktopContext.setDPUserDocumentLastRead(this.getUserID());
                }
            }
        }
    }

    protected static void removeDPUserRoot(String uid) {
        dpUserRoots.remove(uid);
        dpUserDocumentsLastRead.remove(uid);
    }

    protected static void removeDPRoots(Set names) {
        dpRoots.keySet().removeAll(names);
        dpDocumentsLastRead.keySet().removeAll(names);
    }

    protected static long getDPUserDocumentLastRead(String uid) {
        Long l = (Long)dpUserDocumentsLastRead.get(uid);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    protected void setDPDocumentsLastRead() {
        Set names = this.getDPUserContext().getDPDocumentNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            long lastRead = this.getDPUserContext().getDPDocumentLastRead(name);
            if (lastRead == -1L) continue;
            Map map = dpRoots;
            synchronized (map) {
                dpDocumentsLastRead.put(name, new Long(lastRead));
            }
        }
    }

    protected static void setDPUserDocumentLastRead(String uid) {
        Long l = new Long(System.currentTimeMillis());
        dpUserDocumentsLastRead.put(uid, l);
    }

    protected static long getDPDocumentLastRead(String name) {
        Long l = (Long)dpDocumentsLastRead.get(name);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    protected Set getDPRootsModified() {
        int j = PerfThreadLocalizer.mark();
        HashSet<String> modified = null;
        Set names = this.getDPUserContext().getDPDocumentNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!this.isDPRootModified(name)) continue;
            if (modified == null) {
                modified = new HashSet<String>();
            }
            modified.add(name);
        }
        PerfThreadLocalizer.add(j, "PSDesktopContext.getDPRootsModified()");
        return modified;
    }

    protected boolean isDPRootModified(String name) {
        int j = PerfThreadLocalizer.mark();
        boolean modified = false;
        long lastModified = this.getDPUserContext().getDPDocumentLastModified(name);
        long lastRead = PSDesktopContext.getDPDocumentLastRead(name);
        if (lastRead != -1L && lastModified > lastRead) {
            modified = true;
        }
        return modified;
    }

    protected boolean isDPUserRootModified() {
        int i = PerfThreadLocalizer.mark();
        boolean modified = false;
        long userLastModified = this.getDPUserContext().getDPUserDocumentLastModified();
        long userLastRead = PSDesktopContext.getDPUserDocumentLastRead(this.getUserID());
        if (userLastRead != -1L && userLastModified > userLastRead) {
            modified = true;
        }
        PerfThreadLocalizer.add(i, "PSDesktopContext.isDPUserRootModified()");
        return modified;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long ms) {
        this.lastAccess = ms;
    }

    public void refresh() {
        int i = PerfThreadLocalizer.mark();
        boolean modified = false;
        Set modifiedNames = null;
        boolean dpUserRootModified = false;
        if (this.isDPRootCustomized() || this.isDPRootSet()) {
            dpUserRootModified = this.isDPUserRootModified();
            modifiedNames = this.getDPRootsModified();
            modified = dpUserRootModified || modifiedNames != null;
        } else {
            modifiedNames = this.getDPRootsModified();
            boolean bl = modified = modifiedNames != null;
        }
        if (modified) {
            Map map = dpUserRoots;
            synchronized (map) {
                if (modifiedNames != null) {
                    PSDesktopContext.removeDPRoots(modifiedNames);
                    this.removeDummyDPRoots(modifiedNames);
                    PSDesktopContext.removeDPUserRoot(this.getUserID());
                } else if (dpUserRootModified) {
                    PSDesktopContext.removeDPUserRoot(this.getUserID());
                }
            }
            ContainerProviderContext cpc = this.getContainerProviderContext();
            cpc.refresh();
        }
        PerfThreadLocalizer.add(i, "PSDesktopContext.refresh()");
    }

    protected static DPRoot createDPRoot(DPContext dpc, DPUserContext dpuc) {
        DPRoot dpr = XMLDPFactory.getInstance().createRoot(dpc, dpuc, dpRoots, true);
        return dpr;
    }

    public void setDPRootCustomized(boolean state) {
        String uid = this.getUserID();
        Map map = dpCustomized;
        synchronized (map) {
            if (state) {
                dpCustomized.put(uid, Boolean.TRUE);
            } else {
                dpCustomized.put(uid, Boolean.FALSE);
            }
        }
    }

    public boolean isDPRootCustomized() {
        String uid = this.getUserID();
        Boolean c = (Boolean)dpCustomized.get(uid);
        if (c == null) {
            return false;
        }
        boolean b = c;
        return b;
    }

    protected boolean isDPRootSet() {
        DPUserContext dpuc = this.getDPUserContext();
        byte[] doc = dpuc.getDPUserDocument();
        boolean b = doc != null && doc.length > 0;
        return b;
    }

    protected String getDummyDPRootKey() {
        Set names = this.getDPUserContext().getDPDocumentNames();
        ArrayList namesList = new ArrayList(names);
        Collections.sort(namesList);
        return ((Object)namesList).toString();
    }

    protected static DPRoot getDummyDPUserRoot(String key) {
        return (DPRoot)dummyDPUserRoots.get(key);
    }

    protected static void setDummyDPUserRoot(String key, DPRoot dpr) {
        Map map = dummyDPUserRoots;
        synchronized (map) {
            dummyDPUserRoots.put(key, dpr);
        }
    }

    public DPRoot getDPRoot() {
        DPRoot dpRoot = null;
        int i = PerfThreadLocalizer.mark();
        if (this.isDPRootCustomized() || this.isDPRootSet()) {
            String uid = this.getUserID();
            dpRoot = (DPRoot)dpUserRoots.get(uid);
            if (dpRoot == null) {
                DPContext dpc = this.getDPContext();
                DPUserContext dpuc = this.getDPUserContext();
                dpRoot = PSDesktopContext.createDPRoot(dpc, dpuc);
                Map map = dpUserRoots;
                synchronized (map) {
                    dpUserRoots.put(uid, dpRoot);
                    long userLastRead = dpuc.getDPUserDocumentLastRead();
                    dpUserDocumentsLastRead.put(uid, new Long(userLastRead));
                }
                this.setDPDocumentsLastRead();
                this.setDPRootCustomized(true);
            }
        } else {
            String key = this.getDummyDPRootKey();
            dpRoot = PSDesktopContext.getDummyDPUserRoot(key);
            if (dpRoot == null) {
                DPContext dpc = this.getDPContext();
                DPUserContext dpuc = this.getDPUserContext();
                dpRoot = PSDesktopContext.createDPRoot(dpc, dpuc);
                PSDesktopContext.setDummyDPUserRoot(key, dpRoot);
                this.setDPDocumentsLastRead();
                this.setDPRootCustomized(false);
            }
        }
        PerfThreadLocalizer.add(i, "PSDesktopContext.getDPRoot()");
        return dpRoot;
    }

    protected void removeDummyDPRoots(Set names) {
        Map map = dummyDPUserRoots;
        synchronized (map) {
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                Iterator j = dummyDPUserRoots.keySet().iterator();
                while (j.hasNext()) {
                    String key = (String)j.next();
                    if (key.indexOf(name) == -1) continue;
                    j.remove();
                }
            }
        }
    }

    public String getPropertiesContextClassName() {
        return this.getServiceContext().getPropertiesContextClassName();
    }

    public String getContainerProviderContextClassName() {
        return this.getServiceContext().getContainerProviderContextClassName();
    }

    protected String getSessionContextClassName() {
        return this.getServiceContext().getSessionContextClassName();
    }

    protected String getAuthlessSessionContextClassName() {
        return this.getServiceContext().getAuthlessSessionContextClassName();
    }

    protected String getDPContextClassName() {
        return this.getServiceContext().getDPContextClassName();
    }

    protected String getDPUserContextClassName() {
        return this.getServiceContext().getDPUserContextClassName();
    }

    protected String getServiceContextClassName() {
        return desktopAppContext.getServiceContextClassName();
    }

    public String getLocaleString() {
        return this.getServiceContext().getLocaleString();
    }

    private boolean isLocaleChanged() {
        String newLocale = this.getLocaleString();
        return newLocale != null && !newLocale.equals(this.locale.toString());
    }

    public Locale getLocale() {
        if (this.locale == null) {
            throw new ContextError("PSDesktopContext.getLocale(): not initialized");
        }
        if (this.isLocaleChanged()) {
            this.locale = PSDesktopContext.initLocale(this.getLocaleString());
        }
        return this.locale;
    }

    protected Locale initLocale() {
        this.locale = PSDesktopContext.initLocale(this.getLocaleString());
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    protected static Locale initLocale(String stringformat) {
        if (stringformat == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tokenizer.hasMoreTokens()) {
            lang = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public String getDesktopType() {
        return this.getServiceContext().getDesktopType();
    }

    public String getDesktopURL(HttpServletRequest req) {
        if (desktopURL == null) {
            desktopURL = this.getRequestServer(req) + req.getContextPath() + req.getServletPath();
        }
        return desktopURL;
    }

    public String getLogoutURL() {
        return this.getServiceContext().getLogoutURL();
    }

    public String getDefaultChannelName() {
        String name = this.getClientProperty("lastChannelName");
        if (name == null || name.length() == 0 || this.getProvider(RequestThreadLocalizer.getRequest(), name) == null) {
            name = this.getServiceContext().getDefaultChannelName();
        }
        return name;
    }

    public void setDefaultChannelName(String channel) {
        this.setClientProperty("lastChannelName", channel);
    }

    public String getEditProviderContainerName() {
        return this.getServiceContext().getEditProviderContainerName();
    }

    public String getTemplateBaseDir() {
        return desktopAppContext.getTemplateBaseDir();
    }

    public boolean isExecutable() {
        return this.getServiceContext().isExecutable();
    }

    public String getStringAttribute(String name) {
        return this.getServiceContext().getStringAttribute(name);
    }

    public void setStringAttribute(String name, String val) {
        this.getServiceContext().setStringAttribute(name, val);
    }

    public StringBuffer getRequestServer(HttpServletRequest req) {
        return desktopAppContext.getRequestServer(req);
    }

    public String getContentType() {
        return desktopAppContext.getContentType(this.getClientType());
    }

    public String getCharset() {
        if (this.isLocaleChanged()) {
            this.locale = PSDesktopContext.initLocale(this.getLocaleString());
        }
        return desktopAppContext.getCharset(this.getClientType(), this.locale);
    }

    public String getClientType() {
        return desktopAppContext.getClientType();
    }

    public String getDefaultClientType() {
        return desktopAppContext.getDefaultClientType();
    }

    public String getClientPath() {
        return desktopAppContext.getClientPath(this.getClientType());
    }

    public String getClientTypeProperty(String key) {
        return this.getClientTypeProperty(this.getClientType(), key);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return desktopAppContext.getClientTypeProperty(clientType, key);
    }

    public Object getSessionProperty(String name) {
        return this.clientProperties.get(name);
    }

    public void setSessionProperty(String name, Object val) {
        this.clientProperties.put(name, val);
    }

    public String getSessionID() {
        String sid = this.getSessionContext().getSessionID();
        if (sid == null) {
            sid = desktopAppContext.getDefaultAuthlessUID();
        }
        return sid;
    }

    public void addSessionListener(SessionListener sl) {
        this.getSessionContext().addSessionListener(sl);
    }

    public String encodeURL(String url) {
        return this.getSessionContext().encodeURL(url);
    }

    public String getUserID() {
        String uid = this.getSessionContext().getUserID();
        if (uid == null) {
            uid = desktopAppContext.getDefaultAuthlessUID();
        }
        return uid;
    }

    public void addUserListener(UserListener ul) {
        this.getSessionContext().addUserListener(ul);
    }

    public String getClientProperty(String name) {
        return this.getSessionContext().getStringProperty(name);
    }

    public void setClientProperty(String name, String value) {
        this.getSessionContext().setStringProperty(name, value);
    }

    public Provider getProvider(HttpServletRequest req, String name) {
        return this.getContainerProviderContext().getProvider(req, ROOT, name);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res, String name) throws ProviderException {
        return this.getContainerProviderContext().getContent(req, res, ROOT, name);
    }

    public Map getContent(HttpServletRequest req, HttpServletResponse res, List providers, int timeout) throws ProviderException {
        return this.getContainerProviderContext().getContent(req, res, ROOT, providers, timeout);
    }

    public short getDebugLevel() {
        return desktopAppContext.getDebugLevel();
    }

    public void setDebugLevel(short level) {
        desktopAppContext.setDebugLevel(level);
    }

    public boolean isDebugEnabled() {
        return desktopAppContext.isDebugEnabled();
    }

    public boolean isDebugErrorEnabled() {
        return desktopAppContext.isDebugErrorEnabled();
    }

    public boolean isDebugWarningEnabled() {
        return desktopAppContext.isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return desktopAppContext.isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        desktopAppContext.debugMessage(o);
    }

    public void debugWarning(Object o) {
        desktopAppContext.debugWarning(o);
    }

    public void debugError(Object o) {
        desktopAppContext.debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        desktopAppContext.debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        desktopAppContext.debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        desktopAppContext.debugError(o, t);
    }

    public short getPerfLevel() {
        return desktopAppContext.getPerfLevel();
    }

    public void setPerfLevel(short level) {
        desktopAppContext.setPerfLevel(level);
    }

    public boolean isPerfEnabled() {
        return desktopAppContext.isPerfEnabled();
    }

    public boolean isPerfErrorEnabled() {
        return desktopAppContext.isPerfErrorEnabled();
    }

    public boolean isPerfWarningEnabled() {
        return desktopAppContext.isPerfWarningEnabled();
    }

    public boolean isPerfMessageEnabled() {
        return desktopAppContext.isPerfMessageEnabled();
    }

    public void perfMessage(Object o) {
        desktopAppContext.perfMessage(o);
    }

    public void perfWarning(Object o) {
        desktopAppContext.perfWarning(o);
    }

    public void perfError(Object o) {
        desktopAppContext.perfError(o);
    }

    public void perfMessage(Object o, Throwable t) {
        desktopAppContext.perfMessage(o, t);
    }

    public void perfWarning(Object o, Throwable t) {
        desktopAppContext.perfWarning(o, t);
    }

    public void perfError(Object o, Throwable t) {
        desktopAppContext.perfError(o, t);
    }

    public boolean isPasContextActivated() {
        return desktopAppContext.isPasContextActivated();
    }

    public void logProcessTime(String name, String operation, String subject, long elapse) {
        desktopAppContext.logProcessTime(name, operation, subject, elapse);
    }

    public ParsedTagArray getTemplate(String app, String provider, String file) {
        return desktopAppContext.getTemplate(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file);
    }

    public StringBuffer getTemplate(String app, String provider, String file, Hashtable table) {
        ContainerProviderContext pc = null;
        try {
            pc = this.getContainerProviderContext();
        }
        catch (ContextError e) {
            // empty catch block
        }
        return desktopAppContext.getTemplate(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file, table, pc);
    }

    public File getTemplatePath(String app, String provider, String file) {
        return desktopAppContext.getTemplatePath(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file);
    }

    public File getTemplateMostSpecificPath(String app, String provider, String file) {
        return desktopAppContext.getTemplateMostSpecificPath(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file);
    }

    public void userLogout(UserEvent ue) {
        String uid = ue.getUserID();
        Map map = dpUserRoots;
        synchronized (map) {
            PSDesktopContext.removeDPUserRoot(uid);
        }
        Map map2 = dpCustomized;
        synchronized (map2) {
            dpCustomized.remove(uid);
        }
    }

    public String getProviderClassBaseDir() {
        return desktopAppContext.getProviderClassBaseDir();
    }

    public String getJSPScratchDir() {
        return desktopAppContext.getJSPScratchDir();
    }

    public String getJSPCompilerWARClassPath() {
        return desktopAppContext.getJSPCompilerWARClassPath();
    }

    public String getStaticContentPath() {
        return desktopAppContext.getStaticContentPath();
    }

    public String getConfigProperty(String key) {
        return desktopAppContext.getConfigProperty(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

