/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.PerfData;
import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.desktop.context.PSProviderContext;
import com.sun.portal.desktop.context.ProviderCallerPool;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.desktop.context.ProviderGetterPool;
import com.sun.portal.desktop.context.ReusableProviderCaller;
import com.sun.portal.desktop.context.ReusableProviderGetter;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PSContainerProviderContext
extends PSProviderContext
implements ContainerProviderContext {
    protected Map providerCache = new HashMap();
    private static int DEFAULT_MIN_SIZE = 0;
    private static int DEFAULT_MAX_SIZE = 10000;
    private static int DEFAULT_PARTITION_SIZE = 13;
    protected static ProviderCallerPool callerPool = null;
    protected static ProviderGetterPool getterPool = null;
    protected Map cachedContent = new HashMap();
    protected Map cachedTime = new HashMap();
    protected static Map classesMap = new HashMap();
    static /* synthetic */ Class class$com$sun$portal$providers$Provider;

    public synchronized void init(HttpServletRequest req) {
        super.init(req);
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        if (callerPool == null) {
            this.initCallerPool(dac);
        }
        if (getterPool == null) {
            this.initGetterPool(dac);
        }
    }

    public void refresh() {
        super.refresh();
        this.cachedContent = new HashMap();
        this.cachedTime = new HashMap();
        this.providerCache.clear();
    }

    public void contentChanged(String channel) {
        this.removeCachedContent(channel);
    }

    public void allContentChanged() {
        this.removeAllCachedContent();
    }

    public boolean existsChannel(String channel) {
        return this.getPropertiesContext().existsChannel(channel);
    }

    public void createChannel(String channelName, String providerName) throws ProviderContextException {
        try {
            this.getPropertiesContext().createChannel(channelName, providerName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.createChannel ", ce);
        }
    }

    public void createContainer(String channelName, String providerName) throws ProviderContextException {
        try {
            this.getPropertiesContext().createContainer(channelName, providerName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.createContainer", ce);
        }
    }

    public void removeChannel(String channelName) throws ProviderContextException {
        try {
            this.getPropertiesContext().removeChannel(channelName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.removeChannel ", ce);
        }
    }

    public List getSelectedChannels(String container) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getSelectedChannels(container);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.getSelectedChannels ", ce);
        }
    }

    public List getAvailableChannels(String container) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getAvailableChannels(container);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.getAvailableChannels ", ce);
        }
    }

    public void setSelectedChannels(String container, List sel) throws ProviderContextException {
        try {
            this.getPropertiesContext().setSelectedChannels(container, sel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.setSelectedChannels ", ce);
        }
    }

    public void setAvailableChannels(String container, List avail) throws ProviderContextException {
        try {
            this.getPropertiesContext().setAvailableChannels(container, avail);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.setAvailableChannels ", ce);
        }
    }

    public Provider getProvider(HttpServletRequest req, String parent, String channel) {
        Provider p = (Provider)this.providerCache.get(channel);
        if (p == null) {
            block8: {
                try {
                    p = this.initProvider(req, parent, channel);
                }
                catch (ProviderContextException pce) {
                    if (!this.isDebugErrorEnabled()) break block8;
                    this.debugError("PSContainerProviderContext.getProvider(): failed to initialize provider for channel=" + channel, pce);
                }
            }
            if (p != null) {
                Map map = this.providerCache;
                synchronized (map) {
                    if (this.providerCache.get(channel) == null) {
                        this.providerCache.put(channel, p);
                    }
                }
            }
        }
        return p;
    }

    private Provider initProvider(HttpServletRequest req, String parent, String channel) throws ProviderContextException {
        String providerClassName = null;
        providerClassName = this.getClassName(channel);
        Provider p = null;
        DesktopContext dc = this.getDesktopContext();
        try {
            Class pclClass;
            ProviderClassLoader pcl = (ProviderClassLoader)classesMap.get(providerClassName);
            if (pcl == null || pcl.isProviderClassOutOfDate()) {
                pcl = new ProviderClassLoader(providerClassName, (class$com$sun$portal$providers$Provider == null ? (class$com$sun$portal$providers$Provider = PSContainerProviderContext.class$("com.sun.portal.providers.Provider")) : class$com$sun$portal$providers$Provider).getClassLoader(), dc.getProviderClassBaseDir());
                classesMap.put(providerClassName, pcl);
            }
            if ((pclClass = pcl.getProviderClass()) == null) {
                this.debugError("PSContainerProviderContext.initProvider(): incorrect provider class name (" + providerClassName + ") for channel=" + channel + ", parent=" + parent);
                return null;
            }
            p = (Provider)pclClass.newInstance();
            p.init(channel, req);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.debugError("PSContainerProviderContext.initProvider()", ncdfe);
        }
        catch (IllegalAccessException iae) {
            this.debugError("PSContainerProviderContext.initProvider()", iae);
        }
        catch (ClassCastException cce) {
            this.debugError("PSContainerProviderContext.initProvider()", cce);
        }
        catch (InstantiationException ie) {
            this.debugError("PSContainerProviderContext.initProvider()", ie);
        }
        catch (SecurityException se) {
            this.debugError("PSContainerProviderContext.initProvider()", se);
        }
        catch (ProviderException pe) {
            this.debugError("PSContainerProviderContext.initProvider()", pe);
        }
        catch (ClassNotFoundException cnfe) {
            this.debugError("PSContainerProviderContext.initProvider()", cnfe);
        }
        return p;
    }

    public void initProviders(HttpServletRequest req, String parent, List providers, int timeout) {
        Monitor monitor = new Monitor();
        HashMap<String, ReusableProviderGetter> getters = new HashMap<String, ReusableProviderGetter>();
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        DesktopContext dc = DesktopContextThreadLocalizer.get();
        ServletConfig sc = ServletConfigThreadLocalizer.get();
        PerfData pd = PerfThreadLocalizer.getPerfData();
        HttpServletResponse res = RequestThreadLocalizer.getResponse();
        int i = 0;
        while (i < providers.size()) {
            String channel = (String)providers.get(i);
            monitor.addTask();
            ReusableProviderGetter getter = getterPool.obtainGetter(dac, dc, this, parent, channel, monitor, req, res, sc, pd);
            if (getter == null) {
                this.debugError("PSContainerContext:initProviders(): Unable to obtain getter thread from getterPool");
            } else {
                getter.execute();
                getters.put(channel, getter);
            }
            ++i;
        }
        monitor.start();
        if (!monitor.isDoneWaiting(timeout)) {
            this.debugError("PSContainerProviderContext.initProviders(): failed to init providers,\t completed = " + monitor.getCompleted());
        }
        Iterator i2 = getters.keySet().iterator();
        while (i2.hasNext()) {
            String providerName = (String)i2.next();
            if (monitor.contains(providerName)) continue;
            ReusableProviderGetter getter = (ReusableProviderGetter)getters.get(providerName);
            getter.interrupt();
        }
    }

    protected synchronized void removeCachedContent(String name) {
        this.cachedContent.remove(name);
        this.cachedTime.remove(name);
    }

    protected synchronized void removeAllCachedContent() {
        this.cachedContent.clear();
        this.cachedTime.clear();
    }

    public synchronized void putCachedContent(String name, StringBuffer content) {
        this.cachedContent.put(name, content);
        this.cachedTime.put(name, new Long(System.currentTimeMillis() / 1000L));
    }

    public StringBuffer getCachedContent(String name) {
        return (StringBuffer)this.cachedContent.get(name);
    }

    public long getCachedTime(String name) {
        Long t = (Long)this.cachedTime.get(name);
        if (t == null) {
            return 0L;
        }
        return t;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res, String parent, String name) throws ProviderException {
        long start = System.currentTimeMillis();
        Provider p = this.getProvider(req, parent, name);
        if (p == null) {
            return null;
        }
        long end = System.currentTimeMillis();
        if (this.getDesktopContext().isPerfMessageEnabled()) {
            this.getDesktopContext().perfMessage("PSContainerProviderContext.getContent(): to get provider=" + name + ", elapsed=" + (end - start));
        }
        if (this.getDesktopContext().isPasContextActivated()) {
            start = System.currentTimeMillis();
        }
        long refreshTime = 0L;
        try {
            refreshTime = p.getRefreshTime();
        }
        catch (ProviderException pe) {
            this.debugError("PSContainerProviderContext.getContent(): Failed to get refresh time of channel " + name + " " + pe);
        }
        long timeCached = this.getCachedTime(name);
        long now = System.currentTimeMillis() / 1000L;
        StringBuffer content = this.getCachedContent(name);
        if (content == null || timeCached != -1L && now >= timeCached + refreshTime) {
            content = p.getContent(req, res);
            if (this.getDesktopContext().isPasContextActivated()) {
                end = System.currentTimeMillis();
                this.getDesktopContext().logProcessTime("container", "get_content_from_provider", name, end - start);
            }
            if (this.getDesktopContext().isPerfWarningEnabled()) {
                this.getDesktopContext().perfWarning("PSContainerProviderContext.getContent(): to get content for channel=" + name + ", elapsed=" + (end - start));
            }
            if (refreshTime > 0L) {
                this.putCachedContent(p.getName(), content);
            }
        } else {
            if (this.getDesktopContext().isPerfWarningEnabled()) {
                this.getDesktopContext().perfWarning("PSContainerProviderContext.getContent(): returning cached content for channel=" + name);
            }
            if (this.getDesktopContext().isPasContextActivated()) {
                end = System.currentTimeMillis();
                this.getDesktopContext().logProcessTime("container", "get_content_from_cache", name, end - start);
            }
        }
        return content;
    }

    public Map getContent(HttpServletRequest req, HttpServletResponse res, String parent, List providers, int timeout) throws ProviderException {
        Monitor monitor = new Monitor();
        HashMap<String, StringBuffer> content = new HashMap<String, StringBuffer>();
        HashMap<String, ReusableProviderCaller> callers = new HashMap<String, ReusableProviderCaller>();
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        DesktopContext dc = DesktopContextThreadLocalizer.get();
        ServletConfig sc = ServletConfigThreadLocalizer.get();
        PerfData pd = PerfThreadLocalizer.getPerfData();
        int i = 0;
        while (i < providers.size()) {
            String channel = (String)providers.get(i);
            Provider p = this.getProvider(req, parent, channel);
            if (p != null) {
                long refreshTime = 0L;
                try {
                    refreshTime = p.getRefreshTime();
                }
                catch (ProviderException pe) {
                    this.debugError("PSContainerProviderContext.getContent(): Failed to get refresh time of channel " + channel + " " + pe);
                }
                long timeCached = this.getCachedTime(channel);
                long now = System.currentTimeMillis() / 1000L;
                StringBuffer channelContent = this.getCachedContent(channel);
                if (channelContent == null || timeCached != -1L && now >= timeCached + refreshTime) {
                    monitor.addTask();
                    ReusableProviderCaller caller = callerPool.obtainCaller(dac, dc, this, p, monitor, req, res, sc, pd);
                    if (caller == null) {
                        this.debugError("PSContainerContext:getContent(): Unable to obtain caller thread from callerPool");
                    } else {
                        caller.execute();
                        callers.put(p.getName(), caller);
                    }
                } else {
                    if (this.getDesktopContext().isPerfWarningEnabled()) {
                        this.getDesktopContext().perfWarning("PSContainerProviderContext.getContent(): using cached content for channel=" + channel);
                    }
                    content.put(channel, channelContent);
                }
            }
            ++i;
        }
        monitor.start();
        if (!monitor.isDoneWaiting(timeout)) {
            this.debugError("PSContainerProviderContext.getContent(): failed to get content, completed=" + monitor.getCompleted().keySet());
        }
        content.putAll(monitor.getCompleted());
        Iterator i2 = callers.keySet().iterator();
        while (i2.hasNext()) {
            String providerName = (String)i2.next();
            if (monitor.contains(providerName)) continue;
            ReusableProviderCaller caller = (ReusableProviderCaller)callers.get(providerName);
            caller.interrupt();
        }
        return content;
    }

    private void initCallerPool(DesktopAppContext dac) {
        int partitionSize;
        int maxSize;
        int minSize = dac.getCallerPoolMinSize();
        if (minSize < 0) {
            dac.debugWarning("ProviderCallerPool: invalid min size " + minSize + ", use default: " + DEFAULT_MIN_SIZE);
            minSize = DEFAULT_MIN_SIZE;
        }
        if ((maxSize = dac.getCallerPoolMaxSize()) < 0) {
            dac.debugWarning("ProviderCallerPool: invalid max size " + maxSize + ", use default: " + DEFAULT_MAX_SIZE);
            maxSize = DEFAULT_MAX_SIZE;
        }
        if ((partitionSize = dac.getCallerPoolPartitionSize()) <= 0) {
            dac.debugWarning("ProviderCallerPool: invalid partition size " + partitionSize + ", use default: " + DEFAULT_PARTITION_SIZE);
            partitionSize = DEFAULT_PARTITION_SIZE;
        }
        callerPool = new ProviderCallerPool(minSize, maxSize, true, partitionSize);
    }

    private void initGetterPool(DesktopAppContext dac) {
        int partitionSize;
        int maxSize;
        int minSize = dac.getGetterPoolMinSize();
        if (minSize < 0) {
            dac.debugWarning("ProviderGetterPool: invalid min size " + minSize + ", use default: " + DEFAULT_MIN_SIZE);
            minSize = DEFAULT_MIN_SIZE;
        }
        if ((maxSize = dac.getGetterPoolMaxSize()) < 0) {
            dac.debugWarning("ProviderGetterPool: invalid max size " + maxSize + ", use default: " + DEFAULT_MAX_SIZE);
            maxSize = DEFAULT_MAX_SIZE;
        }
        if ((partitionSize = dac.getGetterPoolPartitionSize()) <= 0) {
            dac.debugWarning("ProviderGetterPool: invalid partition size " + partitionSize + ", use default: " + DEFAULT_PARTITION_SIZE);
            partitionSize = DEFAULT_PARTITION_SIZE;
        }
        getterPool = new ProviderGetterPool(minSize, maxSize, true, partitionSize);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

