/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class DSAMEDPContext
implements DPContext,
DSAMEConstants {
    protected DesktopAppContext desktopAppContext = null;
    protected DSAMEConnection dsameConn = null;

    public void init(HttpServletRequest req) {
        this.desktopAppContext = DesktopAppContextThreadLocalizer.get();
        SSOToken adminSSO = null;
        String bindDN = AdminUtils.getAdminDN();
        String password = new String(AdminUtils.getAdminPassword());
        try {
            SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
            AuthPrincipal ap = new AuthPrincipal(bindDN);
            adminSSO = ssom.createSSOToken((Principal)ap, password);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEDPContext.init(): ", se);
        }
        this.dsameConn = new DSAMEConnection(adminSSO);
    }

    public boolean isValidating() {
        String val = this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDpIsValidating");
        return Boolean.valueOf(val);
    }

    public String getNameSpaceURI() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDpNamespaceURI");
    }

    public short getDebugLevel() {
        return this.desktopAppContext.getDebugLevel();
    }

    public void setDebugLevel(short level) {
        this.desktopAppContext.setDebugLevel(level);
    }

    public boolean isDebugWarningEnabled() {
        return this.desktopAppContext.isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.desktopAppContext.isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        this.desktopAppContext.debugMessage(o);
    }

    public void debugWarning(Object o) {
        this.desktopAppContext.debugWarning(o);
    }

    public void debugError(Object o) {
        this.desktopAppContext.debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        this.desktopAppContext.debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        this.desktopAppContext.debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        this.desktopAppContext.debugError(o, t);
    }

    public boolean isPerfMessageEnabled() {
        return this.desktopAppContext.isDebugMessageEnabled();
    }

    public boolean isPerfWarningEnabled() {
        return this.desktopAppContext.isDebugWarningEnabled();
    }

    public void perfMessage(Object o) {
        this.desktopAppContext.debugMessage(o);
    }

    public void perfWarning(Object o) {
        this.desktopAppContext.debugWarning(o);
    }
}

