/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.PropertiesContext;
import com.sun.portal.desktop.dp.DPBoolean;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPInteger;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.desktop.util.SmartList;
import com.sun.portal.desktop.util.SmartMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class DPPropertiesContext
implements PropertiesContext,
DPTypes {
    private static final String SELECTED = "_selected";
    private static final String AVAILABLE = "_available";
    private static final String CLASSNAME = "_classname";
    private static final String PROVIDERNAME = "_providername";
    private static final Object dpLock = new Object();
    protected Map dpChannels = new HashMap();
    protected Map properties = new HashMap();
    protected Map channelLists = new HashMap();
    protected DPRoot dpRoot = null;

    DPPropertiesContext() {
    }

    public synchronized void init(HttpServletRequest req) {
        this.dpRoot = this.getDesktopContext().getDPRoot();
    }

    public synchronized void refresh() {
        this.dpRoot = this.getDesktopContext().getDPRoot();
        this.dpChannels.clear();
        this.properties.clear();
        this.channelLists.clear();
    }

    protected void cloneIfNecessary() {
        if (!this.getDesktopContext().isDPRootCustomized()) {
            this.getDesktopContext().setDPRootCustomized(true);
            this.refresh();
        }
    }

    public synchronized boolean existsChannel(String channel) {
        DPChannel dpc = this.dpRoot.getChannel(channel);
        return dpc != null;
    }

    public void createChannel(String channelName, String providerName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.createChannel(channelName, providerName);
        }
    }

    public void createContainer(String channelName, String providerName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.createContainerChannel(channelName, providerName);
        }
    }

    public void removeChannel(String channelName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.removeChannel(channelName);
        }
    }

    protected DPChannel getDPChannel(String name) {
        Object object;
        DPChannel dpc = (DPChannel)this.dpChannels.get(name);
        if (dpc == null) {
            object = dpLock;
            synchronized (object) {
                dpc = this.dpRoot.getChannel(name);
            }
        }
        if (dpc != null) {
            object = this;
            synchronized (object) {
                this.dpChannels.put(name, dpc);
            }
        } else {
            throw new ContextError("DPPropertiesContext.getDPChannel(): could not get dp channel=" + name);
        }
        return dpc;
    }

    protected DPContainerChannel getDPContainerChannel(String name) {
        DPChannel dpc = this.getDPChannel(name);
        if (dpc == null) {
            throw new ContextError("DPPropertiesContext.getDPContainerChannel(): could not get dp chanel for name=" + name);
        }
        if (dpc.getType() != 5) {
            throw new ContextError("DPPropertiesContext.getDPContainerChannel(): was not a container name=" + name);
        }
        DPContainerChannel dpcc = (DPContainerChannel)dpc;
        return dpcc;
    }

    protected DesktopContext getDesktopContext() {
        return DesktopContextThreadLocalizer.get();
    }

    public Iterator getNames(String channel) {
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            Iterator i;
            Iterator iterator = i = dpc.getProperties().getNames().iterator();
            return iterator;
        }
    }

    public Map getCollectionProperty(String channel, String key) {
        return this.getCollectionProperty(channel, key, null, false);
    }

    public Map getCollectionProperty(String channel, String key, boolean localized) {
        return this.getCollectionProperty(channel, key, null, localized);
    }

    public Map getCollectionProperty(String channel, String key, Map def) {
        return this.getCollectionProperty(channel, key, def, false);
    }

    public Map getCollectionProperty(String channel, String key, Map def, boolean localized) {
        Map m = this.getCollectionPropertyNE(channel, key, localized);
        if (m == null) {
            if (def == null) {
                throw new ContextError("DPPropertiesContext.getCollectionProperty(): property not found in profile for channel=" + channel + ", key=" + key);
            }
            m = def;
        }
        return m;
    }

    protected Map getCollectionPropertyNE(String channel, String key, boolean localized) {
        SmartMap m = (SmartMap)this.getCachedProperty(channel, key, localized);
        if (m == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Locale locale = null;
            if (localized) {
                locale = this.getDesktopContext().getLocale();
            }
            DPCollection val = null;
            Object object = dpLock;
            synchronized (object) {
                val = dpc.getProperties().getCollection(key, locale, false);
                if (val != null) {
                    Map n = val.getCollectionValue();
                    m = new SmartMap(n);
                }
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, key, localized, m);
            }
        }
        if (m.isCopied()) {
            return m.cloneOriginalMap();
        }
        m.revert();
        return m;
    }

    public void setCollectionProperty(String channel, String key, Map val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setCollection(key, val);
        }
        if (val instanceof SmartMap) {
            Map cached = (Map)this.getCachedProperty(channel, key, false);
            if (cached == val) {
                SmartMap m = (SmartMap)val;
                m.evolve();
            } else {
                SmartMap sm = (SmartMap)val;
                Map m = sm.getMap();
                val = new SmartMap(m);
            }
        } else {
            val = new SmartMap(val);
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.removeCachedProperty(channel, key, false);
            this.putCachedProperty(channel, key, false, val);
        }
    }

    public void setCollectionProperty(String channel, String key, List val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setCollection(key, val);
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.removeCachedProperty(channel, key, false);
        }
    }

    public void setListProperty(String channel, String key, List val) {
        Object object;
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Locale locale = this.getDesktopContext().getLocale();
        try {
            object = dpLock;
            synchronized (object) {
                if (locale.equals(Locale.US)) {
                    dpc.getProperties().setCollection(key, val);
                } else {
                    dpc.getProperties().setCollection(key, val, locale);
                }
            }
        }
        catch (DPError e) {
            dpc.getProperties().setCollection(key, val);
        }
        object = this;
        synchronized (object) {
            if (locale.equals(Locale.US)) {
                this.removeCachedProperty(channel, key, false);
            } else {
                this.removeCachedProperty(channel, key, true);
            }
        }
    }

    public boolean getBooleanProperty(String channel, String key) {
        Boolean b = this.getBooleanPropertyNE(channel, key);
        if (b == null) {
            throw new ContextError("DPPropertiesContext.getBooleanProperty(): property not found in profile for channel=" + channel + ", key=" + key);
        }
        return b;
    }

    public boolean getBooleanProperty(String channel, String key, boolean def) {
        Boolean b = this.getBooleanPropertyNE(channel, key);
        boolean c = b == null ? def : b;
        return c;
    }

    protected Boolean getBooleanPropertyNE(String channel, String key) {
        Boolean b = (Boolean)this.getCachedProperty(channel, key, false);
        if (b == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPBoolean val = dpc.getProperties().getBoolean(key);
                if (val != null) {
                    boolean c = val.getBooleanValue();
                    b = c ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, key, false, b);
            }
        }
        return b;
    }

    public void setBooleanProperty(String channel, String key, boolean val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Boolean b = null;
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setBoolean(key, val);
            b = val ? Boolean.TRUE : Boolean.FALSE;
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.removeCachedProperty(channel, key, false);
            this.putCachedProperty(channel, key, false, b);
        }
    }

    public int getIntegerProperty(String channel, String key) {
        Integer i = this.getIntegerPropertyNE(channel, key);
        if (i == null) {
            throw new ContextError("DPPropertiesContext.getIntegerProperty(): property not found in profile for channel=" + channel + ", key=" + key);
        }
        return i;
    }

    public int getIntegerProperty(String channel, String key, int def) {
        Integer i = this.getIntegerPropertyNE(channel, key);
        int j = i == null ? def : i;
        return j;
    }

    protected Integer getIntegerPropertyNE(String channel, String key) {
        Integer j = (Integer)this.getCachedProperty(channel, key, false);
        if (j == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPInteger val = dpc.getProperties().getInteger(key);
                if (val != null) {
                    j = Integers.get(val.getIntValue());
                }
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, key, false, j);
            }
        }
        return j;
    }

    public void setIntegerProperty(String channel, String key, int val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setInteger(key, val);
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.removeCachedProperty(channel, key, false);
            this.putCachedProperty(channel, key, false, Integers.get(val));
        }
    }

    public String getClassName(String channel) {
        String classname = (String)this.getCachedProperty(channel, CLASSNAME, false);
        if (classname == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPProvider dpp = dpc.getProvider();
                if (dpp == null) {
                    throw new ContextError("DPPropertiesContext.getClassName(): provider was null for channel=" + channel);
                }
                classname = dpp.getClassName();
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, CLASSNAME, false, classname);
            }
        }
        return classname;
    }

    public String getProviderName(String channel) {
        String provider = (String)this.getCachedProperty(channel, PROVIDERNAME, false);
        if (provider == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                provider = dpc.getProviderName();
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, PROVIDERNAME, false, provider);
            }
        }
        return provider;
    }

    public Object getProperty(String channel, String key) {
        return this.getProperty(channel, key, null);
    }

    public Object getProperty(String channel, String key, Object def) {
        Object o = this.getPropertyNE(channel, key);
        if (o == null) {
            if (def == null) {
                throw new ContextError("DPPropertiesContext.getProperty(): property not found in profile for channel=" + channel + ", key=" + key);
            }
            o = def;
        }
        return o;
    }

    protected Object getPropertyNE(String channel, String key) {
        Object o = this.getCachedProperty(channel, key, false);
        if (o == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPProperty val = dpc.getProperties().get(key);
                if (val != null) {
                    o = val.getValue();
                }
            }
            if (o instanceof Map) {
                o = new SmartMap((Map)o);
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, key, false, o);
            }
        }
        if (o instanceof Map) {
            SmartMap sm = (SmartMap)o;
            if (sm.isCopied()) {
                return sm.cloneOriginalMap();
            }
            sm.revert();
        }
        return o;
    }

    public void setProperty(String channel, String key, Object val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().set(key, val, null);
        }
        if (val instanceof Map) {
            if (val instanceof SmartMap) {
                SmartMap m = (SmartMap)val;
                m.evolve();
            } else {
                val = new SmartMap((Map)val);
            }
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.putCachedProperty(channel, key, false, val);
        }
    }

    public String getStringProperty(String channel, String key) {
        return this.getStringProperty(channel, key, null, false);
    }

    public String getStringProperty(String channel, String key, String def) {
        return this.getStringProperty(channel, key, def, false);
    }

    public String getStringProperty(String channel, String key, boolean localized) {
        return this.getStringProperty(channel, key, null, localized);
    }

    public String getStringProperty(String channel, String key, String def, boolean localized) {
        String s = this.getStringPropertyNE(channel, key, localized);
        if (s == null) {
            if (def == null) {
                throw new ContextError("DPPropertiesContext.getStringProperty(): property not found in profile for channel=" + channel + ", key=" + key);
            }
            s = def;
        }
        return s;
    }

    protected String getStringPropertyNE(String channel, String key, boolean localized) {
        String s = (String)this.getCachedProperty(channel, key, localized);
        if (s == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Locale locale = null;
            if (localized) {
                locale = this.getDesktopContext().getLocale();
            }
            Object object = dpLock;
            synchronized (object) {
                DPString val = dpc.getProperties().getString(key, locale, false);
                if (val != null) {
                    s = val.getStringValue();
                }
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedProperty(channel, key, localized, s);
            }
        }
        return s;
    }

    public void setStringProperty(String channel, String key, String val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setString(key, val);
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.removeCachedProperty(channel, key, false);
            this.putCachedProperty(channel, key, false, val);
        }
    }

    public List getSelectedChannels(String container) {
        SmartList sl = (SmartList)this.getCachedChannelList(container, SELECTED);
        if (sl == null) {
            DPContainerChannel dpc = this.getDPContainerChannel(container);
            Object object = dpLock;
            synchronized (object) {
                sl = new SmartList(new ArrayList(dpc.getSelected().getCollectionValue().values()));
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedChannelList(container, SELECTED, sl);
            }
        }
        if (sl.isCopied()) {
            return sl.cloneOriginalList();
        }
        sl.revert();
        return sl;
    }

    public List getAvailableChannels(String container) {
        SmartList sl = (SmartList)this.getCachedChannelList(container, AVAILABLE);
        if (sl == null) {
            DPContainerChannel dpc = this.getDPContainerChannel(container);
            Object object = dpLock;
            synchronized (object) {
                sl = new SmartList(new ArrayList(dpc.getAvailable().getCollectionValue().values()));
            }
            DPPropertiesContext dPPropertiesContext = this;
            synchronized (dPPropertiesContext) {
                this.putCachedChannelList(container, AVAILABLE, sl);
            }
        }
        if (sl.isCopied()) {
            return sl.cloneOriginalList();
        }
        sl.revert();
        return sl;
    }

    public void setSelectedChannels(String container, List sel) {
        this.cloneIfNecessary();
        DPContainerChannel dpc = this.getDPContainerChannel(container);
        Object object = dpLock;
        synchronized (object) {
            dpc.setSelected(sel);
        }
        if (sel instanceof SmartList) {
            List cached = this.getCachedChannelList(container, SELECTED);
            if (cached == sel) {
                SmartList sm = (SmartList)sel;
                sm.evolve();
            } else {
                SmartList sl = (SmartList)sel;
                List l = sl.getList();
                sel = new SmartList(l);
            }
        } else {
            sel = new SmartList(sel);
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.putCachedChannelList(container, SELECTED, sel);
        }
    }

    public void setAvailableChannels(String container, List avail) {
        this.cloneIfNecessary();
        DPContainerChannel dpc = this.getDPContainerChannel(container);
        Object object = dpLock;
        synchronized (object) {
            dpc.setAvailable(avail);
        }
        if (avail instanceof SmartList) {
            List cached = this.getCachedChannelList(container, AVAILABLE);
            if (cached == avail) {
                SmartList sm = (SmartList)avail;
                sm.evolve();
            } else {
                SmartList sl = (SmartList)avail;
                List l = sl.getList();
                avail = new SmartList(l);
            }
        } else {
            avail = new SmartList(avail);
        }
        DPPropertiesContext dPPropertiesContext = this;
        synchronized (dPPropertiesContext) {
            this.putCachedChannelList(container, AVAILABLE, avail);
        }
    }

    public boolean existsStringProperty(String channel, String name) {
        return this.existsStringProperty(channel, name, false);
    }

    public boolean existsStringProperty(String channel, String name, boolean localized) {
        String s = this.getStringPropertyNE(channel, name, localized);
        return s != null;
    }

    public boolean existsBooleanProperty(String channel, String name) {
        Boolean b = this.getBooleanPropertyNE(channel, name);
        return b != null;
    }

    public boolean existsIntegerProperty(String channel, String name) {
        Integer i = this.getIntegerPropertyNE(channel, name);
        return i != null;
    }

    public boolean existsCollectionProperty(String channel, String name) {
        return this.existsCollectionProperty(channel, name, false);
    }

    public boolean existsCollectionProperty(String channel, String name, boolean localized) {
        Map m = this.getCollectionPropertyNE(channel, name, localized);
        return m != null;
    }

    protected void putCachedProperty(String channel, String key, boolean localized, Object o) {
        HashMap<String, Object> perChannel;
        HashMap<String, HashMap<String, Object>> perKey;
        Map perLocale = null;
        perLocale = localized ? (HashMap)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perLocale == null) {
            perLocale = new HashMap();
            if (localized) {
                this.properties.put(Boolean.TRUE, perLocale);
            } else {
                this.properties.put(Boolean.FALSE, perLocale);
            }
        }
        if ((perKey = (HashMap<String, HashMap<String, Object>>)perLocale.get(key)) == null) {
            perKey = new HashMap<String, HashMap<String, Object>>();
            perLocale.put(key, perKey);
        }
        if ((perChannel = (HashMap<String, Object>)perKey.get(channel)) == null) {
            perChannel = new HashMap<String, Object>();
            perKey.put(channel, perChannel);
        }
        perChannel.put(channel, o);
    }

    protected Object removeCachedProperty(String channel, String key, boolean localized) {
        Map perLocale = null;
        perLocale = localized ? (Map)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perLocale == null) {
            return null;
        }
        Map perKey = (Map)perLocale.remove(key);
        if (perKey == null) {
            return null;
        }
        Map perChannel = (Map)perKey.get(channel);
        if (perChannel == null) {
            return null;
        }
        return perChannel.remove(channel);
    }

    protected Object getCachedProperty(String channel, String key, boolean localized) {
        Map perLocale = null;
        perLocale = localized ? (Map)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perLocale == null) {
            return null;
        }
        Map perKey = (Map)perLocale.get(key);
        if (perKey == null) {
            return null;
        }
        Map perChannel = (Map)perKey.get(channel);
        if (perChannel == null) {
            return null;
        }
        return perChannel.get(channel);
    }

    protected boolean existsCachedProperty(String channel, String key, boolean localized) {
        Map perLocale = null;
        perLocale = localized ? (Map)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perLocale == null) {
            return false;
        }
        Map perKey = (Map)perLocale.get(key);
        if (perKey == null) {
            return false;
        }
        Map perChannel = (Map)perKey.get(channel);
        if (perChannel == null) {
            return false;
        }
        return perChannel.containsKey(channel);
    }

    protected void putCachedChannelList(String channel, String type, List l) {
        HashMap<String, List> perChannel;
        HashMap<String, HashMap<String, List>> perType = (HashMap<String, HashMap<String, List>>)this.channelLists.get(type);
        if (perType == null) {
            perType = new HashMap<String, HashMap<String, List>>();
            this.channelLists.put(type, perType);
        }
        if ((perChannel = (HashMap<String, List>)perType.get(channel)) == null) {
            perChannel = new HashMap<String, List>();
            perType.put(channel, perChannel);
        }
        perChannel.put(channel, l);
    }

    protected List getCachedChannelList(String channel, String type) {
        Map perType = (Map)this.channelLists.get(type);
        if (perType == null) {
            return null;
        }
        Map perChannel = (Map)perType.get(channel);
        if (perChannel == null) {
            return null;
        }
        return (List)perChannel.get(channel);
    }
}

