/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassInfoCache {
    private static String baseSearchDir = ClassInfoCache.getSearchBaseDir();
    private static String providerClassBaseDir = null;
    private static ClassInfoCache instance;
    private static Map classInfoMap;
    private static Map jarMap;
    private static long CACHE_VALIDATE_INTERVAL;
    private long lastValidate = 0L;

    private ClassInfoCache() {
    }

    public static ClassInfoCache getInstance(String providerBaseDir) {
        if (providerBaseDir == null) {
            return null;
        }
        if (instance == null) {
            providerClassBaseDir = providerBaseDir;
            instance = new ClassInfoCache();
        }
        return instance;
    }

    public static String getSearchBaseDir() {
        String dir = providerClassBaseDir;
        if (dir == null) {
            String tempString = "/etc/opt/SUNWps/desktop/classes";
            dir = tempString.replace('/', File.separatorChar);
        }
        return dir;
    }

    public File getHandle(String className) {
        File fHandle = null;
        CacheEntry cacheEntry = (CacheEntry)classInfoMap.get(className);
        if (cacheEntry != null) {
            fHandle = cacheEntry.fileHandle;
        }
        return fHandle;
    }

    public long getModifiedTime(String className) {
        long modTime = 0L;
        CacheEntry cacheEntry = (CacheEntry)classInfoMap.get(className);
        if (cacheEntry != null) {
            modTime = cacheEntry.lastModTime;
        }
        return modTime;
    }

    public void setClassInfo(String className, boolean fromJar, File fileHandle) {
        CacheEntry entry = (CacheEntry)classInfoMap.get(className);
        if (entry != null && !entry.fromJar && entry.fileHandle.exists()) {
            return;
        }
        CacheEntry newInfo = new CacheEntry(fromJar, fileHandle);
        Map map = classInfoMap;
        synchronized (map) {
            classInfoMap.put(className, newInfo);
        }
    }

    public void removeClassInfo(String className) {
        Map map = classInfoMap;
        synchronized (map) {
            CacheEntry ce = (CacheEntry)classInfoMap.remove(className);
            if (ce != null && ce.fromJar) {
                Map map2 = jarMap;
                synchronized (map2) {
                    jarMap.remove(ce.fileHandle);
                }
            }
        }
    }

    public File getJarFileHandle(String className) throws IOException {
        File jarFileHandle = null;
        CacheEntry entry = (CacheEntry)classInfoMap.get(className);
        if (entry == null) {
            this.updateCacheWithJars(className);
            entry = (CacheEntry)classInfoMap.get(className);
        }
        if (entry != null && entry.fromJar && entry.fileHandle.canRead()) {
            jarFileHandle = entry.fileHandle;
        }
        return jarFileHandle;
    }

    public void setClassInfoFromJar(File jarFileHandle, Enumeration jarContent) {
        while (jarContent.hasMoreElements()) {
            ZipEntry zEntry = (ZipEntry)jarContent.nextElement();
            String jarEntry = zEntry.getName();
            if (jarEntry == null || !jarEntry.endsWith(".class")) continue;
            String tempStr = jarEntry.substring(0, jarEntry.lastIndexOf(".class"));
            String className = tempStr.replace(File.separatorChar, '.');
            this.setClassInfo(className, true, jarFileHandle);
        }
    }

    private void updateCacheWithJars(String className) throws IOException {
        long validateInterval = System.currentTimeMillis() - this.lastValidate;
        if (validateInterval > CACHE_VALIDATE_INTERVAL) {
            this.validateCache();
            this.lastValidate = System.currentTimeMillis();
        }
        SuffixFilenameFilter sff = new SuffixFilenameFilter(".jar");
        File[] jars = new File(baseSearchDir).listFiles(sff);
        int i = 0;
        while (i < jars.length) {
            File thisJar = jars[i];
            if (thisJar.isFile() && thisJar.canRead()) {
                Long prevJarModTime = (Long)jarMap.get(thisJar);
                long jarLastModTime = thisJar.lastModified();
                if (prevJarModTime == null || jarLastModTime > prevJarModTime) {
                    ZipFile zFile = new ZipFile(thisJar);
                    this.setClassInfoFromJar(thisJar, zFile.entries());
                    zFile.close();
                    Map map = jarMap;
                    synchronized (map) {
                        jarMap.put(thisJar, new Long(jarLastModTime));
                    }
                }
            }
            ++i;
        }
    }

    private void validateCache() {
        HashSet classNameSet = new HashSet(classInfoMap.keySet());
        Iterator it = classNameSet.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            CacheEntry cEntry = (CacheEntry)classInfoMap.get(className);
            if (cEntry.fileHandle.canRead()) continue;
            this.removeClassInfo(className);
            if (!cEntry.fromJar) continue;
            Map map = jarMap;
            synchronized (map) {
                jarMap.remove(cEntry.fileHandle);
            }
        }
    }

    public static String getProviderClasspath() {
        StringBuffer tempPath = new StringBuffer(baseSearchDir);
        SuffixFilenameFilter sff = new SuffixFilenameFilter(".jar");
        File[] jarFiles = new File(baseSearchDir).listFiles(sff);
        if (jarFiles != null && jarFiles.length > 0) {
            int i = 0;
            while (i < jarFiles.length) {
                tempPath.append(File.pathSeparatorChar);
                tempPath.append(jarFiles[i].getPath());
                ++i;
            }
        }
        return tempPath.toString();
    }

    static {
        classInfoMap = new HashMap(100);
        jarMap = new HashMap(5);
        CACHE_VALIDATE_INTERVAL = 1209600000L;
    }

    static class SuffixFilenameFilter
    implements FilenameFilter {
        String suffix;

        SuffixFilenameFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File file, String name) {
            return name.endsWith(this.suffix);
        }
    }

    class CacheEntry {
        private boolean fromJar;
        private File fileHandle;
        private long lastModTime;

        public CacheEntry(boolean isfromJar, File fHandle) {
            this.fromJar = isfromJar;
            this.fileHandle = fHandle;
            this.lastModTime = this.fileHandle != null && this.fileHandle.canRead() ? fHandle.lastModified() : Long.MIN_VALUE;
        }
    }
}

