/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.user.model.UMUserModelImpl;
import com.iplanet.am.console.user.model.UMUserProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DesktopAdminUserProfileModelImpl
extends UMUserProfileModelImpl {
    public DesktopAdminUserProfileModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
        ((AMModelBase)this).resBundle = AMResBundleCacher.getBundle((String)"psDesktopAdmin", (Locale)this.getUserLocale());
    }

    public String getCurrentUserDN() {
        return ((UMUserModelImpl)this).curUser.getDN();
    }

    public void storeAttributes(Map userOnlyAttrs, Map customizedAttrs, Set inheritedAttrs) throws AMConsoleException {
        Set attrValues;
        String attrName;
        ArrayList<String> errorList = null;
        HashMap<String, Set> attrs = new HashMap<String, Set>(userOnlyAttrs.size());
        Set namesSet = userOnlyAttrs.keySet();
        Iterator<Object> iter = namesSet.iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            if (this.isAttrReadOnly(0, attrName) || (attrValues = (Set)userOnlyAttrs.get(attrName)) == null) continue;
            attrs.put(attrName, attrValues);
        }
        try {
            if (!attrs.isEmpty()) {
                this.writeProfile((AMObject)((UMUserModelImpl)this).curUser, attrs, false);
            }
        }
        catch (AMConsoleException ace) {
            errorList = ace.getErrors();
        }
        catch (SSOException ssoe) {
            this.debugWarning("DesktopAdminUserProfileModelImpl.storeAttributes: SSO token invalid.");
            return;
        }
        attrs = new HashMap(customizedAttrs.size());
        namesSet = customizedAttrs.keySet();
        iter = namesSet.iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            if (this.isAttrReadOnly(0, attrName) || (attrValues = (Set)customizedAttrs.get(attrName)) == null) continue;
            attrs.put(attrName, attrValues);
        }
        try {
            if (!attrs.isEmpty()) {
                this.writeProfile((AMObject)((UMUserModelImpl)this).curUser, attrs, true);
            }
        }
        catch (AMConsoleException ace) {
            errorList = ace.getErrors();
        }
        catch (SSOException ssoe) {
            this.debugWarning("DesktopAdminUserProfileModelImpl.storeAttributes: SSO token invalid.");
            return;
        }
        if (!inheritedAttrs.isEmpty()) {
            if (errorList == null) {
                errorList = new ArrayList<String>(inheritedAttrs.size());
            }
            HashSet<String> attr = new HashSet<String>(1);
            iter = inheritedAttrs.iterator();
            while (iter.hasNext()) {
                Object var13_15;
                String name = (String)iter.next();
                attr.add(name);
                try {
                    try {
                        ((UMUserModelImpl)this).curUser.removeAttributes(attr);
                        ((AMModelBase)this).logger.doLog("attribute.remove", name);
                    }
                    catch (AMException ame) {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("error removing attribute " + name, (Throwable)ame);
                        }
                        errorList.add(name + "-" + ame.getMessage());
                        var13_15 = null;
                        attr.clear();
                        continue;
                    }
                    catch (SSOException ssoe) {
                        this.debugWarning("DesktopAdminUserProfileModelImpl.storeAttributes: SSO token invalid.");
                        var13_15 = null;
                        attr.clear();
                        return;
                    }
                    var13_15 = null;
                    attr.clear();
                }
                catch (Throwable throwable) {
                    var13_15 = null;
                    attr.clear();
                    throw throwable;
                }
            }
        }
        if (errorList != null && !errorList.isEmpty()) {
            throw new AMConsoleException(errorList);
        }
    }

    public boolean canViewDTAttributes() {
        boolean canView = true;
        try {
            Iterator ri = ((AMModelBase)this).dpUser.getRoleDNs().iterator();
            while (ri.hasNext() && canView) {
                String value;
                AMTemplate amTemplate;
                AMRole amRole = ((AMModelBase)this).dpStoreConn.getRole((String)ri.next());
                if (amRole == null || !amRole.isExists()) continue;
                if (AMModelBase.debug.messageEnabled()) {
                    this.debugMessage("RoleDN= " + amRole.getDN());
                }
                if ((amTemplate = amRole.getTemplate("SunPortalDesktopService", 301)) == null || !amTemplate.isExists() || (value = amTemplate.getStringAttribute("sunPortalDesktopDpCanView")).length() <= 0) continue;
                canView = Boolean.valueOf(value);
            }
        }
        catch (AMException dpe) {
            this.debugMessage("Error in getting template for a role", (Exception)((Object)dpe));
        }
        catch (SSOException ssoe) {
            this.debugWarning("SSOException in getting template for a role", (Exception)((Object)ssoe));
            canView = false;
        }
        return canView;
    }
}

