/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.jato.util.Encoder;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.admin.model.EditDisplayProfileModel;
import com.sun.portal.desktop.admin.model.EditDisplayProfileModelImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DPServlet
extends HttpServlet {
    private static final String DPSERVLET_SESSION_ATTR = "ps-admin-session-attrs";
    private static final String TOKEN_DELIMITER = "\u0c20";
    private static String serverURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
    private static String consoleURI = SystemProperties.get((String)"com.iplanet.am.console.deploymentDescriptor");
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static int TYPE_ERROR = 0;
    private static int TYPE_WARNING = 1;
    private static int TYPE_INFORMATION = 2;
    private SSOToken ssoToken;
    private String psDeployURI;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqURI = req.getRequestURI();
        this.psDeployURI = reqURI.substring(0, reqURI.indexOf(47, 1));
        ServletConfigThreadLocalizer.set(this.getServletConfig());
        try {
            this.ssoToken = this.checkAuthentication(req);
        }
        catch (SSOException soe) {
            String redirectURL = serverURI + "/login" + "?module=dproadmin&goto=" + consoleURI + "/base/AMAdminFrame";
            try {
                resp.sendRedirect(redirectURL);
            }
            catch (IOException ioe) {
                throw new ServletException("Cannot redirect to " + redirectURL);
            }
        }
        super.service(req, resp);
    }

    private SSOToken checkAuthentication(HttpServletRequest request) throws SSOException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        SSOTokenManager.getInstance().validateToken(ssoToken);
        return ssoToken;
    }

    protected String getDelimitedValue(List values) {
        StringBuffer sb = new StringBuffer();
        if (values != null && values.size() > 0) {
            int i = 0;
            while (i < values.size()) {
                sb.append((String)values.get(i));
                if (i < values.size() - 1) {
                    sb.append(TOKEN_DELIMITER);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    protected List getUnDelimitedValue(String value) {
        StringTokenizer st = new StringTokenizer(value, TOKEN_DELIMITER);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result.add(token);
        }
        return result;
    }

    public void storeToSession(String name, List values) {
        String delimitedValue = null;
        if (name != null && !name.equals("") && values != null) {
            delimitedValue = this.getDelimitedValue(values);
        }
        try {
            this.ssoToken.setProperty(name, delimitedValue);
        }
        catch (SSOException ssoe) {
            debug.error("DPServlet.storeToSession() ", (Throwable)ssoe);
        }
    }

    public List getFromSession(String name) {
        String delimitedValue = null;
        try {
            delimitedValue = this.ssoToken.getProperty(name);
        }
        catch (SSOException ssoe) {
            debug.error("DPServlet.getFromSession() ", (Throwable)ssoe);
        }
        return this.getUnDelimitedValue(delimitedValue);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = request.getParameter("gx_charset");
        String ServiceName = request.getParameter("ServiceName");
        String Location2 = request.getParameter("Location");
        String Template = request.getParameter("Template");
        String SchemaType2 = request.getParameter("SchemaType");
        String action = request.getParameter("action");
        String userDN = request.getParameter("userDN");
        if (encoding == null || ServiceName == null || Location2 == null || Template == null || SchemaType2 == null) {
            debug.error("DPServlet.doGet Illegal Parameters");
            response.sendError(500);
        }
        ServiceName = new String(Encoder.decode((String)ServiceName), encoding);
        Location2 = new String(Encoder.decode((String)Location2), encoding);
        if (userDN != null && userDN.length() != 0) {
            userDN = new String(Encoder.decode((String)userDN), encoding);
        }
        HashMap<String, String> mp = new HashMap<String, String>(5);
        mp.put("gx_charset", encoding);
        mp.put("com.iplanet.am.console.service.svcName", ServiceName);
        mp.put("com-iplanet-am-console-location-dn", Location2);
        mp.put("com.iplanet.am.console.service.templateLevel", Template);
        mp.put("schemaType", SchemaType2);
        ArrayList<String> lst = new ArrayList<String>(6);
        lst.add(encoding);
        lst.add(ServiceName);
        lst.add(Location2);
        lst.add(Template);
        lst.add(SchemaType2);
        lst.add(userDN);
        this.storeToSession(DPSERVLET_SESSION_ATTR, lst);
        try {
            EditDisplayProfileModelImpl model = new EditDisplayProfileModelImpl(request, "psDesktopAdmin", mp);
            if (userDN != null && userDN.length() != 0) {
                model.setCurrentUser(userDN);
            }
            if (action != null && action.equalsIgnoreCase("getDP")) {
                response.setContentType("application/x-xxxxx; charset=" + encoding);
                response.setHeader("Content-Disposition", "filename=\"DisplayProfileXML\"");
                PrintWriter out = response.getWriter();
                out = response.getWriter();
                String dpXML = model.getDisplayProfile();
                if (dpXML == null || dpXML.length() < 1) {
                    dpXML = "\n";
                }
                out.write(dpXML);
                out.close();
            } else {
                response.setContentType("text/html;charset=" + encoding);
                request.setAttribute("pageTitle", (Object)model.getLocalizedString("datapage.title"));
                request.setAttribute("desktopLabel", (Object)model.getLocalizedString("popup.label.desktop"));
                request.setAttribute("dpLabel", (Object)model.getLocalizedString("popup.label.displayProfile"));
                request.setAttribute("selectFileLabel", (Object)model.getLocalizedString("popup.label.selectFile"));
                request.setAttribute("uploadLabel", (Object)model.getLocalizedString("popup.button.upload"));
                request.setAttribute("closeLabel", (Object)model.getLocalizedString("popup.button.close"));
                request.setAttribute("psDeployURI", (Object)this.psDeployURI);
                RequestDispatcher rd = request.getRequestDispatcher("/ps/dtadmin/UploadDP.jsp");
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            debug.error("DPServlet.doPost :: Illegal form encoding type");
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        List sessionVals = this.getFromSession(DPSERVLET_SESSION_ATTR);
        String encoding = (String)sessionVals.get(0);
        HashMap<String, String> mp = new HashMap<String, String>(5);
        mp.put("gx_charset", encoding);
        mp.put("com.iplanet.am.console.service.svcName", (String)sessionVals.get(1));
        mp.put("com-iplanet-am-console-location-dn", (String)sessionVals.get(2));
        mp.put("com.iplanet.am.console.service.templateLevel", (String)sessionVals.get(3));
        mp.put("schemaType", (String)sessionVals.get(4));
        String userDN = (String)sessionVals.get(5);
        EditDisplayProfileModelImpl model = null;
        try {
            model = new EditDisplayProfileModelImpl(req, "psDesktopAdmin", mp);
            if (userDN != null && userDN.length() != 0) {
                model.setCurrentUser(userDN);
            }
        }
        catch (Exception e) {
            debug.error("DPServlet.doPost :: Unable to instantiate EditDisplayProfileModel");
            response.sendError(500);
        }
        response.setContentType("text/html;charset=" + encoding);
        PrintWriter out = response.getWriter();
        Hashtable postArgs = null;
        String msgMarkup = "";
        try {
            if (req.getContentType().toLowerCase().startsWith("multipart/form-data")) {
                postArgs = this.parseMultiPartFormData(req.getContentType(), req.getContentLength(), req.getInputStream());
                UploadedFile uf = (UploadedFile)postArgs.get("files");
                if (uf != null && uf.filename != null && uf.filename.length() > 0 && uf.content.length > 0) {
                    model.setDisplayProfile(uf.content);
                    msgMarkup = this.showMessage(TYPE_INFORMATION, model.getLocalizedString("popup.uploadsuccess.title"), "", model);
                } else {
                    msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), model.getLocalizedString("popup.nocontent.msg"), model);
                }
            } else {
                debug.error("DPServlet.doPost :: Illegal form encoding type");
                msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), "", model);
            }
        }
        catch (AMConsoleException ce) {
            List list = ce.getErrors();
            String title = (String)list.get(0);
            String msg = (String)list.get(1);
            msgMarkup = this.showMessage(TYPE_ERROR, title, msg, model);
        }
        catch (Exception e) {
            debug.error("DPServlet.doPost ::", (Throwable)e);
            msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), "", model);
        }
        out.write(msgMarkup);
        out.close();
    }

    /*
     * Unable to fully structure code
     */
    public Hashtable parseMultiPartFormData(String reqContentType, int len, ServletInputStream in) throws IOException, ServletException {
        ind = reqContentType.indexOf("boundary=");
        boundary = null;
        if (ind == -1 || (boundary = reqContentType.substring(ind + 9)) == null) {
            throw new ServletException("Missing or invalid boundary parameter in content type");
        }
        buffSize = 8192;
        hash = new Hashtable<String, Object>();
        boundaryStr = "--" + boundary;
        boundaryBuf = ("\r\n" + boundaryStr).getBytes();
        b = new byte[buffSize];
        result = in.readLine(b, 0, b.length);
        if (result == -1) {
            throw new IllegalArgumentException("InputStream truncated");
        }
        len -= result;
        line = new String(b, 0, result, "ISO-8859-1");
        if (line.startsWith(boundaryStr)) ** GOTO lbl126
        throw new IllegalArgumentException("MIME boundary missing: " + line);
lbl-1000:
        // 1 sources

        {
            filename = null;
            contentType = null;
            content = new ByteArrayOutputStream();
            name = null;
            result = in.readLine(b, 0, b.length);
            if (result == -1) {
                return hash;
            }
            len -= result;
            line = new String(b, 0, result - 2, "ISO-8859-1");
            lowerline = line.toLowerCase();
            if (!lowerline.startsWith("content-disposition")) continue;
            ind = lowerline.indexOf("content-disposition: ");
            ind2 = lowerline.indexOf(";");
            if (ind == -1 || ind2 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            disposition = lowerline.substring(ind + 21, ind2);
            if (!disposition.equals("form-data")) {
                throw new IllegalArgumentException("Content Disposition of " + disposition + " is not supported");
            }
            ind3 = lowerline.indexOf("name=\"", ind2);
            ind4 = lowerline.indexOf("\"", ind3 + 7);
            if (ind3 == -1 || ind4 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            name = line.substring(ind3 + 6, ind4);
            ind5 = lowerline.indexOf("filename=\"", ind4 + 2);
            ind6 = lowerline.indexOf("\"", ind5 + 10);
            if (ind5 != -1 && ind6 != -1) {
                filename = line.substring(ind5 + 10, ind6);
            }
            if ((result = in.readLine(b, 0, b.length)) == -1) {
                return hash;
            }
            len -= result;
            line = new String(b, 0, result - 2, "ISO-8859-1");
            lowerline = line.toLowerCase();
            if (lowerline.startsWith("content-type")) {
                ind7 = lowerline.indexOf(" ");
                if (ind7 == -1) {
                    throw new IllegalArgumentException("Content-Type line misformatted: " + line);
                }
                contentType = lowerline.substring(ind7 + 1);
                result = in.readLine(b, 0, b.length);
                if (result == -1) {
                    return hash;
                }
                len -= result;
                line = new String(b, 0, result - 2, "ISO-8859-1");
                if (line.length() != 0) {
                    throw new IllegalArgumentException("Unexpected line in MIMEpart header: " + line);
                }
            } else if (line.length() != 0) {
                throw new IllegalArgumentException("Misformatted line following disposition: " + line);
            }
            readingContent = true;
            buf = new byte[boundaryBuf.length];
            c = new byte[1];
            result = in.read(c);
            while (readingContent) {
                if (result == -1) {
                    return hash;
                }
                len -= result;
                if (c[0] == 13) {
                    buf[0] = c[0];
                    i = 1;
                    while (i < boundaryBuf.length && (result = in.read(c)) != -1 && c[0] == boundaryBuf[i]) {
                        buf[i] = c[0];
                        len -= result;
                        ++i;
                    }
                    if (i == boundaryBuf.length) {
                        readingContent = false;
                        in.read(c);
                        if (c[0] == 45) {
                            in.read(c);
                            in.read(c);
                            len -= 2;
                        }
                        in.read(c);
                        len -= 2;
                        continue;
                    }
                    if (result == -1) {
                        return hash;
                    }
                    content.write(buf, 0, i);
                    continue;
                }
                content.write(c);
                result = in.read(c);
            }
            if (filename == null) {
                if (hash.get(name) == null) {
                    values = new String[]{content.toString("UTF-8")};
                    hash.put(name, values);
                    continue;
                }
                prevobj = hash.get(name);
                if (prevobj instanceof String[]) {
                    prev = (String[])prevobj;
                    newStr = new String[prev.length + 1];
                    System.arraycopy(prev, 0, newStr, 0, prev.length);
                    newStr[prev.length] = content.toString("UTF-8");
                    hash.put(name, newStr);
                    continue;
                }
                throw new IllegalArgumentException("failure in parseMulti hashtable building code");
            }
            uf = new UploadedFile();
            uf.name = name;
            uf.filename = filename;
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            uf.contentType = contentType;
            uf.content = content.toByteArray();
            hash.put(name, uf);
lbl126:
            // 5 sources

            ** while (len > 0)
        }
lbl127:
        // 1 sources

        return hash;
    }

    private String showMessage(int type, String title, String message, EditDisplayProfileModel model) {
        StringBuffer buffer = new StringBuffer();
        String cssURI = this.psDeployURI + "/console/css";
        String imageURI = this.psDeployURI + "/console/images";
        String backLabel = model.getLocalizedString("popup.button.back");
        String closeLabel = model.getLocalizedString("popup.button.close");
        buffer.append("\n<html>").append("\n<head>").append("\n<link rel=\"stylesheet\" href=\"" + cssURI + "/adminstyle.css\">").append("\n</head>").append("\n<body>").append("\n<table align=center border=\"0\" cellspacing=\"0\" ").append("cellpadding=\"10\">").append("\n<tr>\n<td>").append("\n<table border=\"0\" cellspacing=\"0\" ").append("cellpadding=\"2\" ").append("class=\"").append(this.getBorderStyle(type)).append("\"").append(">").append("\n<tr>").append("\n<td>").append("\n<table cellspacing=\"0\" cellpadding=\"5\" ").append("border=\"0\" class=\"").append(this.getContentStyle(type)).append("\">").append("\n<tr>").append("\n<td valign=\"top\"><img src=\"").append(this.getTypeIcon(type, imageURI)).append("\" width=\"32\" height=\"32\" border=\"0\">").append("\n</td>").append("\n<td>").append("\n<div class=\"alert-header-text\"><b>").append(title).append("</b></div>").append("\n<div class=\"alert-normal-text\">").append(message).append("</div>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n<table align=center border=0 cellpadding=5 cellspacing=2>").append("\n<tr>").append("\n<td align=right>").append("\n<table border=0 cellpadding=1 cellspacing=0 class=\"button-frame-enabled\">").append("\n<tr><td>").append("\n<table border=0 cellpadding=0 cellspacing=0 width=\"100%\" class=\"button-content-enabled\">").append("\n<tr>").append("\n<td align=\"center\" nowrap>").append("\n<a href=\"javascript:window.history.back()\" class=\"button-link\">").append("\n<span class=\"button-link-enabled-text\">").append(backLabel).append("\n</span>").append("\n</a></td></tr>").append("\n</table>").append("\n</td></tr>").append("\n</table>").append("\n</td>").append("\n<td align=left>").append("\n<table border=0 cellpadding=1 cellspacing=0 class=\"button-frame-enabled\">").append("\n<tr><td>").append("\n<table border=0 cellpadding=0 cellspacing=0 width=\"100%\" class=\"button-content-enabled\">").append("\n<tr>").append("\n<td align=\"center\" nowrap>").append("\n<a href=\"javascript:window.close()\" class=\"button-link\">").append("\n<span class=\"button-link-enabled-text\">").append(closeLabel).append("\n</span>").append("\n</a></td></tr>").append("\n</table>").append("\n</td></tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</body>").append("\n</html>");
        return buffer.toString();
    }

    protected String getTypeIcon(int type, String URI2) {
        String image = null;
        image = type == TYPE_WARNING ? URI2 + "/warning_32_sunplex.gif" : (type == TYPE_INFORMATION ? URI2 + "/info_32_sunplex.gif" : URI2 + "/error_32_sunplex.gif");
        return image;
    }

    protected String getContentStyle(int type) {
        String style = null;
        style = type == TYPE_WARNING ? "alert-warning-content" : (type == TYPE_INFORMATION ? "alert-info-content" : "alert-error-content");
        return style;
    }

    protected String getBorderStyle(int type) {
        String style = null;
        style = type == TYPE_WARNING ? "alert-warning-frame" : (type == TYPE_INFORMATION ? "alert-info-frame" : "alert-error-frame");
        return style;
    }

    class UploadedFile {
        public String name;
        public String filename;
        public String contentType;
        public byte[] content;

        UploadedFile() {
        }
    }
}

