/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop;

import com.sun.portal.desktop.util.I18n;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class DesktopRequest
implements HttpServletRequest {
    private HttpServletRequest req;
    private Hashtable queryParamTable = null;
    private Hashtable formParamTable = null;
    private String queryString = null;

    public DesktopRequest(HttpServletRequest request, boolean readFromParameters) {
        this.req = request;
        this.parseParameters(request, readFromParameters);
    }

    protected void parseParameters(HttpServletRequest req, boolean readFromParameters) {
        if (readFromParameters) {
            if (req.getParameterNames().hasMoreElements()) {
                this.queryParamTable = new Hashtable();
            }
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] val = new String[]{req.getParameter(name)};
                this.queryParamTable.put(name, val);
            }
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            ServletInputStream is = null;
            try {
                is = req.getInputStream();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.formParamTable = HttpUtils.parsePostData((int)req.getContentLength(), (ServletInputStream)is);
        } else if (req.getMethod().equalsIgnoreCase("GET")) {
            String query = req.getQueryString();
            if (query == null) {
                query = "";
            }
            this.queryParamTable = HttpUtils.parseQueryString((String)query);
        }
    }

    private Hashtable mergeParams(Map target, Map source) {
        Hashtable<String, String[]> result = null;
        if (target != null) {
            result = new Hashtable<String, String[]>(target);
        }
        if (target != null && source != null) {
            Set srcEntry = source.entrySet();
            Iterator i = srcEntry.iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String fromKey = (String)me.getKey();
                if (fromKey == null || fromKey.length() == 0) continue;
                String[] fromVal = (String[])me.getValue();
                String[] toVal = (String[])target.get(fromKey);
                if (toVal != null && toVal.length > 0) {
                    if (fromVal == null || fromVal.length <= 0) continue;
                    int len = toVal.length + fromVal.length;
                    String[] newval = new String[len];
                    System.arraycopy(toVal, 0, newval, 0, toVal.length);
                    System.arraycopy(fromVal, 0, newval, toVal.length, fromVal.length);
                    result.put(fromKey, newval);
                    continue;
                }
                result.put(fromKey, fromVal);
            }
        } else if (source != null) {
            result = new Hashtable(source);
        }
        if (result == null) {
            result = new Hashtable();
        }
        return result;
    }

    public void decodeParams(String charset) {
        if (this.formParamTable != null) {
            Enumeration e = this.formParamTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object o = this.formParamTable.get(key);
                if (!(o instanceof String[])) continue;
                String[] vals = (String[])o;
                int j = 0;
                while (j < vals.length) {
                    vals[j] = I18n.decodeCharset(vals[j], charset);
                    ++j;
                }
            }
        }
    }

    public Hashtable getParameterMap() {
        Hashtable paramTable = this.mergeParams(this.queryParamTable, this.formParamTable);
        return paramTable;
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException("Request input is not available to providers");
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    public String getParameter(String name) {
        String[] values = null;
        if (this.queryParamTable != null) {
            values = (String[])this.queryParamTable.get(name);
        }
        if (values != null && values.length >= 1) {
            return values[0];
        }
        if (this.formParamTable != null) {
            values = (String[])this.formParamTable.get(name);
        }
        if (values != null && values.length >= 1) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        Hashtable parameterTable = this.mergeParams(this.queryParamTable, this.formParamTable);
        return parameterTable.keys();
    }

    public String[] getParameterValues(String name) {
        String[] values = null;
        if (this.queryParamTable != null) {
            values = (String[])this.queryParamTable.get(name);
        }
        if (values != null && values.length >= 1) {
            return values;
        }
        if (this.formParamTable != null) {
            values = (String[])this.formParamTable.get(name);
        }
        return values;
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException("Request input is not available to providers");
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("getRealPath is deprecated");
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("RequestDispatcher is not available to providers");
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }
}

