/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.transport;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class NetFileSession
implements Serializable {
    private final Hashtable nfSessionParams;
    private final HashMap i18nBucket;
    private final HashMap encodingList;
    private final String sessionId;

    public HashMap getEncodingList() {
        return this.encodingList;
    }

    public String getSessionID() {
        return this.sessionId;
    }

    public NetFileSession(String sessionId, HashMap i18nBucket, Hashtable sessionParams) {
        this.sessionId = sessionId;
        this.i18nBucket = i18nBucket;
        this.nfSessionParams = sessionParams;
        this.encodingList = this.extractEncodingList(i18nBucket);
    }

    public String getI18nBucketVal(String key) {
        return (String)this.i18nBucket.get(key);
    }

    public Object getSessionParam(Object key) {
        return this.nfSessionParams.get(key);
    }

    private HashMap extractEncodingList(HashMap i18nBucket) {
        Set keys = i18nBucket.keySet();
        HashMap<String, String> encodingMap = new HashMap<String, String>(keys.size());
        Iterator keyIt = keys.iterator();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            if (!key.startsWith("encoding_")) continue;
            String value = (String)i18nBucket.get(key);
            encodingMap.put(key.substring("encoding_".length()), value);
        }
        return encodingMap;
    }
}

