/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.i18n.StringManager;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private boolean connectionPoolDebug;
    private static Log _logger = LogFactory.getLog((String)"javax.enterprise.resource.javamail");
    private static StringManager localStrings = StringManager.getManager("com.sun.mail");
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(String string, char c, IMAPStore iMAPStore) {
        super(iMAPStore);
        this.fullName = string;
        this.separator = c;
        this.messageCacheLock = new Object();
        this.debug = iMAPStore.getSession().getDebug();
        this.connectionPoolDebug = iMAPStore.getConnectionPoolDebug();
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(int n) throws MessagingException {
        if (n < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (n > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        block2: {
            if (this.name != null) break block2;
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {}
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c = this.getSeparator0();
        int n = this.fullName.lastIndexOf(c);
        if (n != -1) {
            return new IMAPFolder(this.fullName.substring(0, n), c, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = iMAPProtocol.list("", this.fullName);
                }
                Object var6_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var6_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray != null) {
            this.fullName = listInfoArray[0].name;
            this.separator = listInfoArray[0].separator;
            if (listInfoArray[0].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Folder[] doList(String string, boolean bl) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        char c = this.getSeparator0();
        try {
            Object var10_12;
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = bl ? iMAPProtocol.lsub("", this.fullName + c + string) : iMAPProtocol.list("", this.fullName + c + string);
                }
                var10_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                var10_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                var10_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n = 0;
        if (listInfoArray[0].name.equals(this.fullName + c)) {
            n = 1;
        }
        Folder[] folderArray = new IMAPFolder[listInfoArray.length - n];
        int n2 = n;
        while (n2 < listInfoArray.length) {
            folderArray[n2 - n] = new IMAPFolder(listInfoArray[n2], (IMAPStore)this.store);
            ++n2;
        }
        return folderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    Object object = this.lockFor(iMAPProtocol);
                    synchronized (object) {
                        listInfoArray = iMAPProtocol.isREV1() ? iMAPProtocol.list(this.fullName, "") : iMAPProtocol.list("", this.fullName);
                    }
                    Object var6_7 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(iMAPProtocol, connectionException);
                    Object var6_8 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = iMAPProtocol.lsub("", this.fullName);
                }
                Object var6_6 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                Object var6_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return listInfoArray != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribed(boolean bl) throws MessagingException {
        this.checkExists();
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    if (bl) {
                        iMAPProtocol.subscribe(this.fullName);
                    } else {
                        iMAPProtocol.unsubscribe(this.fullName);
                    }
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean create(int n) throws MessagingException {
        block11: {
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    Object object = this.lockFor(iMAPProtocol);
                    synchronized (object) {
                        if ((n & 1) == 0) {
                            iMAPProtocol.create(this.fullName + this.getSeparator0());
                        } else {
                            ListInfo[] listInfoArray;
                            iMAPProtocol.create(this.fullName);
                            if ((n & 2) != 0 && (listInfoArray = iMAPProtocol.list("", this.fullName)) != null && !listInfoArray[0].hasInferiors) {
                                iMAPProtocol.delete(this.fullName);
                                throw new MessagingException("Unsupported type");
                            }
                        }
                    }
                }
                catch (CommandFailedException commandFailedException) {
                    boolean bl = false;
                    Object var7_9 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    return bl;
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(iMAPProtocol, connectionException);
                    Object var7_10 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    break block11;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        this.exists = true;
        this.type = n;
        this.notifyFolderListeners(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        boolean bl;
        IMAPProtocol iMAPProtocol;
        block23: {
            boolean bl2;
            block22: {
                boolean bl3;
                block21: {
                    this.checkExists();
                    if (this.opened) {
                        Object object = this.messageCacheLock;
                        synchronized (object) {
                            try {
                                this.keepConnectionAlive(true);
                            }
                            catch (ConnectionException connectionException) {
                                throw new FolderClosedException(this, connectionException.getMessage());
                            }
                            catch (ProtocolException protocolException) {
                                throw new MessagingException(protocolException.getMessage(), protocolException);
                            }
                        }
                        if (this.recent <= 0) return false;
                        return true;
                    }
                    iMAPProtocol = null;
                    try {
                        try {
                            iMAPProtocol = this.getStoreProtocol();
                            Object object = this.lockFor(iMAPProtocol);
                            synchronized (object) {
                                ListInfo[] listInfoArray = iMAPProtocol.list("", this.fullName);
                                if (listInfoArray != null) {
                                    if (listInfoArray[0].changeState == 1) {
                                        boolean bl4 = true;
                                        // MONITOREXIT @DISABLED, blocks:[16, 2, 3, 19, 9] lbl25 : MonitorExitStatement: MONITOREXIT : var2_4
                                        Object var9_13 = null;
                                        this.releaseStoreProtocol(iMAPProtocol);
                                        return bl4;
                                    }
                                    if (listInfoArray[0].changeState == 2) {
                                        bl3 = false;
                                        // MONITOREXIT @DISABLED, blocks:[2, 18, 3, 19, 9] lbl32 : MonitorExitStatement: MONITOREXIT : var2_4
                                        break block21;
                                    }
                                }
                                Status status = this.getStatus();
                                if (status.recent > 0) {
                                    bl2 = true;
                                    // MONITOREXIT @DISABLED, blocks:[17, 2, 3, 9] lbl38 : MonitorExitStatement: MONITOREXIT : var2_4
                                    break block22;
                                }
                                bl = false;
                            }
                            break block23;
                        }
                        catch (BadCommandException badCommandException) {
                            boolean bl5 = false;
                            Object var9_17 = null;
                            this.releaseStoreProtocol(iMAPProtocol);
                            return bl5;
                        }
                        catch (ConnectionException connectionException) {
                            throw new StoreClosedException(this.store, connectionException.getMessage());
                        }
                        catch (ProtocolException protocolException) {
                            throw new MessagingException(protocolException.getMessage(), protocolException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_18 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        throw throwable;
                    }
                }
                Object var9_14 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl3;
            }
            Object var9_15 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return bl2;
        }
        Object var9_16 = null;
        this.releaseStoreProtocol(iMAPProtocol);
        return bl;
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c = this.getSeparator0();
        return new IMAPFolder(this.fullName + c + string, c, (IMAPStore)this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean delete(boolean bl) throws MessagingException {
        Object object;
        this.checkClosed();
        if (bl) {
            object = this.list();
            int n = 0;
            while (n < ((Folder[])object).length) {
                object[n].delete(bl);
                ++n;
            }
        }
        object = null;
        try {
            try {
                object = this.getStoreProtocol();
                Object object2 = this.lockFor((IMAPProtocol)object);
                synchronized (object2) {
                    ((IMAPProtocol)object).delete(this.fullName);
                }
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl2 = false;
                Object var7_7 = null;
                this.releaseStoreProtocol((IMAPProtocol)object);
                return bl2;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            Object var7_6 = null;
            this.releaseStoreProtocol((IMAPProtocol)object);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseStoreProtocol((IMAPProtocol)object);
            throw throwable;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean renameTo(Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.rename(this.fullName, folder.getFullName());
                }
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl = false;
                Object var7_6 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            Object var7_5 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(int n) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                mailboxInfo = n == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (ProtocolException protocolException) {
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException2) {
                    // empty catch block
                }
                this.protocol = null;
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (mailboxInfo.mode != n) {
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
                this.protocol = null;
                throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.protocol.addResponseHandler(this);
            this.messageCache = new Vector(this.total);
            int n2 = 0;
            while (n2 < this.total) {
                this.messageCache.addElement(new IMAPMessage(this, n2 + 1, n2 + 1));
                ++n2;
            }
        }
        this.notifyConnectionListeners(1);
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.storeFlags(Utility.toMessageSet(messageArray, null), flags, bl);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean bl) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (!this.opened && this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            this.reallyClosed = true;
            if (!this.opened) {
                return;
            }
            try {
                block15: {
                    try {
                        if (((IMAPStore)this.store).isConnectionPoolFull()) {
                            if (this.debug && _logger.isDebugEnabled()) {
                                String string = localStrings.getString("java_mail.connection_pool_full");
                                _logger.debug((Object)string);
                            }
                            if (bl) {
                                this.protocol.close();
                            }
                            this.protocol.logout();
                            break block15;
                        }
                        if (!bl) {
                            try {
                                MailboxInfo mailboxInfo = this.protocol.examine(this.fullName);
                            }
                            catch (ProtocolException protocolException) {
                                this.protocol.disconnect();
                            }
                        }
                        this.protocol.close();
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                Object var5_7 = null;
                this.cleanup(true);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.cleanup(true);
                throw throwable;
            }
        }
    }

    private void cleanup(boolean bl) {
        this.releaseProtocol(bl);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        int n;
                        iMAPProtocol = this.getStoreProtocol();
                        Object object = this.lockFor(iMAPProtocol);
                        synchronized (object) {
                            MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                            iMAPProtocol.close();
                            n = mailboxInfo.total;
                        }
                        Object var8_13 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        int n;
                        iMAPProtocol = this.getStoreProtocol();
                        Object object = this.lockFor(iMAPProtocol);
                        synchronized (object) {
                            MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                            iMAPProtocol.close();
                            n = mailboxInfo.recent;
                        }
                        Object var8_13 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, false));
                return nArray.length;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status getStatus() throws ProtocolException {
        int n = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            Status status;
            iMAPProtocol = this.getStoreProtocol();
            Object object = this.lockFor(iMAPProtocol);
            synchronized (object) {
                Status status2 = iMAPProtocol.status(this.fullName, null);
                if (n > 0) {
                    this.cachedStatus = status2;
                    this.cachedStatusTime = System.currentTimeMillis();
                }
                status = status2;
            }
            Object var8_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return status;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized Message getMessage(int n) throws MessagingException {
        this.checkOpened();
        this.checkRange(n);
        return (Message)this.messageCache.elementAt(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessages(Message[] messageArray) throws MessagingException {
        block17: {
            this.checkExists();
            int n = ((IMAPStore)this.store).getAppendBufferSize();
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    int n2 = 0;
                    while (n2 < messageArray.length) {
                        block16: {
                            MessageLiteral messageLiteral;
                            Message message = messageArray[n2];
                            try {
                                messageLiteral = new MessageLiteral(message, message.getSize() > n ? 0 : n);
                            }
                            catch (IOException iOException) {
                                throw new MessagingException("IOException while appending messages", iOException);
                            }
                            catch (MessageRemovedException messageRemovedException) {
                                break block16;
                            }
                            Object object = this.messageCacheLock;
                            synchronized (object) {
                                Object object2 = this.lockFor(iMAPProtocol);
                                synchronized (object2) {
                                    Date date = message.getReceivedDate();
                                    if (date == null) {
                                        date = message.getSentDate();
                                    }
                                    iMAPProtocol.append(this.fullName, message.getFlags(), date, messageLiteral);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(iMAPProtocol, connectionException);
                    Object var13_17 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    break block17;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var13_16 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.protocol.copy(Utility.toMessageSet(messageArray, null), folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
        }
        super.copyMessages(messageArray, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.doExpungeNotification = false;
            try {
                try {
                    this.protocol.expunge();
                }
                catch (CommandFailedException commandFailedException) {
                    if (this.mode != 2) {
                        throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var7_3 = null;
                this.doExpungeNotification = true;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                this.doExpungeNotification = true;
                throw throwable;
            }
            int n = 0;
            while (n < this.messageCache.size()) {
                IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n);
                if (iMAPMessage.isExpunged()) {
                    long l;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n);
                    if (this.uidTable == null || (l = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n;
            }
        }
        this.total = this.messageCache.size();
        Object[] objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            Message[] messageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(searchTerm);
                if (nArray != null) {
                    messageArray = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        messageArray[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return messageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            Message[] messageArray2 = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(Utility.toMessageSet(messageArray, null), searchTerm);
                if (nArray != null) {
                    messageArray2 = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        messageArray2[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return messageArray2;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    String[] stringArray = new String[]{"UIDVALIDITY"};
                    status = iMAPProtocol.status(this.fullName, stringArray);
                }
                Object var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("Cannot obtain UIDValidity", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_10 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return status.uidvalidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message getMessageByUID(long l) throws MessagingException {
        this.checkOpened();
        Long l2 = new Long(l);
        IMAPMessage iMAPMessage = null;
        if (this.uidTable != null) {
            iMAPMessage = (IMAPMessage)this.uidTable.get(l2);
            if (iMAPMessage != null) {
                return iMAPMessage;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID = this.protocol.fetchSequenceNumber(l);
                if (uID != null) {
                    iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uID.msgno - 1);
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l2, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return iMAPMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long l, long l2) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] uIDArray = this.protocol.fetchSequenceNumbers(l, l2);
                messageArray = new Message[uIDArray.length];
                int n = 0;
                while (n < uIDArray.length) {
                    IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n].msgno - 1);
                    iMAPMessage.setUID(uIDArray[n].uid);
                    messageArray[n] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                    ++n;
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return messageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        int n;
        Object object;
        Message[] messageArray;
        this.checkOpened();
        long[] lArray2 = lArray;
        if (this.uidTable != null) {
            messageArray = new Vector();
            int n2 = 0;
            while (n2 < lArray.length) {
                object = new Long(lArray[n2]);
                if (!this.uidTable.containsKey(object)) {
                    messageArray.addElement(object);
                }
                ++n2;
            }
            n = messageArray.size();
            lArray2 = new long[n];
            int n3 = 0;
            while (n3 < n) {
                lArray2[n3] = (Long)messageArray.elementAt(n3);
                ++n3;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (lArray2.length > 0) {
            try {
                messageArray = this.messageCacheLock;
                synchronized (messageArray) {
                    object = this.protocol.fetchSequenceNumbers(lArray2);
                    n = 0;
                    while (n < ((UID[])object).length) {
                        IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(object[n].msgno - 1);
                        iMAPMessage.setUID(object[n].uid);
                        this.uidTable.put(new Long(object[n].uid), iMAPMessage);
                        ++n;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        messageArray = new Message[lArray.length];
        int n4 = 0;
        while (n4 < lArray.length) {
            messageArray[n4] = (Message)this.uidTable.get(new Long(lArray[n4]));
            ++n4;
        }
        return messageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l = iMAPMessage.getUID();
        if (l != -1L) {
            return l;
        }
        UID uID = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            iMAPMessage.checkExpunged();
            try {
                uID = this.protocol.fetchUID(iMAPMessage.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (uID != null) {
            l = uID.uid;
            iMAPMessage.setUID(l);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(l), iMAPMessage);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quota[] getQuota() throws MessagingException {
        Quota[] quotaArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    quotaArray = iMAPProtocol.getQuotaRoot(this.fullName);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return quotaArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.setQuota(quota);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACL[] getACL() throws MessagingException {
        ACL[] aCLArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    aCLArray = iMAPProtocol.getACL(this.fullName);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return aCLArray;
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeACL(String string) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.deleteACL(this.fullName, string);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rights[] listRights(String string) throws MessagingException {
        Rights[] rightsArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    rightsArray = iMAPProtocol.listRights(this.fullName, string);
                }
                Object var8_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var8_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return rightsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rights myRights() throws MessagingException {
        Rights rights = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    rights = iMAPProtocol.myRights(this.fullName);
                }
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var7_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return rights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setACL(ACL aCL, char c) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.setACL(this.fullName, c, aCL);
                }
                Object var8_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
                Object var8_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public void handleResponse(Response response) {
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            ((IMAPStore)this.store).handleResponse(response);
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            if (_logger.isWarnEnabled()) {
                String string = localStrings.getString("java_mail.unexpected_response");
                _logger.warn((Object)"java_mail.unexpected_response");
            }
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n = iMAPResponse.getNumber();
            if (n <= this.realTotal) {
                return;
            }
            int n2 = n - this.realTotal;
            Message[] messageArray = new Message[n2];
            int n3 = 0;
            while (n3 < n2) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[n3] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
                ++n3;
            }
            this.notifyMessageAddedListeners(messageArray);
        } else if (iMAPResponse.keyEquals("EXPUNGE")) {
            Message[] messageArray;
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            int n = iMAPMessage.getMessageNumber();
            while (n < this.total) {
                messageArray = (Message[])this.messageCache.elementAt(n);
                if (!messageArray.isExpunged()) {
                    messageArray.setSequenceNumber(messageArray.getSequenceNumber() - 1);
                }
                ++n;
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags == null ? (class$javax$mail$Flags = IMAPFolder.class$("javax.mail.Flags")) : class$javax$mail$Flags));
            if (flags != null) {
                IMAPMessage iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber());
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, iMAPMessage);
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        int n = 0;
        while (n < responseArray.length) {
            if (responseArray[n] != null) {
                this.handleResponse(responseArray[n]);
            }
            ++n;
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
            if (this.connectionPoolDebug && _logger.isDebugEnabled()) {
                String string = localStrings.getString("java_mail.used_own_connection");
                _logger.debug((Object)string);
            }
            return this.protocol;
        }
        if (this.connectionPoolDebug && _logger.isDebugEnabled()) {
            String string = localStrings.getString("java_mail.borrowed_connection");
            _logger.debug((Object)string);
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(IMAPProtocol iMAPProtocol, Exception exception) throws FolderClosedException, StoreClosedException {
        if (iMAPProtocol == this.protocol) {
            throw new FolderClosedException(this, exception.getMessage());
        }
        throw new StoreClosedException(this.store, exception.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        if (!this.opened) {
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    Object object;
                    iMAPProtocol = this.getStoreProtocol();
                    Object object2 = this.lockFor(iMAPProtocol);
                    synchronized (object2) {
                        object = protocolCommand.doCommand(iMAPProtocol);
                    }
                    Object var7_10 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    return object;
                }
                catch (ConnectionException connectionException) {
                    throw new StoreClosedException(this.store, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                return protocolCommand.doCommand(this.getProtocol());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    protected synchronized Object lockFor(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol == this.protocol) {
            return this.messageCacheLock;
        }
        return new Object();
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
        }
    }

    private synchronized void releaseProtocol(boolean bl) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (bl) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepConnectionAlive(boolean bl) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (bl && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol = null;
            try {
                iMAPProtocol = ((IMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > 1000L) {
                    iMAPProtocol.noop();
                }
                Object var4_3 = null;
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
    }

    IMAPMessage getMessageBySeqNumber(int n) {
        int n2 = n - 1;
        while (n2 < this.total) {
            IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n2);
            if (iMAPMessage.getSequenceNumber() == n) {
                return iMAPMessage;
            }
            ++n2;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }
}

