/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPInputStream;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPMultipartDataSource;
import com.sun.mail.imap.IMAPNestedMessage;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.IMAPProtocol;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;

public class IMAPBodyPart
extends MimeBodyPart {
    private IMAPMessage message;
    private BODYSTRUCTURE bs;
    private String sectionId;
    private String type;
    private String description;
    private boolean headersLoaded = false;

    protected IMAPBodyPart(BODYSTRUCTURE bODYSTRUCTURE, String string, IMAPMessage iMAPMessage) {
        this.bs = bODYSTRUCTURE;
        this.sectionId = string;
        this.message = iMAPMessage;
        ContentType contentType = new ContentType(bODYSTRUCTURE.type, bODYSTRUCTURE.subtype, bODYSTRUCTURE.cParams);
        this.type = contentType.toString();
    }

    protected void updateHeaders() {
    }

    public int getSize() throws MessagingException {
        return this.bs.size;
    }

    public int getLineCount() throws MessagingException {
        return this.bs.lines;
    }

    public String getContentType() throws MessagingException {
        return this.type;
    }

    public String getDisposition() throws MessagingException {
        return this.bs.disposition;
    }

    public void setDisposition(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String getEncoding() throws MessagingException {
        return this.bs.encoding;
    }

    public String getContentID() throws MessagingException {
        return this.bs.id;
    }

    public String getContentMD5() throws MessagingException {
        return this.bs.md5;
    }

    public void setContentMD5(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String getDescription() throws MessagingException {
        if (this.description != null) {
            return this.description;
        }
        if (this.bs.description == null) {
            return null;
        }
        try {
            this.description = MimeUtility.decodeText(this.bs.description);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.description = this.bs.description;
        }
        return this.description;
    }

    public void setDescription(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String getFileName() throws MessagingException {
        String string = null;
        if (this.bs.dParams != null) {
            string = this.bs.dParams.get("filename");
        }
        if (string == null && this.bs.cParams != null) {
            string = this.bs.cParams.get("name");
        }
        return string;
    }

    public void setFileName(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getContentStream() throws MessagingException {
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.message.getMessageCacheLock();
        synchronized (object) {
            IMAPProtocol iMAPProtocol = this.message.getProtocol();
            if (iMAPProtocol.isREV1() && this.message.getFetchBlockSize() != -1) {
                return new IMAPInputStream(this.message, this.sectionId, this.bs.size);
            }
            this.message.checkExpunged();
            int n = this.message.getSequenceNumber();
            try {
                BODY bODY = iMAPProtocol.fetchBody(n, this.sectionId);
                if (bODY != null) {
                    byteArrayInputStream = bODY.getByteArrayInputStream();
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.message.getFolder(), connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        return byteArrayInputStream;
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            if (this.bs.isMulti()) {
                this.dh = new DataHandler((DataSource)new IMAPMultipartDataSource(this, this.bs.bodies, this.sectionId, this.message));
            } else if (this.bs.isNested() && this.message.getProtocol().isREV1()) {
                this.dh = new DataHandler((Object)new IMAPNestedMessage(this.message, this.bs.bodies[0], this.bs.envelope, this.sectionId), this.type);
            }
        }
        return super.getDataHandler();
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void setContent(Object object, String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void setContent(Multipart multipart) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String[] getHeader(String string) throws MessagingException {
        this.loadHeaders();
        return super.getHeader(string);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        this.loadHeaders();
        return super.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        this.loadHeaders();
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getNonMatchingHeaderLines(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadHeaders() throws MessagingException {
        IMAPProtocol iMAPProtocol;
        if (this.headersLoaded) {
            return;
        }
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        if ((iMAPProtocol = this.message.getProtocol()).isREV1()) {
            BODY bODY = null;
            Object object = this.message.getMessageCacheLock();
            synchronized (object) {
                iMAPProtocol = this.message.getProtocol();
                this.message.checkExpunged();
                int n = this.message.getSequenceNumber();
                try {
                    bODY = iMAPProtocol.peekBody(n, this.sectionId + ".MIME");
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this.message.getFolder(), connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            if (bODY == null) {
                throw new MessagingException("Failed to fetch headers");
            }
            ByteArrayInputStream byteArrayInputStream = bODY.getByteArrayInputStream();
            if (byteArrayInputStream == null) {
                throw new MessagingException("Failed to fetch headers");
            }
            this.headers.load(byteArrayInputStream);
        } else {
            this.headers.addHeader("Content-Type", this.type);
            this.headers.addHeader("Content-Transfer-Encoding", this.bs.encoding);
            if (this.bs.description != null) {
                this.headers.addHeader("Content-Description", this.bs.description);
            }
            if (this.bs.id != null) {
                this.headers.addHeader("Content-ID", this.bs.id);
            }
            if (this.bs.md5 != null) {
                this.headers.addHeader("Content-MD5", this.bs.md5);
            }
        }
        this.headersLoaded = true;
    }
}

