/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.soap.DataContentHandlerFactoryImpl;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

public class AttachmentPartImpl
extends AttachmentPart {
    MimeHeaders headers = new MimeHeaders();
    private DataHandler dataHandler;

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteOutputStream byteOutputStream = new ByteOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)byteOutputStream);
        }
        catch (IOException iOException) {
            throw new SOAPException("Data handler error: " + iOException);
        }
        byte[] byArray = byteOutputStream.getBytes();
        if (byArray != null) {
            return byArray.length;
        }
        return -1;
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Object getContent() throws SOAPException {
        try {
            return this.getDataHandler().getContent();
        }
        catch (IOException iOException) {
            throw new SOAPException((Throwable)iOException);
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
    }

    public void setContent(Object object, String string) throws IllegalArgumentException {
        DataHandler dataHandler = new DataHandler(object, string);
        this.setDataHandler(dataHandler);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No data handler associated with this attachment");
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) throws IllegalArgumentException {
        if (dataHandler == null) {
            throw new IllegalArgumentException("Null dataHandler argument to setDataHandler");
        }
        this.dataHandler = dataHandler;
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.headers.removeHeader(string);
    }

    public String[] getMimeHeader(String string) {
        return this.headers.getHeader(string);
    }

    public void setMimeHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    public void addMimeHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    boolean hasAllHeaders(MimeHeaders mimeHeaders) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = this.headers.getHeader(mimeHeader.getName());
            boolean bl = false;
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (mimeHeader.getValue().equalsIgnoreCase(stringArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(this.dataHandler);
            AttachmentPartImpl.copyMimeHeaders(this.headers, mimeBodyPart);
            return mimeBodyPart;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to externalize attachment", (Throwable)exception);
        }
    }

    public static void copyMimeHeaders(MimeHeaders mimeHeaders, MimeBodyPart mimeBodyPart) throws SOAPException {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            try {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                mimeBodyPart.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
            catch (Exception exception) {
                throw new SOAPException("Unable to copy MIME header", (Throwable)exception);
            }
        }
    }

    public static void copyMimeHeaders(MimeBodyPart mimeBodyPart, AttachmentPartImpl attachmentPartImpl) throws SOAPException {
        try {
            Enumeration enumeration = mimeBodyPart.getNonMatchingHeaders(new String[]{"Content-Type"});
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                attachmentPartImpl.addMimeHeader(header.getName(), header.getValue());
            }
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to copy MIME headers into attachment", (Throwable)exception);
        }
    }

    static {
        DataHandler.setDataContentHandlerFactory((DataContentHandlerFactory)new DataContentHandlerFactoryImpl());
    }
}

