/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.LineFormatter;

public class JComment {
    public static final short AUTO_STYLE = 0;
    public static final short BLOCK_STYLE = 1;
    public static final short LINE_STYLE = 2;
    public static final short HEADER_STYLE = 3;
    public static final short JAVADOC_STYLE = 4;
    private static final String START_BLOCK = "/*";
    private static final String END_BLOCK = " */";
    private static final String START_JAVADOC = "/**";
    private static final String END_JAVADOC = "**/";
    private static final String ASTERIX_PREFIX = " * ";
    private static final String LINE_COMMENT_PREFIX = "// ";
    private static final String SPACE_PREFIX = " ";
    private short style = 0;
    private StringBuffer _comment = new StringBuffer();
    protected static final int MAX_LENGTH = 65;

    public JComment() {
    }

    public JComment(short s) {
        this();
        this.style = s;
    }

    public void appendComment(String string) {
        this._comment.append(string);
    }

    public void print(JSourceWriter jSourceWriter) {
        if (jSourceWriter == null) {
            return;
        }
        LineFormatter lineFormatter = null;
        short s = jSourceWriter.getIndentSize();
        int n = 65 - s;
        if (n <= 17) {
            n = 32;
        }
        int n2 = this.style;
        if (this.style == 0) {
            int n3 = this._comment.length() / n;
            n2 = n3 > 2 ? 1 : 2;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        switch (n2) {
            case 1: {
                string2 = START_BLOCK;
                string3 = END_BLOCK;
                string = SPACE_PREFIX;
                break;
            }
            case 3: {
                string2 = START_BLOCK;
                string3 = END_BLOCK;
                string = ASTERIX_PREFIX;
                break;
            }
            case 4: {
                string2 = START_JAVADOC;
                string3 = END_JAVADOC;
                string = ASTERIX_PREFIX;
                break;
            }
            default: {
                string = LINE_COMMENT_PREFIX;
            }
        }
        if (string2 != null) {
            jSourceWriter.writeln(string2);
        }
        lineFormatter = new LineFormatter(this._comment.toString(), n, string);
        while (lineFormatter.hasMoreLines()) {
            jSourceWriter.writeln(lineFormatter.nextLine());
        }
        if (string3 != null) {
            jSourceWriter.writeln(string3);
        }
        jSourceWriter.flush();
    }

    public void setComment(String string) {
        this._comment.setLength(0);
        this._comment.append(string);
    }

    public void setStyle(short s) {
        this.style = s;
    }

    public String toString() {
        return "";
    }
}

