/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean isCombiningChar(char c) {
        return false;
    }

    public static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static boolean isNCName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (!ValidationUtils.isLetter(c) && c != '_') {
            return false;
        }
        int n = 1;
        while (n < cArray.length) {
            if (!ValidationUtils.isNCNameChar(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isNCNameChar(char c) {
        if (ValidationUtils.isLetter(c) || ValidationUtils.isDigit(c)) {
            return true;
        }
        if (ValidationUtils.isExtender(c) || ValidationUtils.isCombiningChar(c)) {
            return true;
        }
        switch (c) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNMToken(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (!(ValidationUtils.isLetter(c) || ValidationUtils.isDigit(c) || ValidationUtils.isExtender(c) || ValidationUtils.isCombiningChar(c))) {
                switch (c) {
                    case '-': 
                    case '.': 
                    case ':': 
                    case '_': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public static boolean isCDATA(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static boolean isExtender(char c) {
        if (c >= '\u3031' && c <= '\u3035') {
            return true;
        }
        if (c >= '\u30fc' && c <= '\u30fe') {
            return true;
        }
        switch (c) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': 
            case '\u309d': 
            case '\u309e': {
                return true;
            }
        }
        return false;
    }
}

