/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.util.AttributeListWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class DOMEventProducer
implements EventProducer {
    private DocumentHandler _handler = null;
    private Node _node = null;

    public DOMEventProducer() {
    }

    public DOMEventProducer(Node node) {
        this._node = node;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this._handler = documentHandler;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public void start() throws SAXException {
        if (this._node == null || this._handler == null) {
            return;
        }
        DOMEventProducer.process(this._node, this._handler);
    }

    public static void process(Document document, DocumentHandler documentHandler) throws SAXException {
        if (document == null) {
            return;
        }
        if (documentHandler == null) {
            return;
        }
        documentHandler.startDocument();
        DOMEventProducer.processChildren(document, documentHandler);
        documentHandler.endDocument();
    }

    public static void process(Node node, DocumentHandler documentHandler) throws SAXException {
        if (node == null || documentHandler == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                DOMEventProducer.process((Document)node, documentHandler);
                break;
            }
            case 11: {
                DOMEventProducer.processChildren(node, documentHandler);
                break;
            }
            case 1: {
                DOMEventProducer.process((Element)node, documentHandler);
                break;
            }
            case 3: 
            case 4: {
                DOMEventProducer.process((Text)node, documentHandler);
                break;
            }
            case 7: {
                DOMEventProducer.process((ProcessingInstruction)node, documentHandler);
                break;
            }
        }
    }

    private static void process(Element element, DocumentHandler documentHandler) throws SAXException {
        String string = element.getNodeName();
        AttributeListWrapper attributeListWrapper = new AttributeListWrapper(element.getAttributes());
        documentHandler.startElement(string, attributeListWrapper);
        DOMEventProducer.processChildren(element, documentHandler);
        documentHandler.endElement(string);
    }

    private static void process(Text text, DocumentHandler documentHandler) throws SAXException {
        String string = text.getData();
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            documentHandler.characters(cArray, 0, cArray.length);
        }
    }

    private static void process(ProcessingInstruction processingInstruction, DocumentHandler documentHandler) throws SAXException {
        documentHandler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    private static void processChildren(Node node, DocumentHandler documentHandler) throws SAXException {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            DOMEventProducer.process(node2, documentHandler);
            node2 = node2.getNextSibling();
        }
    }
}

