/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;

public class ComplexType
extends XMLType
implements ContentModelGroup,
Referable {
    private boolean _abstract = false;
    private Wildcard _anyAttribute = null;
    private AttributeGroupDecl _attributes = null;
    private String _baseType = null;
    private BlockList _block = null;
    private boolean _complexContent = false;
    private ContentType _content = ContentType.elemOnly;
    private ContentModelGroup _contentModel = null;
    private FinalList _final = null;
    private String _id = null;
    private Structure _parent = null;
    private boolean _restricted = false;
    private boolean _simpleContent = false;

    public ComplexType(Schema schema) {
        this(schema, null);
    }

    public ComplexType(Schema schema, String string) {
        if (schema == null) {
            String string2 = XMLType.NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this.setSchema(schema);
        this.setName(string);
        this._attributes = new AttributeGroupDecl(schema);
        this._contentModel = new ContentModelGroupImpl();
    }

    public void addAttributeDecl(AttributeDecl attributeDecl) throws SchemaException {
        this._attributes.addAttribute(attributeDecl);
    }

    public void removeAttributeDecl(AttributeDecl attributeDecl) {
        this._attributes.removeAttribute(attributeDecl);
    }

    public void addAttributeGroupReference(AttributeGroupReference attributeGroupReference) {
        this._attributes.addReference(attributeGroupReference);
    }

    public void removeAttributeGroupReference(AttributeGroupReference attributeGroupReference) {
        this._attributes.removeReference(attributeGroupReference);
    }

    public AttributeDecl createAttributeDecl(String string) {
        return new AttributeDecl(this.getSchema(), string);
    }

    public Wildcard getAnyAttribute() {
        return this._anyAttribute;
    }

    public AttributeDecl getAttributeDecl(String string) {
        return this._attributes.getAttribute(string);
    }

    public Enumeration getAttributeDecls() {
        return this._attributes.getAttributes();
    }

    public XMLType getBaseType() {
        if (this._baseType != null && super.getBaseType() == null) {
            this.setBaseType(this.getSchema().getType(this._baseType));
        }
        return super.getBaseType();
    }

    public BlockList getBlock() {
        return this._block;
    }

    public ContentType getContentType() {
        return this._content;
    }

    public FinalList getFinal() {
        return this._final;
    }

    public String getId() {
        return this._id;
    }

    public Structure getParent() {
        return this._parent;
    }

    public String getReferenceId() {
        return "archetype:" + this.getName();
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public boolean isTopLevel() {
        if (this.getName() == null) {
            return false;
        }
        if (this.getSchema() == null) {
            return false;
        }
        return this.getSchema().getComplexType(this.getName()) == this;
    }

    public boolean isComplexContent() {
        return this._complexContent;
    }

    public boolean isSimpleContent() {
        return this._simpleContent;
    }

    public boolean isRestricted() {
        return this._restricted;
    }

    public void setAbstract(boolean bl) {
        this._abstract = bl;
    }

    public void setAnyAttribute(Wildcard wildcard) throws SchemaException {
        if (wildcard != null) {
            if (this._anyAttribute != null) {
                String string = "<anyAttribute> already set in this complexType: " + this.getName();
                throw new SchemaException(string);
            }
            if (!wildcard.isAttributeWildcard()) {
                String string = "In complexType, " + this.getName() + "the wildcard must be an <anyAttribute>";
                throw new SchemaException(string);
            }
        }
        this._anyAttribute = wildcard;
    }

    public boolean removeWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return false;
        }
        if (wildcard.equals(this._anyAttribute)) {
            this._anyAttribute = null;
            return true;
        }
        return false;
    }

    public void addWildcard(Wildcard wildcard) throws SchemaException {
        this.setAnyAttribute(wildcard);
    }

    public void setBase(String string) {
        this._baseType = string;
    }

    public void setBlock(BlockList blockList) {
        if (blockList != null && blockList.hasSubstitution()) {
            String string = "'substitution' is an illegal value of the 'block' attribute for a complexType definition.";
            throw new IllegalArgumentException(string);
        }
        this._block = blockList;
    }

    public void setBlock(String string) {
        if (string == null) {
            this._block = null;
        } else {
            this.setBlock(new BlockList(string));
        }
    }

    public void setComplexContent(boolean bl) {
        this._complexContent = bl;
    }

    public void setContentType(ContentType contentType) {
        this._content = contentType;
    }

    public void setFinal(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinal(String string) {
        this._final = string == null ? null : new FinalList(string);
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setSimpleContent(boolean bl) {
        this._simpleContent = bl;
    }

    public void setRestriction(boolean bl) {
        this._restricted = bl;
    }

    public void useResolver(Resolver resolver) {
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        this._contentModel.addElementDecl(elementDecl);
    }

    public boolean removeElementDecl(ElementDecl elementDecl) {
        return this._contentModel.removeElementDecl(elementDecl);
    }

    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    public boolean removeGroup(Group group) {
        boolean bl = this._contentModel.removeGroup(group);
        group.setParent(null);
        return bl;
    }

    public void addGroup(ModelGroup modelGroup) throws SchemaException {
        this._contentModel.addGroup(modelGroup);
        modelGroup.setParent(this);
    }

    public boolean removeGroup(ModelGroup modelGroup) {
        boolean bl = this._contentModel.removeGroup(modelGroup);
        modelGroup.setParent(null);
        return bl;
    }

    public Enumeration enumerate() {
        return this._contentModel.enumerate();
    }

    public ElementDecl getElementDecl(String string) {
        return this._contentModel.getElementDecl(string);
    }

    public int getMaxOccurs() {
        Particle particle;
        if (this._contentModel.getParticleCount() > 0 && (particle = this._contentModel.getParticle(0)) instanceof ContentModelGroup) {
            return particle.getMaxOccurs();
        }
        return this._contentModel.getMaxOccurs();
    }

    public int getMinOccurs() {
        Particle particle;
        if (this._contentModel.getParticleCount() > 0 && (particle = this._contentModel.getParticle(0)) instanceof ContentModelGroup) {
            return particle.getMinOccurs();
        }
        return this._contentModel.getMinOccurs();
    }

    public Particle getParticle(int n) {
        return this._contentModel.getParticle(n);
    }

    public int getParticleCount() {
        return this._contentModel.getParticleCount();
    }

    public short getStructureType() {
        return 5;
    }

    protected void setParent(Structure structure) {
        if (structure != null) {
            switch (structure.getStructureType()) {
                case 7: 
                case 17: {
                    break;
                }
                default: {
                    String string = "Invalid parent for ComplexType";
                    throw new IllegalArgumentException(string);
                }
            }
        }
        this._parent = structure;
    }
}

