/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.math.BigDecimal;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class XSDecimal
extends XSType {
    BigDecimal _maxInclusive = null;
    BigDecimal _maxExclusive = null;
    BigDecimal _minInclusive = null;
    BigDecimal _minExclusive = null;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;
    private static final JType jType = new JClass("java.math.BigDecimal");
    private String value = null;

    public XSDecimal() {
        super((short)16);
    }

    public String createFromJavaObjectCode(String string) {
        return "(java.math.BigDecimal)" + string;
    }

    public BigDecimal getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigDecimal getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigDecimal getMinExclusive() {
        return this._minExclusive;
    }

    public BigDecimal getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public int getFractionDigits() {
        return this._fractionDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(BigDecimal bigDecimal) {
        this._maxExclusive = bigDecimal;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(BigDecimal bigDecimal) {
        this._maxInclusive = bigDecimal;
        this._maxExclusive = null;
    }

    public void setMinExclusive(BigDecimal bigDecimal) {
        this._minExclusive = bigDecimal;
        this._minInclusive = null;
    }

    public void setMinInclusive(BigDecimal bigDecimal) {
        this._minInclusive = bigDecimal;
        this._minExclusive = null;
    }

    public void setTotalDigits(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = n;
    }

    public void setFractionDigits(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(this.getName() + ": the fractionDigits facet must be positive");
        }
        this._fractionDigits = n;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("totalDigits".equals(string)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if (!"fractionDigits".equals(string)) continue;
            this.setFractionDigits(facet.toInt());
        }
    }

    public JType getJType() {
        return jType;
    }

    public String newInstanceCode() {
        String string = "new java.math.BigDecimal(0);";
        return string;
    }
}

