/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.http.HTTPAddress;
import com.sun.xml.rpc.wsdl.document.http.HTTPBinding;
import com.sun.xml.rpc.wsdl.document.http.HTTPConstants;
import com.sun.xml.rpc.wsdl.document.http.HTTPOperation;
import com.sun.xml.rpc.wsdl.document.http.HTTPUrlEncoded;
import com.sun.xml.rpc.wsdl.document.http.HTTPUrlReplacement;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandlerBase;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import org.w3c.dom.Element;

public class HTTPExtensionHandler
extends ExtensionHandlerBase {
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/http/";
    }

    protected boolean handleDefinitionsExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleTypesExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleBindingExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, HTTPConstants.QNAME_BINDING)) {
            parserContext.push();
            parserContext.registerNamespaces(element);
            HTTPBinding hTTPBinding = new HTTPBinding();
            String string = Util.getRequiredAttribute(element, "verb");
            hTTPBinding.setVerb(string);
            extensible.addExtension(hTTPBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(HTTPConstants.QNAME_BINDING, hTTPBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleOperationExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, HTTPConstants.QNAME_OPERATION)) {
            parserContext.push();
            parserContext.registerNamespaces(element);
            HTTPOperation hTTPOperation = new HTTPOperation();
            String string = Util.getRequiredAttribute(element, "location");
            hTTPOperation.setLocation(string);
            extensible.addExtension(hTTPOperation);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(HTTPConstants.QNAME_OPERATION, hTTPOperation);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleInputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, HTTPConstants.QNAME_URL_ENCODED)) {
            extensible.addExtension(new HTTPUrlEncoded());
            return true;
        }
        if (XmlUtil.matchesTagNS(element, HTTPConstants.QNAME_URL_REPLACEMENT)) {
            extensible.addExtension(new HTTPUrlReplacement());
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleOutputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleFaultExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleServiceExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handlePortExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, HTTPConstants.QNAME_ADDRESS)) {
            parserContext.push();
            parserContext.registerNamespaces(element);
            HTTPAddress hTTPAddress = new HTTPAddress();
            String string = Util.getRequiredAttribute(element, "location");
            hTTPAddress.setLocation(string);
            extensible.addExtension(hTTPAddress);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(HTTPConstants.QNAME_ADDRESS, hTTPAddress);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleMIMEPartExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    public void doHandleExtension(WriterContext writerContext, Extension extension) throws IOException {
        if (extension instanceof HTTPAddress) {
            HTTPAddress hTTPAddress = (HTTPAddress)extension;
            writerContext.writeStartTag(hTTPAddress.getElementName());
            writerContext.writeAttribute("location", hTTPAddress.getLocation());
            writerContext.writeEndTag(hTTPAddress.getElementName());
        } else if (extension instanceof HTTPBinding) {
            HTTPBinding hTTPBinding = (HTTPBinding)extension;
            writerContext.writeStartTag(hTTPBinding.getElementName());
            writerContext.writeAttribute("verb", hTTPBinding.getVerb());
            writerContext.writeEndTag(hTTPBinding.getElementName());
        } else if (extension instanceof HTTPOperation) {
            HTTPOperation hTTPOperation = (HTTPOperation)extension;
            writerContext.writeStartTag(hTTPOperation.getElementName());
            writerContext.writeAttribute("location", hTTPOperation.getLocation());
            writerContext.writeEndTag(hTTPOperation.getElementName());
        } else if (extension instanceof HTTPUrlEncoded) {
            writerContext.writeStartTag(extension.getElementName());
            writerContext.writeEndTag(extension.getElementName());
        } else if (extension instanceof HTTPUrlReplacement) {
            writerContext.writeStartTag(extension.getElementName());
            writerContext.writeEndTag(extension.getElementName());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

