/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document;

import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.EntityAction;
import com.sun.xml.rpc.wsdl.framework.ExtensibilityHelper;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class BindingOperation
extends Entity
implements Extensible {
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private BindingInput _input;
    private BindingOutput _output;
    private List _faults = new ArrayList();
    private OperationStyle _style;
    private String _uniqueKey;

    public BindingOperation() {
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getUniqueKey() {
        if (this._uniqueKey == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._name);
            stringBuffer.append(' ');
            if (this._input != null) {
                stringBuffer.append(this._input.getName());
            } else {
                stringBuffer.append(this._name);
                if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    stringBuffer.append("Request");
                } else if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    stringBuffer.append("Response");
                }
            }
            stringBuffer.append(' ');
            if (this._output != null) {
                stringBuffer.append(this._output.getName());
            } else {
                stringBuffer.append(this._name);
                if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    stringBuffer.append("Solicit");
                } else if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    stringBuffer.append("Response");
                }
            }
            this._uniqueKey = stringBuffer.toString();
        }
        return this._uniqueKey;
    }

    public OperationStyle getStyle() {
        return this._style;
    }

    public void setStyle(OperationStyle operationStyle) {
        this._style = operationStyle;
    }

    public BindingInput getInput() {
        return this._input;
    }

    public void setInput(BindingInput bindingInput) {
        this._input = bindingInput;
    }

    public BindingOutput getOutput() {
        return this._output;
    }

    public void setOutput(BindingOutput bindingOutput) {
        this._output = bindingOutput;
    }

    public void addFault(BindingFault bindingFault) {
        this._faults.add(bindingFault);
    }

    public Iterator faults() {
        return this._faults.iterator();
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_OPERATION;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this._documentation = documentation;
    }

    public void addExtension(Extension extension) {
        this._helper.addExtension(extension);
    }

    public Iterator extensions() {
        return this._helper.extensions();
    }

    public void withAllSubEntitiesDo(EntityAction entityAction) {
        if (this._input != null) {
            entityAction.perform(this._input);
        }
        if (this._output != null) {
            entityAction.perform(this._output);
        }
        Iterator iterator = this._faults.iterator();
        while (iterator.hasNext()) {
            entityAction.perform((Entity)iterator.next());
        }
        this._helper.withAllSubEntitiesDo(entityAction);
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        wSDLDocumentVisitor.preVisit(this);
        if (this._input != null) {
            this._input.accept(wSDLDocumentVisitor);
        }
        if (this._output != null) {
            this._output.accept(wSDLDocumentVisitor);
        }
        Iterator iterator = this._faults.iterator();
        while (iterator.hasNext()) {
            ((BindingFault)iterator.next()).accept(wSDLDocumentVisitor);
        }
        this._helper.accept(wSDLDocumentVisitor);
        wSDLDocumentVisitor.postVisit(this);
    }

    public void validateThis() {
        if (this._name == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
        if (this._style == null) {
            this.failValidation("validation.missingRequiredProperty", "style");
        }
        if (this._style == OperationStyle.ONE_WAY) {
            if (this._input == null) {
                this.failValidation("validation.missingRequiredSubEntity", "input");
            }
            if (this._output != null) {
                this.failValidation("validation.invalidSubEntity", "output");
            }
            if (this._faults != null && this._faults.size() != 0) {
                this.failValidation("validation.invalidSubEntity", "fault");
            }
        }
    }
}

