/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wscompile;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.config.parser.ConfigurationParser;
import com.sun.xml.rpc.processor.generator.CustomClassGenerator;
import com.sun.xml.rpc.processor.generator.CustomExceptionGenerator;
import com.sun.xml.rpc.processor.generator.EnumerationEncoderGenerator;
import com.sun.xml.rpc.processor.generator.EnumerationGenerator;
import com.sun.xml.rpc.processor.generator.FaultExceptionBuilderGenerator;
import com.sun.xml.rpc.processor.generator.HolderGenerator;
import com.sun.xml.rpc.processor.generator.InterfaceSerializerGenerator;
import com.sun.xml.rpc.processor.generator.LiteralObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.RemoteInterfaceGenerator;
import com.sun.xml.rpc.processor.generator.RemoteInterfaceImplGenerator;
import com.sun.xml.rpc.processor.generator.SOAPFaultSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectBuilderGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SerializerRegistryGenerator;
import com.sun.xml.rpc.processor.generator.ServiceGenerator;
import com.sun.xml.rpc.processor.generator.ServiceInterfaceGenerator;
import com.sun.xml.rpc.processor.generator.ServletConfigGenerator;
import com.sun.xml.rpc.processor.generator.StubGenerator;
import com.sun.xml.rpc.processor.generator.TieGenerator;
import com.sun.xml.rpc.processor.generator.WSDLGenerator;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.processor.util.ModelWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.util.ToolBase;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.tools.javac.Main;

public class CompileTool
extends ToolBase
implements ProcessorNotificationListener {
    protected Properties properties;
    protected ProcessorEnvironment environment;
    protected Configuration configuration;
    protected Processor processor;
    protected ProcessorNotificationListener listener = this;
    protected Map actions;
    protected File configFile;
    protected File modelFile;
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected File debugModelFile;
    protected int mode = 0;
    protected boolean doNothing = false;
    protected boolean compilerDebug = false;
    protected boolean compilerOptimize = false;
    protected boolean verbose = false;
    protected boolean noDataBinding = false;
    protected boolean noEncodedTypes = false;
    protected boolean noMultiRefEncoding = false;
    protected boolean noValidation = false;
    protected boolean explicitServiceContext = false;
    protected boolean printStackTrace = false;
    protected boolean keepGenerated = false;
    protected boolean serializeInterfaces = false;
    protected boolean searchSchemaForSubtypes = false;
    protected boolean useDataHandlerOnly = false;
    protected String serializerInfix = null;
    protected String userClasspath = null;
    protected static final int MODE_UNSPECIFIED = 0;
    protected static final int MODE_IMPORT = 2;
    protected static final int MODE_DEFINE = 3;
    protected static final int MODE_GEN_CLIENT = 4;
    protected static final int MODE_GEN_SERVER = 5;
    protected static final int MODE_GEN_BOTH = 6;

    public CompileTool(OutputStream outputStream, String string) {
        super(outputStream, string);
    }

    protected void initialize() {
        super.initialize();
        this.properties = new Properties();
        this.actions = new HashMap();
        this.actions.put("remote.interface.generator", new RemoteInterfaceGenerator());
        this.actions.put("remote.interface.impl.generator", new RemoteInterfaceImplGenerator());
        this.actions.put("custom.class.generator", new CustomClassGenerator());
        this.actions.put("soap.object.serializer.generator", new SOAPObjectSerializerGenerator());
        this.actions.put("interface.serializer.generator", new InterfaceSerializerGenerator());
        this.actions.put("soap.object.builder.generator", new SOAPObjectBuilderGenerator());
        this.actions.put("literal.object.serializer.generator", new LiteralObjectSerializerGenerator());
        this.actions.put("stub.generator", new StubGenerator());
        this.actions.put("tie.generator", new TieGenerator());
        this.actions.put("servlet.config.generator", new ServletConfigGenerator());
        this.actions.put("wsdl.generator", new WSDLGenerator());
        this.actions.put("holder.generator", new HolderGenerator());
        this.actions.put("service.interface.generator", new ServiceInterfaceGenerator());
        this.actions.put("service.generator", new ServiceGenerator());
        this.actions.put("serializer.registry.generator", new SerializerRegistryGenerator());
        this.actions.put("custom.exception.generator", new CustomExceptionGenerator());
        this.actions.put("soap.fault.serializer.generator", new SOAPFaultSerializerGenerator());
        this.actions.put("enumeration.generator", new EnumerationGenerator());
        this.actions.put("enumeration.encoder.generator", new EnumerationEncoderGenerator());
        this.actions.put("fault.exception.builder.generator", new FaultExceptionBuilderGenerator());
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parseArguments(String[] var1_1) {
        var2_2 = 0;
        while (var2_2 < var1_1.length) {
            block50: {
                block65: {
                    block66: {
                        block63: {
                            block64: {
                                block61: {
                                    block62: {
                                        block60: {
                                            block56: {
                                                block59: {
                                                    block58: {
                                                        block57: {
                                                            block55: {
                                                                block54: {
                                                                    block53: {
                                                                        block52: {
                                                                            block51: {
                                                                                block49: {
                                                                                    if (!var1_1[var2_2].equals("")) break block49;
                                                                                    var1_1[var2_2] = null;
                                                                                    break block50;
                                                                                }
                                                                                if (!var1_1[var2_2].equals("-g")) break block51;
                                                                                this.compilerDebug = true;
                                                                                var1_1[var2_2] = null;
                                                                                break block50;
                                                                            }
                                                                            if (!var1_1[var2_2].equals("-O")) break block52;
                                                                            this.compilerOptimize = true;
                                                                            var1_1[var2_2] = null;
                                                                            break block50;
                                                                        }
                                                                        if (!var1_1[var2_2].equals("-verbose")) break block53;
                                                                        this.verbose = true;
                                                                        var1_1[var2_2] = null;
                                                                        break block50;
                                                                    }
                                                                    if (!var1_1[var2_2].equals("-import")) break block54;
                                                                    if (this.mode != 0) {
                                                                        this.onError(this.getMessage("wscompile.tooManyModesSpecified"));
                                                                        this.usage();
                                                                        return false;
                                                                    }
                                                                    this.mode = 2;
                                                                    var1_1[var2_2] = null;
                                                                    break block50;
                                                                }
                                                                if (!var1_1[var2_2].equals("-define")) break block55;
                                                                if (this.mode != 0) {
                                                                    this.onError(this.getMessage("wscompile.tooManyModesSpecified"));
                                                                    this.usage();
                                                                    return false;
                                                                }
                                                                this.mode = 3;
                                                                var1_1[var2_2] = null;
                                                                break block50;
                                                            }
                                                            if (!var1_1[var2_2].startsWith("-gen")) break block56;
                                                            if (this.mode != 0) {
                                                                this.onError(this.getMessage("wscompile.tooManyModesSpecified"));
                                                                this.usage();
                                                                return false;
                                                            }
                                                            if (!var1_1[var2_2].equals("-gen") && !var1_1[var2_2].equals("-gen:client")) break block57;
                                                            this.mode = 4;
                                                            var1_1[var2_2] = null;
                                                            break block50;
                                                        }
                                                        if (!var1_1[var2_2].equals("-gen:server")) break block58;
                                                        this.mode = 5;
                                                        var1_1[var2_2] = null;
                                                        break block50;
                                                    }
                                                    if (!var1_1[var2_2].equals("-gen:both")) break block59;
                                                    this.mode = 6;
                                                    var1_1[var2_2] = null;
                                                    break block50;
                                                }
                                                this.onError(this.getMessage("wscompile.invalidOption", var1_1[var2_2]));
                                                this.usage();
                                                return false;
                                            }
                                            if (var1_1[var2_2].equals("-version")) {
                                                this.report(this.getMessage("wscompile.version", "JAX-RPC Reference Implementation", "1.0.1", "R3"));
                                                this.doNothing = true;
                                                var1_1[var2_2] = null;
                                                return true;
                                            }
                                            if (!var1_1[var2_2].equals("-keep")) break block60;
                                            this.keepGenerated = true;
                                            var1_1[var2_2] = null;
                                            break block50;
                                        }
                                        if (!var1_1[var2_2].equals("-d")) break block61;
                                        if (var2_2 + 1 >= var1_1.length) break block62;
                                        if (this.destDir != null) {
                                            this.onError(this.getMessage("wscompile.duplicateOption", "-d"));
                                            this.usage();
                                            return false;
                                        }
                                        var1_1[var2_2] = null;
                                        this.destDir = new File(var1_1[++var2_2]);
                                        var1_1[var2_2] = null;
                                        if (!this.destDir.exists()) {
                                            this.onError(this.getMessage("wscompile.noSuchDirectory", this.destDir.getPath()));
                                            this.usage();
                                            return false;
                                        }
                                        break block50;
                                    }
                                    this.onError(this.getMessage("wscompile.missingOptionArgument", "-d"));
                                    this.usage();
                                    return false;
                                }
                                if (!var1_1[var2_2].equals("-nd")) break block63;
                                if (var2_2 + 1 >= var1_1.length) break block64;
                                if (this.nonclassDestDir != null) {
                                    this.onError(this.getMessage("wscompile.duplicateOption", "-nd"));
                                    this.usage();
                                    return false;
                                }
                                var1_1[var2_2] = null;
                                this.nonclassDestDir = new File(var1_1[++var2_2]);
                                var1_1[var2_2] = null;
                                if (!this.nonclassDestDir.exists()) {
                                    this.onError(this.getMessage("wscompile.noSuchDirectory", this.nonclassDestDir.getPath()));
                                    this.usage();
                                    return false;
                                }
                                break block50;
                            }
                            this.onError(this.getMessage("wscompile.missingOptionArgument", "-nd"));
                            this.usage();
                            return false;
                        }
                        if (!var1_1[var2_2].equals("-s")) break block65;
                        if (var2_2 + 1 >= var1_1.length) break block66;
                        if (this.sourceDir != null) {
                            this.onError(this.getMessage("wscompile.duplicateOption", "-s"));
                            this.usage();
                            return false;
                        }
                        var1_1[var2_2] = null;
                        this.sourceDir = new File(var1_1[++var2_2]);
                        var1_1[var2_2] = null;
                        if (!this.sourceDir.exists()) {
                            this.onError(this.getMessage("wscompile.noSuchDirectory", this.sourceDir.getPath()));
                            this.usage();
                            return false;
                        }
                        break block50;
                    }
                    this.onError(this.getMessage("wscompile.missingOptionArgument", "-s"));
                    this.usage();
                    return false;
                }
                if (!var1_1[var2_2].equals("-model")) ** GOTO lbl148
                if (var2_2 + 1 < var1_1.length) {
                    if (this.modelFile != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-model"));
                        this.usage();
                        return false;
                    }
                    var1_1[var2_2] = null;
                    this.modelFile = new File(var1_1[++var2_2]);
                    var1_1[var2_2] = null;
                    if (this.modelFile.isDirectory() || this.modelFile.getParentFile() != null && !this.modelFile.getParentFile().exists()) {
                        this.onError(this.getMessage("wscompile.invalidModel", this.modelFile.getPath()));
                        this.usage();
                        return false;
                    }
                } else {
                    this.onError(this.getMessage("wscompile.missingOptionArgument", "-model"));
                    this.usage();
                    return false;
lbl148:
                    // 1 sources

                    if (var1_1[var2_2].equals("-classpath") || var1_1[var2_2].equals("-cp")) {
                        if (var2_2 + 1 < var1_1.length) {
                            if (this.userClasspath != null) {
                                this.onError(this.getMessage("wscompile.duplicateOption", var1_1[var2_2]));
                                this.usage();
                                return false;
                            }
                            var1_1[var2_2] = null;
                            this.userClasspath = var1_1[++var2_2];
                            var1_1[var2_2] = null;
                        }
                    } else if (var1_1[var2_2].startsWith("-f:") || var1_1[var2_2].startsWith("-features:")) {
                        var3_3 = var1_1[var2_2].substring(var1_1[var2_2].startsWith("-f:") != false ? 3 : 10);
                        var4_7 = new StringTokenizer(var3_3, ",");
                        while (var4_7.hasMoreTokens()) {
                            var5_9 = var4_7.nextToken().trim();
                            if (var5_9.equals("datahandleronly")) {
                                this.useDataHandlerOnly = true;
                                continue;
                            }
                            if (var5_9.equals("nodatabinding")) {
                                this.noDataBinding = true;
                                continue;
                            }
                            if (var5_9.equals("noencodedtypes")) {
                                this.noEncodedTypes = true;
                                continue;
                            }
                            if (var5_9.equals("nomultirefs")) {
                                this.noMultiRefEncoding = true;
                                continue;
                            }
                            if (var5_9.equals("novalidation")) {
                                this.noValidation = true;
                                continue;
                            }
                            if (var5_9.equals("explicitcontext")) {
                                this.explicitServiceContext = true;
                                continue;
                            }
                            if (var5_9.startsWith("infix=")) {
                                var6_10 = var5_9.substring(6);
                                if (var6_10.length() == 0) {
                                    this.onError(this.getMessage("wscompile.invalidFeatureSyntax", "infix"));
                                    this.usage();
                                    return false;
                                }
                                this.serializerInfix = var6_10;
                                continue;
                            }
                            if (var5_9.equals("searchschema")) {
                                this.searchSchemaForSubtypes = true;
                                continue;
                            }
                            if (var5_9.equals("serializeinterfaces")) {
                                this.serializeInterfaces = true;
                                continue;
                            }
                            this.onError(this.getMessage("wscompile.unknownFeature", var5_9));
                            this.usage();
                            return false;
                        }
                        var1_1[var2_2] = null;
                    } else if (var1_1[var2_2].startsWith("-httpproxy:")) {
                        var3_4 = var1_1[var2_2].substring(11);
                        if (var3_4.length() == 0) {
                            this.onError(this.getMessage("wscompile.invalidOption", var1_1[var2_2]));
                            this.usage();
                            return false;
                        }
                        var4_8 = var3_4.indexOf(58);
                        if (var4_8 == -1) {
                            System.setProperty("proxySet", "true");
                            System.setProperty("proxyHost", var3_4);
                            System.setProperty("proxyPort", "8080");
                        } else {
                            System.setProperty("proxySet", "true");
                            System.setProperty("proxyHost", var3_4.substring(0, var4_8));
                            System.setProperty("proxyPort", var3_4.substring(var4_8 + 1));
                        }
                        var1_1[var2_2] = null;
                    } else if (var1_1[var2_2].equals("-Xprintstacktrace")) {
                        this.printStackTrace = true;
                        var1_1[var2_2] = null;
                    } else if (var1_1[var2_2].startsWith("-Xdebugmodel")) {
                        var3_5 = var1_1[var2_2].indexOf(58);
                        if (var3_5 == -1) {
                            this.onError(this.getMessage("wscompile.invalidOption", var1_1[var2_2]));
                            this.usage();
                            return false;
                        }
                        this.debugModelFile = new File(var1_1[var2_2].substring(var3_5 + 1));
                        var1_1[var2_2] = null;
                        if (this.debugModelFile.isDirectory() || this.debugModelFile.getParentFile() != null && !this.debugModelFile.getParentFile().exists()) {
                            this.onError(this.getMessage("wscompile.invalidPath", this.debugModelFile.getPath()));
                            this.usage();
                            return false;
                        }
                    }
                }
            }
            ++var2_2;
        }
        var3_6 = 0;
        while (var3_6 < var1_1.length) {
            if (var1_1[var3_6] != null) {
                if (var1_1[var3_6].startsWith("-")) {
                    this.onError(this.getMessage("wscompile.invalidOption", var1_1[var3_6]));
                    this.usage();
                    return false;
                }
                if (this.configFile != null) {
                    this.onError(this.getMessage("wscompile.multipleConfigurationFiles", var1_1[var3_6]));
                    this.usage();
                    return false;
                }
                this.configFile = new File(var1_1[var3_6]);
                var1_1[var3_6] = null;
                if (!this.configFile.exists()) {
                    this.onError(this.getMessage("wscompile.fileNotFound", this.configFile.getPath()));
                    this.usage();
                    return false;
                }
            }
            ++var3_6;
        }
        if (this.mode == 0) {
            this.onError(this.getMessage("wscompile.noModeSpecified"));
            this.usage();
            return false;
        }
        if (this.configFile == null) {
            this.onError(this.getMessage("wscompile.missingConfigurationFile"));
            this.usage();
            return false;
        }
        return true;
    }

    protected void usage() {
        this.report(this.getMessage("wscompile.usage", this.program));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.doNothing) {
            return;
        }
        try {
            this.beforeHook();
            this.environment = this.createEnvironment();
            this.configuration = this.createConfiguration();
            this.processor = new Processor(this.configuration, this.properties);
            this.processor.runModeler();
            this.withModelHook();
            this.registerProcessorActions(this.processor);
            this.processor.runActions();
            if (this.environment.getErrorCount() == 0) {
                this.compileGeneratedClasses();
            }
            this.afterHook();
        }
        finally {
            if (!this.keepGenerated) {
                this.removeGeneratedFiles();
            }
            if (this.environment != null) {
                this.environment.shutdown();
            }
        }
    }

    public boolean wasSuccessful() {
        return this.environment == null || this.environment.getErrorCount() == 0;
    }

    protected String getGenericErrorMessage() {
        return "wscompile.error";
    }

    protected String getResourceBundleName() {
        return "com.sun.xml.rpc.resources.wscompile";
    }

    public void printStackTrace(Throwable throwable) {
        if (this.printStackTrace) {
            if (this.environment != null) {
                this.environment.printStackTrace(throwable);
            } else {
                super.printStackTrace(throwable);
            }
        }
    }

    protected void beforeHook() {
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        this.properties.setProperty("sourceDirectory", this.sourceDir.getAbsolutePath());
        this.properties.setProperty("destinationDirectory", this.destDir.getAbsolutePath());
        this.properties.setProperty("nonclassDestinationDirectory", this.nonclassDestDir.getAbsolutePath());
        this.properties.setProperty("encodeTypes", this.noEncodedTypes ? "false" : "true");
        this.properties.setProperty("multiRefEncoding", this.noMultiRefEncoding ? "false" : "true");
        this.properties.setProperty("validationWSDL", this.noValidation ? "false" : "true");
        this.properties.setProperty("explicitServiceContext", this.explicitServiceContext ? "true" : "false");
        this.properties.setProperty("printStackTrace", this.printStackTrace ? "true" : "false");
        this.properties.setProperty("noDataBinding", this.noDataBinding ? "true" : "false");
        this.properties.setProperty("serializerInterfaces", this.serializeInterfaces ? "true" : "false");
        this.properties.setProperty("useDataHandlerOnly", this.useDataHandlerOnly ? "true" : "false");
        this.properties.setProperty("searchSchemaForSubtypes", this.searchSchemaForSubtypes ? "true" : "false");
    }

    protected void withModelHook() {
    }

    protected void afterHook() {
    }

    protected void removeGeneratedFiles() {
        this.environment.deleteGeneratedFiles();
    }

    protected ProcessorEnvironment createEnvironment() throws Exception {
        String string = this.userClasspath + File.pathSeparator + System.getProperty("java.class.path");
        ClientProcessorEnvironment clientProcessorEnvironment = new ClientProcessorEnvironment(System.out, string, this.listener);
        if (this.serializerInfix != null) {
            clientProcessorEnvironment.getNames().setSerializerNameInfix(this.serializerInfix);
        }
        int n = clientProcessorEnvironment.getFlags();
        n |= 2;
        if (this.verbose) {
            n |= 1;
        }
        clientProcessorEnvironment.setFlags(n);
        return clientProcessorEnvironment;
    }

    protected Configuration createConfiguration() throws Exception {
        ConfigurationParser configurationParser = new ConfigurationParser(this.environment);
        return configurationParser.parse(new FileInputStream(this.configFile));
    }

    protected void registerProcessorActions(Processor processor) {
        if (this.modelFile != null) {
            try {
                processor.add(new XMLModelWriter(this.modelFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.environment.error(this.getMessage("wscompile.invalidModel", this.modelFile.getPath()));
            }
        }
        if (this.debugModelFile != null) {
            try {
                processor.add(new ModelWriter(this.debugModelFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.environment.error(this.getMessage("wscompile.invalidPath", this.debugModelFile.getPath()));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        if (this.mode == 4 || this.mode == 6) {
            bl = true;
            bl2 = true;
            bl3 = true;
            bl7 = true;
            bl9 = true;
            bl6 = true;
        }
        if (this.mode == 5 || this.mode == 6) {
            bl4 = true;
            bl7 = true;
            bl9 = true;
            bl6 = true;
            bl5 = true;
        }
        if (this.mode == 2) {
            if (!(this.configuration.getModelInfo() instanceof WSDLModelInfo)) {
                this.environment.error(this.getMessage("wscompile.importRequiresWsdlConfig"));
            }
            bl7 = true;
            bl8 = true;
        }
        if (this.mode == 3 && !(this.configuration.getModelInfo() instanceof RmiModelInfo)) {
            this.environment.error(this.getMessage("wscompile.defineRequiresServiceConfig"));
        }
        if (processor.getModel() != null) {
            if (this.configuration.getModelInfo() instanceof RmiModelInfo) {
                bl7 = false;
            } else if (this.configuration.getModelInfo() instanceof WSDLModelInfo) {
                bl5 = false;
            }
        }
        if (bl3) {
            processor.add(this.getAction("service.interface.generator"));
        }
        if (bl2) {
            processor.add(this.getAction("service.generator"));
        }
        if (bl7) {
            processor.add(this.getAction("remote.interface.generator"));
            processor.add(this.getAction("enumeration.generator"));
            processor.add(this.getAction("custom.exception.generator"));
            processor.add(this.getAction("holder.generator"));
        }
        if (bl9) {
            processor.add(this.getAction("custom.class.generator"));
        }
        if (bl8) {
            processor.add(this.getAction("remote.interface.impl.generator"));
        }
        if (bl6) {
            processor.add(this.getAction("enumeration.encoder.generator"));
            processor.add(this.getAction("interface.serializer.generator"));
            processor.add(this.getAction("soap.object.serializer.generator"));
            processor.add(this.getAction("soap.object.builder.generator"));
            processor.add(this.getAction("literal.object.serializer.generator"));
            processor.add(this.getAction("soap.fault.serializer.generator"));
            processor.add(this.getAction("fault.exception.builder.generator"));
        }
        if (bl) {
            processor.add(this.getAction("stub.generator"));
        }
        if (bl4) {
            processor.add(this.getAction("tie.generator"));
        }
        if (bl6) {
            processor.add(this.getAction("serializer.registry.generator"));
        }
        if (bl5) {
            processor.add(this.getAction("wsdl.generator"));
        }
    }

    protected String createClasspathString() {
        if (this.userClasspath == null) {
            this.userClasspath = "";
        }
        return this.userClasspath + File.pathSeparator + System.getProperty("java.class.path");
    }

    protected void compileGeneratedClasses() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.environment.getGeneratedFiles();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            if (!((File)object).exists() || !((File)object).getName().endsWith(".java")) continue;
            arrayList.add(((File)object).getAbsolutePath());
        }
        if (arrayList.size() > 0) {
            object = this.destDir.getAbsolutePath();
            String string = this.createClasspathString();
            String[] stringArray = new String[4 + (this.compilerDebug ? 1 : 0) + (this.compilerOptimize ? 1 : 0) + arrayList.size()];
            stringArray[0] = "-d";
            stringArray[1] = object;
            stringArray[2] = "-classpath";
            stringArray[3] = string;
            int n = 4;
            if (this.compilerDebug) {
                stringArray[n++] = "-g";
            }
            if (this.compilerOptimize) {
                stringArray[n++] = "-O";
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                stringArray[n + n2] = (String)arrayList.get(n2);
                ++n2;
            }
            Main main = new Main(this.out, "wscompile-javac");
            boolean bl = main.compile(stringArray);
            if (main.compilationReportedErrors()) {
                this.environment.error(this.getMessage("wscompile.compilationFailed"));
            }
        }
    }

    protected ProcessorAction getAction(String string) {
        return (ProcessorAction)this.actions.get(string);
    }

    public void onError(Localizable localizable) {
        this.report(this.getMessage("wscompile.error", this.localizer.localize(localizable)));
    }

    public void onWarning(Localizable localizable) {
        this.report(this.getMessage("wscompile.warning", this.localizer.localize(localizable)));
    }

    public void onInfo(Localizable localizable) {
        this.report(this.getMessage("wscompile.info", this.localizer.localize(localizable)));
    }
}

