/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfo;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDLPublisher {
    private ServletContext servletContext;
    private Localizer localizer;
    private LocalizableMessageFactory messageFactory;
    private JAXRPCRuntimeInfo jaxrpcInfo;
    private Map templatesByEndpointInfo;
    private static final Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.rpc");

    public WSDLPublisher(ServletContext servletContext, JAXRPCRuntimeInfo jAXRPCRuntimeInfo) {
        this.servletContext = servletContext;
        this.jaxrpcInfo = jAXRPCRuntimeInfo;
        this.templatesByEndpointInfo = new HashMap();
        this.localizer = new Localizer();
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RuntimeEndpointInfo runtimeEndpointInfo, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Templates templates;
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.localizer.localize(this.messageFactory.getMessage("publisher.info.generatingWSDL", runtimeEndpointInfo.getName())));
        }
        httpServletResponse.setContentType("text/xml");
        httpServletResponse.setStatus(200);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String string = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI();
        WSDLPublisher wSDLPublisher = this;
        synchronized (wSDLPublisher) {
            templates = (Templates)this.templatesByEndpointInfo.get(runtimeEndpointInfo);
            if (templates == null) {
                templates = this.createTemplatesFor(runtimeEndpointInfo);
                this.templatesByEndpointInfo.put(runtimeEndpointInfo, templates);
            }
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.localizer.localize(this.messageFactory.getMessage("publisher.info.applyingTransformation", string)));
            }
            StreamSource streamSource = new StreamSource(this.servletContext.getResourceAsStream(runtimeEndpointInfo.getWSDLFileName()));
            Transformer transformer = templates.newTransformer();
            transformer.setParameter("actualAddress", string);
            transformer.transform(streamSource, new StreamResult((OutputStream)servletOutputStream));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new JAXRPCServletException("exception.cannotCreateTransformer");
        }
        catch (TransformerException transformerException) {
            throw new JAXRPCServletException("exception.transformationFailed");
        }
    }

    protected Templates createTemplatesFor(RuntimeEndpointInfo runtimeEndpointInfo) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.write("<xsl:transform version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\">\n");
            outputStreamWriter.write("<xsl:param name=\"actualAddress\"/>\n");
            outputStreamWriter.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            outputStreamWriter.write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
            outputStreamWriter.write(runtimeEndpointInfo.getPortName().getNamespaceURI());
            outputStreamWriter.write("']/wsdl:service[@name='");
            outputStreamWriter.write(runtimeEndpointInfo.getServiceName().getLocalPart());
            outputStreamWriter.write("']/wsdl:port[@name='");
            outputStreamWriter.write(runtimeEndpointInfo.getPortName().getLocalPart());
            outputStreamWriter.write("']/soap:address\" mode=\"copy\">");
            outputStreamWriter.write("<soap:address><xsl:attribute name=\"location\"><xsl:value-of select=\"$actualAddress\"/>");
            outputStreamWriter.write("</xsl:attribute></soap:address></xsl:template>");
            outputStreamWriter.write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
            outputStreamWriter.write("</xsl:transform>\n");
            outputStreamWriter.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(streamSource);
            return templates;
        }
        catch (Exception exception) {
            throw new JAXRPCServletException("exception.templateCreationFailed");
        }
    }

    protected static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }
}

