/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.Tie;
import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImplementorCache {
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private Map cachedImplementors = new HashMap();
    private static final Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.rpc");

    public ImplementorCache(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
        this.cachedImplementors = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Implementor getImplementorFor(RuntimeEndpointInfo runtimeEndpointInfo) {
        Object object;
        ImplementorCache implementorCache = this;
        synchronized (implementorCache) {
            object = (Implementor)this.cachedImplementors.get(runtimeEndpointInfo);
            if (object != null) {
                return object;
            }
        }
        try {
            if (this.servletConfig != null) {
                object = (Tie)runtimeEndpointInfo.getTieClass().newInstance();
                Remote remote = (Remote)runtimeEndpointInfo.getImplementationClass().newInstance();
                object.setTarget(remote);
                Implementor implementor = new Implementor(this.servletContext, (Tie)object);
                implementor.init();
                Implementor implementor2 = null;
                ImplementorCache implementorCache2 = this;
                synchronized (implementorCache2) {
                    implementor2 = (Implementor)this.cachedImplementors.get(runtimeEndpointInfo);
                    if (implementor2 == null) {
                        this.cachedImplementors.put(runtimeEndpointInfo, implementor);
                    }
                }
                if (implementor2 == null) {
                    return implementor;
                }
                implementor.destroy();
                return implementor2;
            }
            object = (Tie)runtimeEndpointInfo.getTieClass().newInstance();
            Remote remote = (Remote)runtimeEndpointInfo.getImplementationClass().newInstance();
            object.setTarget(remote);
            Implementor implementor = new Implementor(null, (Tie)object);
            this.cachedImplementors.put(runtimeEndpointInfo, implementor);
            return implementor;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", runtimeEndpointInfo.getName());
        }
        catch (InstantiationException instantiationException) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", runtimeEndpointInfo.getName());
        }
        catch (ServiceException serviceException) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", runtimeEndpointInfo.getName());
        }
        catch (JAXRPCServletException jAXRPCServletException) {
            throw jAXRPCServletException;
        }
        catch (JAXRPCException jAXRPCException) {
            throw new JAXRPCServletException("error.implementorFactory.servantInitFailed", runtimeEndpointInfo.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseImplementor(RuntimeEndpointInfo runtimeEndpointInfo, Implementor implementor) {
        boolean bl = false;
        ImplementorCache implementorCache = this;
        synchronized (implementorCache) {
            Implementor implementor2 = (Implementor)this.cachedImplementors.get(runtimeEndpointInfo);
            if (implementor2 != implementor) {
                bl = true;
            }
        }
        if (bl) {
            implementor.destroy();
        }
    }

    public void destroy() {
        if (this.servletConfig != null) {
            Iterator iterator = this.cachedImplementors.values().iterator();
            while (iterator.hasNext()) {
                Implementor implementor = (Implementor)iterator.next();
                implementor.destroy();
            }
        }
        try {
            this.cachedImplementors.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }
}

