/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;

public class IndentingWriter
extends BufferedWriter {
    private boolean beginningOfLine = true;
    private int currentIndent = 0;
    private int indentStep = 4;

    public IndentingWriter(Writer writer) {
        super(writer);
    }

    public IndentingWriter(Writer writer, int n) {
        this(writer);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = n;
    }

    public void write(int n) throws IOException {
        this.checkWrite();
        super.write(n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.checkWrite();
        }
        super.write(cArray, n, n2);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.checkWrite();
        }
        super.write(string, n, n2);
    }

    public void newLine() throws IOException {
        super.newLine();
        this.beginningOfLine = true;
    }

    protected void checkWrite() throws IOException {
        if (this.beginningOfLine) {
            this.beginningOfLine = false;
            int n = this.currentIndent;
            while (n > 0) {
                super.write(32);
                --n;
            }
        }
    }

    protected void indentIn() {
        this.currentIndent += this.indentStep;
    }

    protected void indentOut() {
        this.currentIndent -= this.indentStep;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    public void pI() {
        this.indentIn();
    }

    public void pO() {
        this.indentOut();
    }

    public void pI(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.indentIn();
            ++n2;
        }
    }

    public void pO(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.indentOut();
            ++n2;
        }
    }

    public void p(String string) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\t') {
                ++n;
                this.indentIn();
            }
            ++n2;
        }
        this.write(string.substring(n));
        while (n-- > 0) {
            this.indentOut();
        }
    }

    public void p(String string, String string2) throws IOException {
        this.p(string);
        this.p(string2);
    }

    public void p(String string, String string2, String string3) throws IOException {
        this.p(string);
        this.p(string2);
        this.p(string3);
    }

    public void p(String string, String string2, String string3, String string4) throws IOException {
        this.p(string);
        this.p(string2);
        this.p(string3);
        this.p(string4);
    }

    public void p(String string, String string2, String string3, String string4, String string5) throws IOException {
        this.p(string);
        this.p(string2);
        this.p(string3);
        this.p(string4);
        this.p(string5);
    }

    public void pln() throws IOException {
        this.newLine();
    }

    public void pln(String string) throws IOException {
        this.p(string);
        this.pln();
    }

    public void pln(String string, String string2) throws IOException {
        this.p(string, string2);
        this.pln();
    }

    public void pln(String string, String string2, String string3) throws IOException {
        this.p(string, string2, string3);
        this.pln();
    }

    public void pln(String string, String string2, String string3, String string4) throws IOException {
        this.p(string, string2, string3, string4);
        this.pln();
    }

    public void pln(String string, String string2, String string3, String string4, String string5) throws IOException {
        this.p(string, string2, string3, string4, string5);
        this.pln();
    }

    public void plnI(String string) throws IOException {
        this.p(string);
        this.pln();
        this.pI();
    }

    public void pO(String string) throws IOException {
        this.pO();
        this.p(string);
    }

    public void pOln(String string) throws IOException {
        this.pO(string);
        this.pln();
    }

    public void pOlnI(String string) throws IOException {
        this.pO(string);
        this.pln();
        this.pI();
    }

    public void p(Object object) throws IOException {
        this.write(object.toString());
    }

    public void pln(Object object) throws IOException {
        this.p(object.toString());
        this.pln();
    }

    public void plnI(Object object) throws IOException {
        this.p(object.toString());
        this.pln();
        this.pI();
    }

    public void pO(Object object) throws IOException {
        this.pO();
        this.p(object.toString());
    }

    public void pOln(Object object) throws IOException {
        this.pO(object.toString());
        this.pln();
    }

    public void pOlnI(Object object) throws IOException {
        this.pO(object.toString());
        this.pln();
        this.pI();
    }

    public void pM(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(10, n);
            if (n2 == -1) {
                this.p(string.substring(n));
                break;
            }
            this.pln(string.substring(n, n2));
            n = n2 + 1;
        }
    }

    public void pMln(String string) throws IOException {
        this.pM(string);
        this.pln();
    }

    public void pMlnI(String string) throws IOException {
        this.pM(string);
        this.pln();
        this.pI();
    }

    public void pMO(String string) throws IOException {
        this.pO();
        this.pM(string);
    }

    public void pMOln(String string) throws IOException {
        this.pMO(string);
        this.pln();
    }

    public void pF(String string, Object[] objectArray) throws IOException {
        this.pM(MessageFormat.format(string, objectArray));
    }

    public void pFln(String string, Object[] objectArray) throws IOException {
        this.pF(string, objectArray);
        this.pln();
    }
}

