/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class ServiceGenerator
implements ProcessorAction {
    private File sourceDir;
    private ProcessorEnvironment env;
    private Model model;

    public ServiceGenerator() {
        this.sourceDir = null;
        this.env = null;
        this.model = null;
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        ProcessorEnvironment processorEnvironment = configuration.getEnvironment();
        String string = "sourceDirectory";
        String string2 = properties.getProperty(string);
        string = "encodeTypes";
        File file = new File(string2);
        ServiceGenerator serviceGenerator = new ServiceGenerator(processorEnvironment, file, model);
        serviceGenerator.doGeneration();
    }

    private ServiceGenerator(ProcessorEnvironment processorEnvironment, File file, Model model) {
        this.env = processorEnvironment;
        this.model = model;
        this.sourceDir = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGeneration() {
        this.env.getNames().resetPrefixFactory();
        Service service = null;
        try {
            try {
                Iterator iterator = this.model.getServices();
                while (iterator.hasNext()) {
                    service = (Service)iterator.next();
                    this.generateService(service);
                }
            }
            catch (IOException iOException) {
                this.fail("generator.cant.write", service.getName().getLocalPart());
                Object var4_5 = null;
                this.sourceDir = null;
                this.env = null;
            }
            Object var4_4 = null;
            this.sourceDir = null;
            this.env = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.sourceDir = null;
            this.env = null;
            throw throwable;
        }
    }

    private void generateService(Service service) throws IOException {
        try {
            JavaInterface javaInterface = service.getJavaInterface();
            String string = this.env.getNames().interfaceImplClassName(javaInterface);
            String string2 = this.env.getNames().serializerRegistryClassName(javaInterface);
            int n = string2.lastIndexOf(".");
            if (service.getName().getLocalPart().equals(string2.substring(0, n))) {
                string2 = string2.substring(n + 1, string2.length());
            }
            this.log("creating service: " + string);
            String string3 = this.env.getNames().customJavaTypeClassName(javaInterface);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            GeneratorBase.writePackage(indentingWriter, string);
            this.writeImports(indentingWriter);
            indentingWriter.pln();
            this.writeClassDecl(indentingWriter, string, string3);
            this.writeStaticMembers(indentingWriter, service);
            indentingWriter.pln();
            this.writeConstructor(indentingWriter, string, service, string2);
            indentingWriter.pln();
            this.writeGenericGetPortMethods(indentingWriter, service);
            indentingWriter.pln();
            this.writeIndividualGetPorts(indentingWriter, service.getPorts());
            indentingWriter.pOln("}");
            indentingWriter.close();
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(exception));
        }
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.client.ServiceExceptionImpl;");
        indentingWriter.pln("import com.sun.xml.rpc.util.exception.*;");
        indentingWriter.pln("import com.sun.xml.rpc.client.HandlerChainImpl;");
        indentingWriter.pln("import javax.xml.rpc.*;");
        indentingWriter.pln("import javax.xml.rpc.encoding.*;");
        indentingWriter.pln("import javax.xml.rpc.handler.HandlerChain;");
        indentingWriter.pln("import javax.xml.rpc.handler.HandlerInfo;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        StringBuffer stringBuffer2 = stringBuffer.append(Names.stripQualifier(string)).append(" extends com.sun.xml.rpc.client.BasicService").append(" implements ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer2.append(Names.stripQualifier(string2)).append(" {").toString());
    }

    private void writeStaticMembers(IndentingWriter indentingWriter, Service service) throws IOException {
        indentingWriter.p("private static final QName serviceName = ");
        GeneratorUtil.writeNewQName(indentingWriter, service.getName());
        indentingWriter.pln(";");
        Iterator iterator = service.getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            String string = port.getJavaInterface().getName();
            QName qName = port.getName();
            indentingWriter.p("private static final QName " + this.env.getNames().getQNameName(qName) + " = ");
            GeneratorUtil.writeNewQName(indentingWriter, qName);
            indentingWriter.pln(";");
            QName qName2 = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            if (!qName2.equals(qName)) {
                indentingWriter.p("private static final QName " + this.env.getNames().getQNameName(qName2) + " = ");
                GeneratorUtil.writeNewQName(indentingWriter, qName2);
                indentingWriter.pln(";");
            }
            StringBuffer stringBuffer = new StringBuffer().append("private static final Class ");
            this.env.getNames();
            indentingWriter.pln(stringBuffer.append(StringUtils.decapitalize(Names.stripQualifier(string))).append("_PortClass = ").append(string).append(".class;").toString());
        }
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string, Service service, String string2) throws IOException {
        Port port;
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.plnI("super(serviceName, new QName[] {");
        indentingWriter.pI(3);
        Iterator iterator = service.getPorts();
        int n = 0;
        while (iterator.hasNext()) {
            port = (Port)iterator.next();
            if (n > 0) {
                indentingWriter.pln(",");
            }
            indentingWriter.p(this.env.getNames().getQNameName(port.getName()));
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pOln("},");
        indentingWriter.pO(2);
        indentingWriter.pln("new " + string2 + "().getRegistry());");
        indentingWriter.pO();
        iterator = service.getPorts();
        if (iterator.hasNext()) {
            indentingWriter.pln();
            while (iterator.hasNext()) {
                port = (Port)iterator.next();
                HandlerChainInfo handlerChainInfo = port.getClientHandlerChainInfo();
                Iterator iterator2 = handlerChainInfo.getHandlers();
                if (!iterator2.hasNext()) continue;
                indentingWriter.plnI("{");
                indentingWriter.pln("java.util.List handlerInfos = new java.util.Vector();");
                while (iterator2.hasNext()) {
                    Object object;
                    HandlerInfo handlerInfo = (HandlerInfo)iterator2.next();
                    Map map = handlerInfo.getProperties();
                    String string3 = "null";
                    indentingWriter.plnI("{");
                    if (map.size() > 0) {
                        string3 = "props";
                        indentingWriter.pln("java.util.Map " + string3 + " = new java.util.HashMap();");
                        object = map.entrySet().iterator();
                        while (object.hasNext()) {
                            Map.Entry entry = (Map.Entry)object.next();
                            indentingWriter.pln(string3 + ".put(\"" + (String)entry.getKey() + "\", \"" + (String)entry.getValue() + "\");");
                        }
                    }
                    if ((object = handlerInfo.getHeaderNames().toArray()) != null && ((Object[])object).length > 0) {
                        indentingWriter.plnI("QName[] headers = {");
                        int n2 = 0;
                        while (n2 < ((Object[])object).length) {
                            QName qName = (QName)object[n2];
                            indentingWriter.pln("new QName(\"" + qName.getNamespaceURI() + "\"" + ", " + "\"" + qName.getLocalPart() + "\"" + ")" + (n2 != ((Object)object).length - 1 ? "," : ""));
                            ++n2;
                        }
                        indentingWriter.pOln("};");
                    } else {
                        indentingWriter.pln("QName[] headers = null;");
                    }
                    indentingWriter.pln("HandlerInfo handlerInfo = new HandlerInfo(" + handlerInfo.getHandlerClassName() + ".class" + ", " + string3 + ", headers);");
                    indentingWriter.pln("handlerInfos.add(handlerInfo);");
                    indentingWriter.pOln("}");
                }
                indentingWriter.pln("getHandlerRegistry().setHandlerChain(" + this.env.getNames().getQNameName((QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName")) + ", handlerInfos);");
                indentingWriter.pOln("}");
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeGenericGetPortMethods(IndentingWriter indentingWriter, Service service) throws IOException {
        String string;
        String string2;
        Port port;
        Iterator iterator = service.getPorts();
        indentingWriter.plnI("public java.rmi.Remote getPort(QName portName, Class serviceDefInterface) throws ServiceException {");
        indentingWriter.plnI("try {");
        while (iterator.hasNext()) {
            port = (Port)iterator.next();
            string2 = port.getJavaInterface().getName();
            string = this.env.getNames().getPortName(port);
            indentingWriter.plnI("if (portName.equals(" + this.env.getNames().getQNameName(port.getName()) + ") &&");
            StringBuffer stringBuffer = new StringBuffer().append("serviceDefInterface.equals(");
            this.env.getNames();
            indentingWriter.pln(stringBuffer.append(StringUtils.decapitalize(Names.stripQualifier(string2))).append("_PortClass)) {").toString());
            string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
            indentingWriter.pln("return get" + string + "();");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOlnI("} catch (Exception e) {");
        indentingWriter.pln("throw new ServiceExceptionImpl(new LocalizableExceptionAdapter(e));");
        indentingWriter.pOln("}");
        indentingWriter.pln("return super.getPort(portName, serviceDefInterface);");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        iterator = service.getPorts();
        indentingWriter.plnI("public java.rmi.Remote getPort(Class serviceDefInterface) throws ServiceException {");
        indentingWriter.plnI("try {");
        while (iterator.hasNext()) {
            port = (Port)iterator.next();
            string2 = port.getJavaInterface().getName();
            string = this.env.getNames().getPortName(port);
            string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
            StringBuffer stringBuffer = new StringBuffer().append("if (serviceDefInterface.equals(");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(StringUtils.decapitalize(Names.stripQualifier(string2))).append("_PortClass)) {").toString());
            indentingWriter.pln("return get" + string + "();");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOlnI("} catch (Exception e) {");
        indentingWriter.pln("throw new ServiceExceptionImpl(new LocalizableExceptionAdapter(e));");
        indentingWriter.pOln("}");
        indentingWriter.pln("return super.getPort(serviceDefInterface);");
        indentingWriter.pOln("}");
    }

    private void writeIndividualGetPorts(IndentingWriter indentingWriter, Iterator iterator) throws IOException {
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            String string = port.getJavaInterface().getName();
            String string2 = this.env.getNames().getPortName(port);
            QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
            indentingWriter.plnI("public " + string + " get" + string2 + "() {");
            Set set = port.getClientHandlerChainInfo().getRoles();
            indentingWriter.p("String[] roles = new String[] {");
            boolean bl = true;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                if (!bl) {
                    indentingWriter.p(", ");
                } else {
                    bl = false;
                }
                indentingWriter.p("\"" + iterator2.next() + "\"");
            }
            indentingWriter.pln("};");
            indentingWriter.pln("HandlerChainImpl handlerChain = new HandlerChainImpl(getHandlerRegistry().getHandlerChain(" + this.env.getNames().getQNameName(qName) + "));");
            indentingWriter.pln("handlerChain.setRoles(roles);");
            indentingWriter.pln(this.env.getNames().stubFor(port.getJavaInterface()) + " stub = new " + this.env.getNames().stubFor(port.getJavaInterface()) + "(handlerChain);");
            indentingWriter.plnI("try {");
            indentingWriter.pln("stub._initialize(super.internalTypeRegistry);");
            indentingWriter.pOlnI("} catch (JAXRPCException e) {");
            indentingWriter.pln("throw e;");
            indentingWriter.pOlnI("} catch (Exception e) {");
            indentingWriter.pln("throw new JAXRPCException(e.getMessage(), e);");
            indentingWriter.pOln("}");
            indentingWriter.pln("return stub;");
            indentingWriter.pOln("}");
        }
    }

    private void log(String string) {
        if (this.env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            this.env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier(this.getClass().getName())).append(": ").append(string).append("]").toString());
        }
    }

    protected void fail(String string) {
        throw new GeneratorException(string);
    }

    protected void fail(String string, String string2) {
        throw new GeneratorException(string, string2);
    }

    protected void fail(String string, String string2, String string3) {
        throw new GeneratorException(string, new Object[]{string2, string3});
    }

    protected void fail(Localizable localizable) {
        throw new GeneratorException("generator.nestedGeneratorError", localizable);
    }

    protected void fail(Throwable throwable) {
        throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(throwable));
    }
}

