/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.client.BasicService;
import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.ValueTypeSerializer;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.CollectionSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.DynamicSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class SerializerRegistryGenerator
extends GeneratorBase {
    private static final String SERIALIZER_FACTORY = "serializerFactory";
    private static final String DESERIALIZER_FACTORY = "deserializerFactory";
    private static final String MAPPING = "mapping";
    private static final String LITERAL_MAPPING = "mapping2";
    private boolean haveCustom = false;
    private Model model;
    private Set visitedTypes;
    static /* synthetic */ Class array$B;

    public SerializerRegistryGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new SerializerRegistryGenerator(model, configuration, properties);
    }

    private SerializerRegistryGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.model = model;
    }

    protected void preVisitService(Service service) throws Exception {
        this.visitedTypes = new HashSet();
        Iterator iterator = this.model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (!abstractType.isSOAPType()) continue;
            ((SOAPType)abstractType).accept(this);
        }
    }

    protected void postVisitService(Service service) throws Exception {
        try {
            this.generateSerializerRegistry(service);
        }
        catch (IOException iOException) {
            GeneratorBase.fail("generator.cant.write", service.getName().getLocalPart());
        }
        this.visitedTypes = null;
    }

    protected void visitParameter(Parameter parameter) throws Exception {
        AbstractType abstractType = parameter.getType();
        if (abstractType.isSOAPType()) {
            ((SOAPType)abstractType).accept(this);
        }
    }

    protected void preVisitResponse(Response response) throws Exception {
        Iterator iterator = response.getParameters();
        while (iterator.hasNext()) {
            ((Parameter)iterator.next()).accept(this);
        }
    }

    protected void preVisitRequest(Request request) throws Exception {
        Iterator iterator = request.getParameters();
        while (iterator.hasNext()) {
            ((Parameter)iterator.next()).accept(this);
        }
    }

    public void visit(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        } else if (fault.getBlock().getType().isLiteralType()) {
            ((LiteralType)fault.getBlock().getType()).accept(this);
        }
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        if (this.haveVisited(sOAPCustomType)) {
            return;
        }
        this.typeVisited(sOAPCustomType);
        this.haveCustom = true;
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
        if (this.haveVisited(sOAPSimpleType)) {
            return;
        }
        this.typeVisited(sOAPSimpleType);
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        if (this.haveVisited(sOAPAnyType)) {
            return;
        }
        this.typeVisited(sOAPAnyType);
        this.haveCustom = true;
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.haveVisited(sOAPEnumerationType)) {
            return;
        }
        this.typeVisited(sOAPEnumerationType);
    }

    public void preVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.haveVisited(sOAPArrayType)) {
            return;
        }
        this.typeVisited(sOAPArrayType);
    }

    public void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.haveVisited(sOAPStructureType)) {
            return;
        }
        this.typeVisited(sOAPStructureType);
    }

    public void visit(LiteralSimpleType literalSimpleType) throws Exception {
        if (this.haveVisited(literalSimpleType)) {
            return;
        }
        this.typeVisited(literalSimpleType);
    }

    public void visit(LiteralFragmentType literalFragmentType) throws Exception {
        if (this.haveVisited(literalFragmentType)) {
            return;
        }
        this.typeVisited(literalFragmentType);
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
        if (this.haveVisited(literalSequenceType)) {
            return;
        }
        this.typeVisited(literalSequenceType);
    }

    public void preVisitLiteralAllType(LiteralAllType literalAllType) throws Exception {
        if (this.haveVisited(literalAllType)) {
            return;
        }
        this.typeVisited(literalAllType);
    }

    private boolean haveVisited(AbstractType abstractType) {
        return this.visitedTypes.contains(abstractType);
    }

    private void typeVisited(AbstractType abstractType) {
        this.visitedTypes.add(abstractType);
    }

    private void generateSerializerRegistry(Service service) throws IOException {
        try {
            JavaInterface javaInterface = service.getJavaInterface();
            String string = this.env.getNames().serializerRegistryClassName(javaInterface);
            this.log("creating serializer registry: " + string);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            GeneratorBase.writePackage(indentingWriter, string);
            this.writeImports(indentingWriter);
            indentingWriter.pln();
            this.writeClassDecl(indentingWriter, string);
            this.writeConstructor(indentingWriter, string);
            indentingWriter.pln();
            this.writeGetRegistry(indentingWriter);
            indentingWriter.pln();
            this.writeStatics(indentingWriter);
            indentingWriter.pOln("}");
            indentingWriter.close();
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(exception));
        }
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.client.BasicService;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.soap.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.literal.*;");
        indentingWriter.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        indentingWriter.pln("import javax.xml.rpc.*;");
        indentingWriter.pln("import javax.xml.rpc.encoding.*;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" implements SerializerConstants {").toString());
    }

    private void writeStatics(IndentingWriter indentingWriter) throws IOException, Exception {
        indentingWriter.plnI("private static void registerSerializer(TypeMapping mapping, Class javaType, QName xmlType,");
        indentingWriter.pln("Serializer ser) {");
        indentingWriter.plnI("mapping.register(javaType, xmlType, new SingletonSerializerFactory(ser),");
        indentingWriter.pln("new SingletonDeserializerFactory((Deserializer)ser));");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pln();
    }

    private boolean mappingExistsForType(TypeMapping typeMapping, AbstractType abstractType) {
        try {
            SerializerFactory serializerFactory;
            Serializer serializer;
            Class<Object> clazz = null;
            String string = abstractType.getJavaType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(string)) {
                if (string.equals(Boolean.TYPE.toString())) {
                    clazz = Boolean.TYPE;
                } else if (string.equals(ModelerConstants.BYTE_CLASSNAME)) {
                    clazz = Byte.TYPE;
                } else if (string.equals(ModelerConstants.DOUBLE_CLASSNAME)) {
                    clazz = Double.TYPE;
                } else if (string.equals(ModelerConstants.INT_CLASSNAME)) {
                    clazz = Integer.TYPE;
                } else if (string.equals(ModelerConstants.FLOAT_CLASSNAME)) {
                    clazz = Float.TYPE;
                } else if (string.equals(ModelerConstants.LONG_CLASSNAME)) {
                    clazz = Long.TYPE;
                } else if (string.equals(ModelerConstants.SHORT_CLASSNAME)) {
                    clazz = Short.TYPE;
                }
            }
            if (clazz == null) {
                clazz = string.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME) ? (array$B == null ? (array$B = SerializerRegistryGenerator.class$("[B")) : array$B) : Class.forName(string);
            }
            if (!((serializer = (serializerFactory = typeMapping.getSerializer(clazz, abstractType.getName())).getSerializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/")) instanceof CombinedSerializer) || !(((CombinedSerializer)serializer).getInnermostSerializer() instanceof ValueTypeSerializer)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.pOln("}");
    }

    private void writeGetRegistry(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("public TypeMappingRegistry getRegistry() {");
        HashSet<String> hashSet = new HashSet<String>();
        indentingWriter.pln();
        indentingWriter.pln("TypeMappingRegistry registry = BasicService.createStandardTypeMappingRegistry();");
        indentingWriter.pln("TypeMapping mapping = registry.getTypeMapping(SOAPConstants.NS_SOAP_ENCODING);");
        indentingWriter.pln("TypeMapping mapping2 = registry.getTypeMapping(\"\");");
        TypeMappingRegistry typeMappingRegistry = BasicService.createStandardTypeMappingRegistry();
        TypeMapping typeMapping = typeMappingRegistry.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
        Iterator iterator = this.visitedTypes.iterator();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (abstractType.getJavaType().getName().equals(ModelerConstants.VOID_CLASSNAME) || hashSet.contains(abstractType.getName() + ";" + abstractType.getJavaType().getRealName())) continue;
            hashSet.add(abstractType.getName() + ";" + abstractType.getJavaType().getRealName());
            SerializerWriter serializerWriter = this.writerFactory.createWriter(abstractType);
            if (serializerWriter instanceof SimpleTypeSerializerWriter || serializerWriter instanceof CollectionSerializerWriter || serializerWriter instanceof DynamicSerializerWriter) {
                if (this.mappingExistsForType(typeMapping, abstractType)) continue;
                this.warn("generator.serializerRegistryGenerator.warning.no.standard.simpletype.serialzer", new Object[]{abstractType.getName().toString(), abstractType.getJavaType().getRealName()});
            }
            indentingWriter.plnI("{");
            if (abstractType.isSOAPType()) {
                serializerWriter.registerSerializer(indentingWriter, this.encodeTypes, this.multiRefEncoding, MAPPING);
            } else if (abstractType.isLiteralType()) {
                serializerWriter.registerSerializer(indentingWriter, this.encodeTypes, this.multiRefEncoding, LITERAL_MAPPING);
            }
            indentingWriter.pOln("}");
        }
        indentingWriter.pln("return registry;");
        indentingWriter.pOln("}");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

