/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerBase;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;

public class ObjectArraySerializer
extends ArraySerializerBase
implements Initializable {
    protected JAXRPCSerializer elemSer;
    protected JAXRPCDeserializer elemDeser;

    public ObjectArraySerializer(QName qName, boolean bl, boolean bl2, String string, QName qName2, QName qName3, Class clazz, int n, int[] nArray) {
        super(qName, bl, bl2, string, qName2, qName3, clazz, n, nArray);
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        this.elemSer = (JAXRPCSerializer)internalTypeMappingRegistry.getSerializer(this.encodingStyle, this.elemClass, this.elemType);
        this.elemDeser = (JAXRPCDeserializer)internalTypeMappingRegistry.getDeserializer(this.encodingStyle, this.elemClass, this.elemType);
    }

    protected void serializeArrayInstance(Object object, int[] nArray, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        this.serializeArrayElements((Object[])object, 0, nArray, xMLWriter, sOAPSerializationContext);
    }

    protected void serializeArrayElements(Object[] objectArray, int n, int[] nArray, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        if (objectArray == null || objectArray.length != nArray[n]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean bl = n == nArray.length - 1;
        int n2 = 0;
        while (n2 < nArray[n]) {
            Object object = objectArray[n2];
            if (bl) {
                this.elemSer.serialize(object, this.elemName, null, xMLWriter, sOAPSerializationContext);
            } else {
                this.serializeArrayElements((Object[])object, n + 1, nArray, xMLWriter, sOAPSerializationContext);
            }
            ++n2;
        }
    }

    protected Object deserializeArrayInstance(XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext, int[] nArray) throws Exception {
        String string = this.getID(xMLReader);
        SOAPDeserializationState sOAPDeserializationState = string != null ? sOAPDeserializationContext.getStateFor(string) : null;
        boolean bl = true;
        int n = 1024;
        int n2 = 4096;
        boolean bl2 = ArraySerializerBase.isEmptyDimensions(nArray);
        if (!bl2 && this.dimLargerThan(nArray, n2)) {
            bl2 = true;
            n = n2;
        }
        int[] nArray2 = ArraySerializerBase.getDimensionOffsets(nArray);
        int[] nArray3 = ArraySerializerBase.getArrayOffset(xMLReader, nArray);
        if (nArray3 == null) {
            nArray3 = new int[bl2 ? 1 : nArray.length];
        }
        Object[] objectArray = null;
        int n3 = 0;
        int n4 = 0;
        if (xMLReader.nextElementContent() != 2) {
            Object[] objectArray2;
            boolean bl3;
            int[] nArray4 = ArraySerializerBase.getArrayElementPosition(xMLReader, nArray);
            boolean bl4 = bl3 = nArray4 != null;
            if (!bl3) {
                nArray4 = nArray3;
            }
            if (bl2) {
                n3 = nArray4[0];
                n4 = Math.max(n3 * 2, n);
                objectArray = (Object[])Array.newInstance(this.elemClass, n4);
            } else {
                objectArray = (Object[])Array.newInstance(this.elemClass, nArray);
            }
            while (true) {
                if (!bl2 && !ArraySerializerBase.isPositionWithinBounds(nArray4, nArray)) {
                    if (bl3) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(nArray4));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (bl2 && nArray4[0] >= n4) {
                    int n5 = n4 * 2;
                    while (nArray4[0] >= n5) {
                        n5 *= 2;
                    }
                    objectArray2 = (Object[])Array.newInstance(this.elemClass, n5);
                    System.arraycopy(objectArray, 0, objectArray2, 0, n4);
                    objectArray = objectArray2;
                    n4 = n5;
                }
                Object object = null;
                object = this.elemDeser.deserialize(null, xMLReader, sOAPDeserializationContext);
                if (object instanceof SOAPDeserializationState) {
                    objectArray2 = (Object[])object;
                    bl = false;
                    if (sOAPDeserializationState == null) {
                        sOAPDeserializationState = new SOAPDeserializationState();
                    }
                    sOAPDeserializationState.setInstance(objectArray);
                    if (sOAPDeserializationState.getBuilder() == null) {
                        sOAPDeserializationState.setBuilder(new ObjectArrayInstanceBuilder(nArray2));
                    }
                    objectArray2.registerListener(sOAPDeserializationState, ArraySerializerBase.indexFromPosition(nArray4, nArray2));
                } else {
                    ObjectArraySerializer.setElement(objectArray, nArray4, object);
                }
                if (xMLReader.nextElementContent() == 2) break;
                if (bl3) {
                    nArray4 = ArraySerializerBase.getArrayElementPosition(xMLReader, nArray);
                    if (nArray4 == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (bl2) {
                    nArray4[0] = nArray4[0] + 1;
                } else {
                    ArraySerializerBase.incrementPosition(nArray4, nArray);
                }
                if (!bl2) continue;
                n3 = Math.max(nArray4[0], n3);
            }
            if (bl2 && n4 != n3 + 1) {
                int n6 = n3 + 1;
                objectArray2 = (Object[])Array.newInstance(this.elemClass, n6);
                System.arraycopy(objectArray, 0, objectArray2, 0, n6);
                objectArray = objectArray2;
                n4 = n6;
            }
        } else {
            objectArray = bl2 ? (Object[])Array.newInstance(this.elemClass, 0) : (Object[])Array.newInstance(this.elemClass, nArray);
        }
        if (sOAPDeserializationState != null) {
            sOAPDeserializationState.setDeserializer(this);
            sOAPDeserializationState.setInstance(objectArray);
            sOAPDeserializationState.doneReading();
        }
        if (bl) {
            return objectArray;
        }
        return sOAPDeserializationState;
    }

    public static void setElement(Object[] objectArray, int[] nArray, Object object) {
        Object[] objectArray2 = objectArray;
        int n = 0;
        while (n < nArray.length - 1) {
            objectArray2 = (Object[])objectArray2[nArray[n]];
            ++n;
        }
        objectArray2[nArray[nArray.length - 1]] = object;
    }

    private boolean dimLargerThan(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] > n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class ObjectArrayInstanceBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;
        int[] dimOffsets = null;

        ObjectArrayInstanceBuilder(int[] nArray) {
            this.dimOffsets = nArray;
        }

        public int memberGateType(int n) {
            return 6;
        }

        public void construct() {
            throw new IllegalStateException();
        }

        public void setMember(int n, Object object) {
            int[] nArray = ArraySerializerBase.positionFromIndex(n, this.dimOffsets);
            ObjectArraySerializer.setElement(this.instance, nArray, object);
        }

        public void initialize() {
        }

        public void setInstance(Object object) {
            this.instance = (Object[])object;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

