/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RfcDateParser {
    private static final String debugProp = "hotjava.debug.RfcDateParser";
    private boolean isGMT = false;
    static final String[] standardFormats = new String[]{"EEEE', 'dd-MMM-yy HH:mm:ss z", "EEEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy HH:mm:ss z", "EEEE', 'dd MMM yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy hh:mm:ss z", "EEEE', 'dd MMM yyyy hh:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss"};
    static final String[] gmtStandardFormats = new String[]{"EEEE',' dd-MMM-yy HH:mm:ss 'GMT'", "EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEE MMM dd HH:mm:ss 'GMT' yyyy"};
    String dateString;

    public RfcDateParser(String string) {
        this.dateString = string.trim();
        if (this.dateString.indexOf("GMT") != -1) {
            this.isGMT = true;
        }
    }

    public Date getDate() {
        int n = this.isGMT ? gmtStandardFormats.length : standardFormats.length;
        int n2 = 0;
        while (n2 < n) {
            Date date = this.isGMT ? this.tryParsing(gmtStandardFormats[n2]) : this.tryParsing(standardFormats[n2]);
            if (date != null) {
                return date;
            }
            ++n2;
        }
        return null;
    }

    private Date tryParsing(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        if (this.isGMT) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        try {
            return simpleDateFormat.parse(this.dateString);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

