/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

public class ServiceInfoBuilder {
    protected WSDLModelInfo modelInfo;
    protected QName serviceName;
    static /* synthetic */ Class class$javax$xml$soap$SOAPMessage;

    public ServiceInfoBuilder(String string, QName qName) {
        ClientProcessorEnvironment clientProcessorEnvironment = new ClientProcessorEnvironment(new ByteArrayOutputStream(), "", null);
        Configuration configuration = new Configuration(clientProcessorEnvironment);
        this.modelInfo = new WSDLModelInfo();
        configuration.setModelInfo(this.modelInfo);
        this.modelInfo.setParent(configuration);
        this.modelInfo.setLocation(string);
        this.serviceName = qName;
        this.modelInfo.setName(qName.getLocalPart());
    }

    public void setPackage(String string) {
        this.modelInfo.setJavaPackageName(string);
    }

    public ServiceInfo buildServiceInfo() {
        Model model = this.getModel();
        Service service = model.getServiceByName(this.serviceName);
        if (service == null) {
            String string = "";
            Iterator iterator = model.getServices();
            while (iterator.hasNext()) {
                Service service2 = (Service)iterator.next();
                string = string + service2.getName().toString();
                if (!iterator.hasNext()) continue;
                string = string + "\n";
            }
            throw new DynamicInvocationException("dii.wsdl.service.unknown", new Object[]{this.serviceName, string});
        }
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setDefaultNamespace(model.getTargetNamespaceURI());
        Iterator iterator = service.getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            PortInfo portInfo = serviceInfo.getPortInfo((QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName"));
            portInfo.setPortTypeName((QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName"));
            this.buildPortInfo(portInfo, port);
        }
        return serviceInfo;
    }

    protected Model getModel() {
        Properties properties = new Properties();
        properties.put("validationWSDL", new Boolean(false));
        properties.put("explicitServiceContext", new Boolean(false));
        return this.modelInfo.buildModel(properties);
    }

    protected void buildPortInfo(PortInfo portInfo, Port port) {
        portInfo.setTargetEndpoint(port.getAddress());
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            OperationInfo operationInfo = portInfo.createOperationForName(operation.getName().getLocalPart());
            this.buildOperationInfo(operationInfo, operation);
        }
    }

    protected void buildOperationInfo(OperationInfo operationInfo, Operation operation) {
        if (operation.getStyle() == SOAPStyle.DOCUMENT) {
            this.buildDocumentOperation(operationInfo, operation);
        } else {
            this.buildRpcOperation(operationInfo, operation);
        }
    }

    protected void buildRpcOperation(OperationInfo operationInfo, Operation operation) {
        QName qName;
        SOAPStructureMember sOAPStructureMember;
        Parameter parameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        Request request = operation.getRequest();
        Response response = operation.getResponse();
        Block block = (Block)request.getBodyBlocks().next();
        Block block2 = (Block)response.getBodyBlocks().next();
        RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType = (RPCRequestUnorderedStructureType)block.getType();
        RPCResponseStructureType rPCResponseStructureType = (RPCResponseStructureType)block2.getType();
        Iterator iterator = request.getParameters();
        Iterator iterator2 = response.getParameters();
        Iterator iterator3 = rPCRequestUnorderedStructureType.getMembers();
        Iterator iterator4 = rPCResponseStructureType.getMembers();
        JavaType javaType = javaMethod.getReturnType();
        if (!"void".equals(javaType.getName())) {
            parameter = (Parameter)iterator2.next();
            sOAPStructureMember = (SOAPStructureMember)iterator4.next();
            qName = parameter.getType().getName();
            Class clazz = this.getJavaClassFor(parameter.getType());
            operationInfo.setReturnType(qName, clazz);
        }
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            sOAPStructureMember = (SOAPStructureMember)iterator3.next();
            qName = ParameterMode.IN;
            if (parameter.getLinkedParameter() != null) {
                qName = ParameterMode.INOUT;
            }
            this.addParameterTo(operationInfo, sOAPStructureMember, (ParameterMode)qName);
        }
        while (iterator2.hasNext()) {
            parameter = (Parameter)iterator2.next();
            sOAPStructureMember = (SOAPStructureMember)iterator4.next();
            if (parameter.getLinkedParameter() != null) continue;
            this.addParameterTo(operationInfo, sOAPStructureMember, ParameterMode.OUT);
        }
        operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "rpc");
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "http://schemas.xmlsoap.org/soap/encoding/");
    }

    protected void buildDocumentOperation(OperationInfo operationInfo, Operation operation) {
        JavaMethod javaMethod = operation.getJavaMethod();
        Request request = operation.getRequest();
        Response response = operation.getResponse();
        Block block = (Block)request.getBodyBlocks().next();
        Block block2 = (Block)response.getBodyBlocks().next();
        operationInfo.addParameter(block.getName().getLocalPart(), block.getType().getName(), class$javax$xml$soap$SOAPMessage == null ? (class$javax$xml$soap$SOAPMessage = ServiceInfoBuilder.class$("javax.xml.soap.SOAPMessage")) : class$javax$xml$soap$SOAPMessage, ParameterMode.IN);
        operationInfo.setReturnType(block2.getType().getName(), class$javax$xml$soap$SOAPMessage == null ? (class$javax$xml$soap$SOAPMessage = ServiceInfoBuilder.class$("javax.xml.soap.SOAPMessage")) : class$javax$xml$soap$SOAPMessage);
        operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "document");
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "");
    }

    protected void addParameterTo(OperationInfo operationInfo, SOAPStructureMember sOAPStructureMember, ParameterMode parameterMode) {
        String string = sOAPStructureMember.getName().getLocalPart();
        QName qName = sOAPStructureMember.getType().getName();
        Class clazz = this.getJavaClassFor(sOAPStructureMember.getType());
        operationInfo.addParameter(string, qName, clazz, parameterMode);
    }

    protected Class getJavaClassFor(AbstractType abstractType) {
        JavaType javaType = abstractType.getJavaType();
        String string = javaType.getRealName();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {}
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

