/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.NamedNodeMapIterator;
import com.sun.xml.rpc.util.xml.NullEntityResolver;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaParser {
    private boolean _followImports;
    private static final String PREFIX_XMLNS = "xmlns";
    private static final String PREFIX_XMLNS_COLON = "xmlns:";

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean bl) {
        this._followImports = bl;
    }

    public SchemaDocument parse(InputSource inputSource) {
        SchemaDocument schemaDocument = new SchemaDocument();
        schemaDocument.setSystemId(inputSource.getSystemId());
        ParserContext parserContext = new ParserContext(schemaDocument, null);
        parserContext.setFollowImports(this._followImports);
        schemaDocument.setSchema(this.parseSchema(parserContext, inputSource, null));
        return schemaDocument;
    }

    public Schema parseSchema(ParserContext parserContext, InputSource inputSource, String string) {
        Schema schema = this.parseSchemaNoImport(parserContext, inputSource, string);
        schema.defineAllEntities();
        this.processImports(parserContext, inputSource, schema);
        return schema;
    }

    public Schema parseSchema(ParserContext parserContext, Element element, String string) {
        Schema schema = this.parseSchemaNoImport(parserContext, element, string);
        schema.defineAllEntities();
        this.processImports(parserContext, null, schema);
        return schema;
    }

    protected void processImports(ParserContext parserContext, InputSource inputSource, Schema schema) {
        Iterator iterator = schema.getContent().children();
        while (iterator.hasNext()) {
            SchemaElement schemaElement = (SchemaElement)iterator.next();
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_IMPORT)) {
                String string = schemaElement.getValueOfAttributeOrNull("schemaLocation");
                String string2 = schemaElement.getValueOfAttributeOrNull("namespace");
                if (string == null || parserContext.getDocument().isImportedDocument(string)) continue;
                parserContext.getDocument().addImportedDocument(string);
                String string3 = null;
                if (inputSource != null && inputSource.getSystemId() != null) {
                    string3 = Util.processSystemIdWithBase(inputSource.getSystemId(), string);
                }
                if (string3 == null) {
                    string3 = parserContext.getDocument().getSystemId() == null ? string : Util.processSystemIdWithBase(parserContext.getDocument().getSystemId(), string);
                }
                parserContext.getDocument().addImportedEntity(this.parseSchema(parserContext, new InputSource(string3), string2));
                continue;
            }
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_INCLUDE)) {
                Util.fail("validation.unsupportedSchemaFeature", "include");
                continue;
            }
            if (!schemaElement.getQName().equals(SchemaConstants.QNAME_REDEFINE)) continue;
            Util.fail("validation.unsupportedSchemaFeature", "redefine");
        }
    }

    protected Schema parseSchemaNoImport(ParserContext parserContext, InputSource inputSource, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                }
            });
            documentBuilder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = documentBuilder.parse(inputSource);
                return this.parseSchemaNoImport(parserContext, document, string);
            }
            catch (IOException iOException) {
                throw new ParseException("parsing.ioException", new LocalizableExceptionAdapter(iOException));
            }
            catch (SAXException sAXException) {
                throw new ParseException("parsing.saxException", new LocalizableExceptionAdapter(sAXException));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException("parsing.parserConfigException", new LocalizableExceptionAdapter(parserConfigurationException));
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ParseException("parsing.factoryConfigException", new LocalizableExceptionAdapter(factoryConfigurationError));
        }
    }

    protected Schema parseSchemaNoImport(ParserContext parserContext, Document document, String string) {
        Element element = document.getDocumentElement();
        Util.verifyTagNSRootElement(element, SchemaConstants.QNAME_SCHEMA);
        return this.parseSchemaNoImport(parserContext, element, string);
    }

    protected Schema parseSchemaNoImport(ParserContext parserContext, Element element, String string) {
        Object object;
        Schema schema = new Schema(parserContext.getDocument());
        String string2 = XmlUtil.getAttributeOrNull(element, "targetNamespace");
        if (string != null && !string.equals(string2)) {
            throw new ValidationException("validation.incorrectTargetNamespace", new Object[]{string2, string});
        }
        schema.setTargetNamespaceURI(string2);
        Iterator iterator = parserContext.getPrefixes();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string3 = parserContext.getNamespaceURI((String)object);
            if (string3 == null) {
                throw new ParseException("parsing.shouldNotHappen");
            }
            schema.addPrefix((String)object, string3);
        }
        parserContext.push();
        parserContext.registerNamespaces(element);
        object = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
        this.copyNamespaceDeclarations((SchemaElement)object, element);
        this.copyAttributesNoNs((SchemaElement)object, element);
        this.copyElementContent((SchemaElement)object, element);
        schema.setContent((SchemaElement)object);
        ((SchemaElement)object).setSchema(schema);
        parserContext.pop();
        parserContext.fireDoneParsingEntity(SchemaConstants.QNAME_SCHEMA, schema);
        return schema;
    }

    protected void copyAttributesNoNs(SchemaElement schemaElement, Element element) {
        NamedNodeMapIterator namedNodeMapIterator = new NamedNodeMapIterator(element.getAttributes());
        while (namedNodeMapIterator.hasNext()) {
            Attr attr = (Attr)namedNodeMapIterator.next();
            if (attr.getName().equals(PREFIX_XMLNS) || attr.getName().startsWith(PREFIX_XMLNS_COLON)) continue;
            SchemaAttribute schemaAttribute = new SchemaAttribute(attr.getLocalName());
            schemaAttribute.setNamespaceURI(attr.getNamespaceURI());
            schemaAttribute.setValue(attr.getValue());
            schemaElement.addAttribute(schemaAttribute);
        }
    }

    protected void copyNamespaceDeclarations(SchemaElement schemaElement, Element element) {
        NamedNodeMapIterator namedNodeMapIterator = new NamedNodeMapIterator(element.getAttributes());
        while (namedNodeMapIterator.hasNext()) {
            Attr attr = (Attr)namedNodeMapIterator.next();
            if (attr.getName().equals(PREFIX_XMLNS)) {
                schemaElement.addPrefix("", attr.getValue());
                continue;
            }
            String string = XmlUtil.getPrefix(attr.getName());
            if (string == null || !string.equals(PREFIX_XMLNS)) continue;
            String string2 = XmlUtil.getLocalPart(attr.getName());
            String string3 = attr.getValue();
            schemaElement.addPrefix(string2, string3);
        }
    }

    protected void copyElementContent(SchemaElement schemaElement, Element element) {
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElementIgnoringCharacterContent(iterator);
            if (element2 == null) break;
            SchemaElement schemaElement2 = new SchemaElement(element2.getLocalName());
            schemaElement2.setNamespaceURI(element2.getNamespaceURI());
            this.copyNamespaceDeclarations(schemaElement2, element2);
            this.copyAttributesNoNs(schemaElement2, element2);
            this.copyElementContent(schemaElement2, element2);
            schemaElement.addChild(schemaElement2);
            schemaElement2.setParent(schemaElement);
        }
    }
}

