/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.mime.MIMEConstants;
import com.sun.xml.rpc.wsdl.document.mime.MIMEContent;
import com.sun.xml.rpc.wsdl.document.mime.MIMEMultipartRelated;
import com.sun.xml.rpc.wsdl.document.mime.MIMEPart;
import com.sun.xml.rpc.wsdl.document.mime.MIMEXml;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class MIMEExtensionHandler
extends ExtensionHandler {
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/mime/";
    }

    public boolean doHandleExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (extensible.getElementName().equals(WSDLConstants.QNAME_OUTPUT)) {
            return this.handleInputOutputExtension(parserContext, extensible, element);
        }
        if (extensible.getElementName().equals(WSDLConstants.QNAME_INPUT)) {
            return this.handleInputOutputExtension(parserContext, extensible, element);
        }
        if (extensible.getElementName().equals(MIMEConstants.QNAME_PART)) {
            return this.handleMIMEPartExtension(parserContext, extensible, element);
        }
        parserContext.fireIgnoringExtension(new QName(element.getNamespaceURI(), element.getLocalName()), extensible.getElementName());
        return false;
    }

    protected boolean handleInputOutputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MULTIPART_RELATED)) {
            parserContext.push();
            parserContext.registerNamespaces(element);
            MIMEMultipartRelated mIMEMultipartRelated = new MIMEMultipartRelated();
            Iterator iterator = XmlUtil.getAllChildren(element);
            while (iterator.hasNext()) {
                Element element2 = Util.nextElement(iterator);
                if (element2 == null) break;
                if (XmlUtil.matchesTagNS(element2, MIMEConstants.QNAME_PART)) {
                    parserContext.push();
                    parserContext.registerNamespaces(element2);
                    MIMEPart mIMEPart = new MIMEPart();
                    String string = XmlUtil.getAttributeOrNull(element2, "name");
                    if (string != null) {
                        mIMEPart.setName(string);
                    }
                    Iterator iterator2 = XmlUtil.getAllChildren(element2);
                    while (iterator2.hasNext()) {
                        Element element3 = Util.nextElement(iterator2);
                        if (element3 == null) break;
                        ExtensionHandler extensionHandler = (ExtensionHandler)this._extensionHandlers.get(element3.getNamespaceURI());
                        boolean bl = false;
                        if (extensionHandler != null) {
                            bl = extensionHandler.doHandleExtension(parserContext, mIMEPart, element3);
                        }
                        if (bl) continue;
                        String string2 = XmlUtil.getAttributeNSOrNull(element3, "required", "http://schemas.xmlsoap.org/wsdl/");
                        if (string2 != null && string2.equals("true")) {
                            Util.fail("parsing.requiredExtensibilityElement", element3.getTagName(), element3.getNamespaceURI());
                            continue;
                        }
                        parserContext.fireIgnoringExtension(new QName(element3.getNamespaceURI(), element3.getLocalName()), mIMEPart.getElementName());
                    }
                    mIMEMultipartRelated.add(mIMEPart);
                    parserContext.pop();
                    parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_PART, mIMEPart);
                    continue;
                }
                Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
            }
            extensible.addExtension(mIMEMultipartRelated);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_MULTIPART_RELATED, mIMEMultipartRelated);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent mIMEContent = this.parseMIMEContent(parserContext, element);
            extensible.addExtension(mIMEContent);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mIMEXml = this.parseMIMEXml(parserContext, element);
            extensible.addExtension(mIMEXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleMIMEPartExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent mIMEContent = this.parseMIMEContent(parserContext, element);
            extensible.addExtension(mIMEContent);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mIMEXml = this.parseMIMEXml(parserContext, element);
            extensible.addExtension(mIMEXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected MIMEContent parseMIMEContent(ParserContext parserContext, Element element) {
        String string;
        parserContext.push();
        parserContext.registerNamespaces(element);
        MIMEContent mIMEContent = new MIMEContent();
        String string2 = XmlUtil.getAttributeOrNull(element, "part");
        if (string2 != null) {
            mIMEContent.setPart(string2);
        }
        if ((string = XmlUtil.getAttributeOrNull(element, "type")) != null) {
            mIMEContent.setType(string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_CONTENT, mIMEContent);
        return mIMEContent;
    }

    protected MIMEXml parseMIMEXml(ParserContext parserContext, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        MIMEXml mIMEXml = new MIMEXml();
        String string = XmlUtil.getAttributeOrNull(element, "part");
        if (string != null) {
            mIMEXml.setPart(string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_MIME_XML, mIMEXml);
        return mIMEXml;
    }

    public void doHandleExtension(WriterContext writerContext, Extension extension) throws IOException {
        if (extension instanceof MIMEContent) {
            MIMEContent mIMEContent = (MIMEContent)extension;
            writerContext.writeStartTag(mIMEContent.getElementName());
            writerContext.writeAttribute("part", mIMEContent.getPart());
            writerContext.writeAttribute("type", mIMEContent.getType());
            writerContext.writeEndTag(mIMEContent.getElementName());
        } else if (extension instanceof MIMEXml) {
            MIMEXml mIMEXml = (MIMEXml)extension;
            writerContext.writeStartTag(mIMEXml.getElementName());
            writerContext.writeAttribute("part", mIMEXml.getPart());
            writerContext.writeEndTag(mIMEXml.getElementName());
        } else if (extension instanceof MIMEMultipartRelated) {
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)extension;
            writerContext.writeStartTag(mIMEMultipartRelated.getElementName());
            Iterator iterator = mIMEMultipartRelated.getParts();
            while (iterator.hasNext()) {
                MIMEPart mIMEPart = (MIMEPart)iterator.next();
                writerContext.writeStartTag(mIMEPart.getElementName());
                Iterator iterator2 = mIMEPart.extensions();
                while (iterator2.hasNext()) {
                    Extension extension2 = (Extension)iterator2.next();
                    ExtensionHandler extensionHandler = (ExtensionHandler)this._extensionHandlers.get(extension2.getElementName().getNamespaceURI());
                    if (extensionHandler == null) continue;
                    extensionHandler.doHandleExtension(writerContext, extension2);
                }
                writerContext.writeEndTag(mIMEPart.getElementName());
            }
            writerContext.writeEndTag(mIMEMultipartRelated.getElementName());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

